/* $Id: mat_imagingdetector.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imagingdetector.h $
 */

#ifndef MAT_IMAGINGDETECTOR_H
#define MAT_IMAGINGDETECTOR_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "mat_region.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/* Structure mat_imagingdetector */
/**
   @ingroup imgdet
   @brief Structure containing the IMAGING_DETECTOR binary table of a raw data
   file.
*/
typedef struct {
  //char         *origin;                        /*!< origin of the data          */
    char         *instrument;                    /*!< instrument name             */
    double        dateobsmjd;                    /*!< observation date (MJD)      */
    char         *dateobs;                       /*!< observation date            */
  //char         *date;                          /*!< HDU creation date           */
    char         *dcsdictionaryid;               /*!< data dic name               */
    char         *dcsid;                         /*!< DCS software version string */
    int           nbdetector;                    /*!< number of detectors         */
    int           nbtel;                         /*!< number of telescopes        */
    int           nbregion;                      /*!< number of regions           */
    mat_region  **list_region;                   /*!< array of regions            */
} mat_imagingdetector;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_imagingdetector *mat_imagingdetector_new(cpl_propertylist *plist,
					     int nbregion);

cpl_error_code mat_imagingdetector_delete(mat_imagingdetector *imgdetector);

mat_imagingdetector *mat_imagingdetector_from_table(cpl_propertylist *plist, 
						    cpl_table *table);

cpl_table *mat_imagingdetector_to_table(mat_imagingdetector *imgdet,
					cpl_propertylist *plist);

cpl_error_code mat_imagingdetector_save(mat_imagingdetector *imgdet,
                                        cpl_propertylist *plist,
                                        const char *filename);

mat_imagingdetector *mat_imagingdetector_duplicate(const mat_imagingdetector * imgdet);

#endif
