/* $Id: mat_imbasic.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imbasic.h $
 */

#ifndef MAT_IMBASIC_H
#define MAT_IMBASIC_H


/*-----------------------------------------------------------------------------
                      Includes
------------------------------------------------------------------------------*/
#include <stdio.h>
#include <complex.h>
#include "cpl.h"
#include <complex.h>

#include "mat_const.h"
#include "mat_detector.h"
#include "mat_imagingdetector.h"
/*-----------------------------------------------------------------------------
                      Defines
------------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                      Low Level Structures
------------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------
                       High Level Structures
------------------------------------------------------------------------------*/

/**
   @ingroup imb
   @brief Structure containing the basic detector monitoring information for a detector.

   This structure represents all contents in a IM_BASIC FITS file. This includes
   the primary header keywords (keywords member), the sub-window setup (imgdet member),
   the pixel statistics (median, variance and readout noise) and fast and slow
   powerspectra for each detector channel.
 */
typedef struct {
  mat_detector         *det;                   /*!< The detector specification for this basic detector monitoring map. */
  cpl_propertylist     *keywords;              /*!< The keywords from the primary header. */
  mat_imagingdetector  *imgdet;                /*!< The sub-window setup defined by the contents of the IMAGING_DETECTOR binary table. */
  cpl_imagelist        *list_intensity;        /*!< An imagelist containing for each detector channel a 2D image representing the median intensity value for each pixel. The dimension is given by the detector channel layout (det->channel_nrows*det->channel_ncolumns). */
  cpl_vector           *intensitymedian;       /*!< A vector containing for each detector channel the median of the median pixel intensities. These values are also stored as QC1 parameters (GC DETi CHANNELj OFFSET). */
  cpl_vector           *intensitystdev;        /*!< A vector containing for each detector channel the standard deviation of the median pixel intensities. */
  cpl_imagelist        *list_variance;         /*!< An imagelist containing for each detector channel a 2D image representing the temporal variance for each pixel. */
  cpl_vector           *variancemedian;        /*!< A vector containing for each detector channel the median of the temporal variance. */
  cpl_vector           *variancestdev;         /*!< A vector containing for each detector channel the standard deviation of the temporal variance. */
  cpl_imagelist        *list_ron;              /*!< An imagelist containing for each detector channel a 2D image containing the readout noise for each pixel. */
  cpl_vector           *ronmedian;             /*!< A vector containing for each detector channel the median of the readout noise. These values are also stored as QC1 parameters (GC DETi CHANNELj RON). */
  cpl_vector           *ronstdev;              /*!< A vector containing for each detector channel the standard deviation of the readout noise. */
  cpl_vector          **list_fastpowerspectra; /*!< Vector containing for each detector channel the average 1-d power spectrum (fast or horizontal direction). The size of the power spectrum is given by the width of a detector channel divided by two. */
  cpl_bivector         *fastpowerspectrapeaks; /*!< Bivector containing the frequency (first component) and power (second component) of the five strongest powerspectra peaks in the fast direction. These values are also stored as QC parameters (GC DETi PS FAST PEAKk FREQ and GC DETi PS FAST PEAKk POWER). */
  cpl_vector          **list_slowpowerspectra; /*!< Vector containing for each detector channel the average 1-d power spectrum (slow or vertical direction). The size of the power spectrum is given by the height of the data divided by two times the number or detector channel rows (1 for the HAWAII-2RG and 2 for the Aquarius). */
  cpl_bivector         *slowpowerspectrapeaks; /*!< Bivector containing the frequency (first component) and power (second component) of the five strongest powerspectra peaks in the slow direction. These values are also stored as QC parameters (GC DETi PS SLOW PEAKk FREQ and GC DETi PS SLOW PEAKk POWER). */
} mat_imbasic;

mat_imbasic *mat_imbasic_new(mat_detector *det,
			     mat_imagingdetector *imgdet);

cpl_error_code mat_imbasic_delete(mat_imbasic *imb);

cpl_error_code mat_imbasic_save(mat_imbasic *imb,
				const char *fname,
				const char *rname,
				cpl_parameterlist *parlist,
				cpl_frameset *frameset);

#endif
