/* $Id: mat_imgcorr.c,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imgcorr.c $
 */

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include "mat_imgcorr.h"
#include "mat_error.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Functions
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
  @brief Duplicate a mat_imgcorr structure
  @param imgreg : mat_imgcorr structure to duplicate
  @return img_dup : duplicated structure
 */
/*----------------------------------------------------------------------------*/
mat_imgcorr *mat_imgcorr_duplicate(const mat_imgcorr *imgreg) {
  mat_imgcorr *img_dup=NULL;
  int k=0;

// Check input parameters
  mat_assert_value((imgreg!=NULL),CPL_ERROR_NULL_INPUT, NULL,"no imgreg argument given");

  img_dup=cpl_malloc(sizeof(mat_imgcorr));
  if (img_dup==NULL) {
    cpl_msg_error(cpl_func,"could not allocate memory for img_dup");
    return NULL;
  }
  img_dup->numregion = imgreg->numregion;
  img_dup->numdetector = imgreg->numdetector;
  img_dup->time = imgreg->time;
  img_dup->exptime = imgreg->exptime;
  img_dup->nbimgreg = imgreg->nbimgreg;
  img_dup->imgreg = cpl_calloc(imgreg->nbimgreg,sizeof(cpl_image *));
  // Copy images
  for(k=0;k<img_dup->nbimgreg;k++) {
    img_dup->imgreg[k] =  cpl_image_duplicate(imgreg->imgreg[k]);
  }

  
  return img_dup;
}
