/* $Id: mat_imgreg.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imgreg.h $
 */

#ifndef MAT_IMGREG_H
#define MAT_IMGREG_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @brief Contains the pixel intensities of a sub-window.

   Each sub-window has its unique number (corresponds to the region number in a mat_region data structure),
   a detector number which contains the sub-window and the pixel intensities itself.
 */
typedef struct {
    int           numregion;    /*<! region number                   */
    int           numdetector;  /*<! detector number                 */
    int           nbimgreg;     /*<! number of sub-image             */
    cpl_image    **imgreg;      /*<! array of images                 */
} mat_imgreg;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

cpl_error_code mat_imgreg_delete(mat_imgreg *region);
mat_imgreg *mat_imgreg_duplicate(const mat_imgreg * imgreg, cpl_type type);

#endif
