/* $Id: mat_imremanence.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imremanence.h $
 */

#ifndef MAT_IMREMANENCE_H
#define MAT_IMREMANENCE_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <stdio.h>
#include <cpl.h>
#include "mat_detector.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @ingroup imr
   @brief Structure containing the detector remanence information for a detector.

   This structure represents all contents in a IM_REMANENCE FITS file.
*/
typedef struct {
  mat_detector         *det;               /*!< The detector specification for this detector remanence file. */
  cpl_propertylist     *keywords;          /*!< The keywords from the primary header. */
  double                todarkremanence;   /*!< The remanence value for switching from bright to dark. This value will be stored as a QC1 parameter (QC DETi REM TODARK). */
  double                tobrightremanence; /*!< The remanence value for switching from dark to bright. This value will be stored as a QC1 parameter (QC DETi REM TOBRIGHT). */
} mat_imremanence;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

mat_imremanence *mat_imremanence_new(mat_detector *det);

cpl_error_code mat_imremanence_delete(mat_imremanence *imr);

cpl_error_code mat_imremanence_save(mat_imremanence *imr,
				    const char *fname,
				    const char *rname,
				    cpl_parameterlist *parlist,
				    cpl_frameset *frameset);

#endif
