/* $Id: mat_obsflat.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_obsflat.h $
 */

#ifndef MAT_OBSFLATFIELD_H_
#define MAT_OBSFLATFIELD_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "mat_detector.h"
#include "mat_imagingdetector.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @ingroup ofm
   @brief Structure containing the observation specific flatfield map.

   This structure represents all cintents in a OBSFLAT FITS file. This includes
   the primary header keywords (keywords member), the sub-window setup (imgdet member),
   the conversion factor (detectorgain and channelgain members), the readout noise
   (detectornoise and channelnoise members) and the observation specific flatfield map itself.
 */
typedef struct {
  mat_detector         *det;            /*!< The detector specification for this obflat map. */
  cpl_propertylist     *keywords;       /*!< The keywords from the primary header. */
  mat_imagingdetector  *imgdet;         /*!< The contents of the IMAGING_DETECTOR binary table. */
  double                detectorgain;   /*!< The detector specific gain in electrons per ADU (QC1 parameter QC DETi GAIN). */
  double                detectornoise;  /*!< The detector specific readout noise in electrons (QC1 parameter QC DETi RON). */
  double                flatfieldstdev; /*!< The standard deviation of the computed flatfield map (QC1 parameter QC DETi FFM STDEV). */
  cpl_vector           *channelgain;    /*!< The detector channel specific gain in electrons per ADU (QC1 parameter QC DETi CHANNELj GAIN). */
  cpl_vector           *channeloffset;  /*!< The detector channel specific offset in ADU (QC1 parameter QC DETi CHANNELj OFFSET). */
  cpl_vector           *channelnoise;   /*!< The detector channel specific readout noise in electrons (QC1 parameter QC DETi CHANNELj NOISE). */
  cpl_image           **list_obsflat;   /*!< Vector containing the flatfield maps for each region. Dimensions given by imgdet->nbregion. */
  cpl_image           **list_bias;      /*!< Vector containing the pixel bias maps for each region. Dimensions given by imgdet->nbregion. */
} mat_obsflat;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_obsflat *mat_obsflat_new(mat_detector *det, mat_imagingdetector *imgdet);
cpl_error_code mat_obsflat_delete(mat_obsflat *ffm);

cpl_error_code mat_obsflat_save(mat_obsflat *ffm,
				const char *fname,
				const char *rname,
				cpl_parameterlist *parlist,
				cpl_frameset *frameset);

mat_obsflat *mat_obsflat_load(cpl_frame *ffmframe);

mat_obsflat *mat_obsflat_map(mat_obsflat *ofm, mat_imagingdetector *imgdet);

#endif /* MAT_OBSFLATFIELD_H_ */
