/* $Id: mat_oifits_init_from_corrflux.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oifits_init_from_corrflux.h $
 */

#ifndef MAT_OIFITS_INIT_FROM_CORRFLUX_H
#define MAT_OIFITS_INIT_FROM_CORRFLUX_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <string.h>
#include <sys/stat.h>
#include "mat_drl.h"
#include "mat_corrflux.h"
#include "mat_utils.h"
#include "mat_shift.h"
#include "mat_eop.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
double mjd2lst(double longitude, double mjd);
int mat_oivis2_filluv(mat_oifits *oifits);
int mat_oivis_filluv(mat_oifits *oifits);
int mat_oit3_filluv(mat_oifits *oifits);
int mat_oifits_init_from_corrflux(mat_corrflux *corrFlux,mat_oifits *oifits);

#endif
