/* $Id: mat_opd_wvpo.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_opd_wvpo.h $
 */

#ifndef MAT_OPD_WVPO_H
#define MAT_OPD_WVPO_H


/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <string.h>
#include <complex.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include "mat_drl.h"
#include "mat_corrflux.h"
#include "mat_utils.h"
#include "mat_shift.h"
#include "mat_oifits_init_from_corrflux.h"

#include "mat_const.h"
#include "asa_user.h"
#include<gsl/gsl_multimin.h> 
#include<gsl/gsl_vector.h> 
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

#define CHUNK_SIZE 1024

/*-----------------------------------------------------------------------------
                                   Data Structures
 -----------------------------------------------------------------------------*/

/* Structure mat_opdelem */
/**
   @defgroup opdwvpo OPD and Water VaPor Offset 
*/
/**
   @ingroup opdwvpo
   @brief Structure containing the rows of the oi_opd structure.
*/
typedef struct {
  double    time;                        /* UTC time of observation         */
  double    dateobsmjd;                  /* UTC date (MJD)                  */
  double    exptime;                     /* integration time per frame      */
  int       stationindex[2];             /* Station indexes                 */
  double    opd;                         /* opd estimation                  */
  double    opderr;                      /* opd error                       */
  double    tempoff;                     /* Estimated temperature Offset    */
  double    tempofferr;                  /* Error on the estimated temperature Offset */
  double    humoff;                      /* Estimated relative humidity offset */
  double    humofferr;                   /* Error on the estimated relative humidity offset */
  double    *visreal;
  double    *visimag;
} mat_opdelem;

/* Structure mat_oiopd */
/**
   @ingroup opdwvpo
   @brief Structure containing the opd informations.
*/
typedef struct {
  char         *dateobs;                 /* observation date                */
  char         *arrayname;               /* array name                      */
  char         *insname;                 /* instrument name                 */
  int           nbopd;                   /* number of closure phase         */
  mat_opdelem **list_opd;                /* array struc of OPD              */
} mat_oiopd;
/* Structure mat_oiopdwwvpo */
/**
   @ingroup opdwvpo
   @brief Structure containing opd and wvpo.
*/
typedef struct {
  cpl_propertylist      *keywords;             /* primary header            */
  mat_oitarget          *oitarget;             
  mat_array             *array;                /* interfero array           */
  mat_oiopd             *oiopd;                /* OPD and Wv index          */
} mat_oiopdwvpo;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
/* int mat_opd_wvpo(mat_corrflux *corrFlux,mat_oiopdwvpo *oiopd,cpl_parameter *chromaticOpdFit); */
int mat_opd_wvpo(mat_corrflux *corrFlux,mat_oiopdwvpo *oiopd,char *fileGRAVITY);
int mat_oiopdwvpo_init_from_corrflux(mat_corrflux *corrFlux,mat_oiopdwvpo *oiopdwvpo);
cpl_error_code mat_oiopd_delete(mat_oiopd *oiopd);
cpl_error_code mat_oiopdwvpo_delete(mat_oiopdwvpo *oiopdwvpo);
cpl_error_code mat_oiopdwvpo_list_delete(mat_oiopdwvpo **oiopdwvpo, int nboiopd);
cpl_table *mat_oiopd_to_table(mat_oiopd *oiopd, cpl_propertylist *plist);
cpl_error_code  mat_oiopd_append(char *filename,mat_oiopd *oiopd, int nbTarget);

mat_oiopdwvpo *mat_oiopdwvpo_load(cpl_frame *frame);
mat_oiopd *mat_oiopd_from_table(cpl_propertylist *plist, cpl_table *table);

cpl_error_code  mat_oiopdwvpo_save(mat_oiopdwvpo *oiopdwvpo,
				cpl_frameset *frameset,
				cpl_frameset *usedframes ,
				const cpl_parameterlist *parlist,
				const char *recipe_name,
				   char *filename);
mat_oiopd *mat_oiopd_new(int nbopd, int nbchannel);
cpl_error_code interpolate_corrflux(cpl_vector *p_row, double zoom, cpl_vector *p_res);
int mat_corr_opd_wvpo(mat_oiopdwvpo *oiopdwvpo, mat_corrflux *corrFlux);
double mat_oiopd_ciddor(double lambda, double pressure, double temp, double humidity) ;
double mat_oiopd_mathar(double lambda, double pressure, double temp, double humidity) ;
double mat_oiopd_mathar_der_hum(double lambda, double pressure,
				double temp, double humidity); 
double mat_oiopd_mathar_der_temp(double lambda, double pressure,
				double temp, double humidity); 
double mat_opd_asavalue(asa_objective *asa);
void mat_opd_asagrad(asa_objective *asa);
double mat_opd_asavalgrad(asa_objective *asa);
double mat_opd_value(double x[], cpl_vector *vec);
void mat_opd_cov(double x[], int nParam, cpl_vector *vec, double *g);
int mat_apply_cophasing_algo(cpl_image **real,cpl_image **imag,
			     int nWave, int nFrame,
			     cpl_vector *alpha[], cpl_vector *beta[],
			     cpl_vector *phiStatic[],
			     float lambdamin, float lambdamax);
double my_f(const gsl_vector *v, void *params);
#endif
