/* $Id: mat_proc_coher_lib.c,v0.5 2014-06-15 12:56:21 fmillour Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fmillour $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_proc_coher_lib.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#include <string.h>
#endif

/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "mat_opd_wvpo.h"
#include "mat_proc_coher_lib.h"
#include "mat_error.h"

/*-----------------------------------------------------------------------------
  Define
  ----------------------------------------------------------------------------*/
#define RECIPE_NAME "mat_proc_coher"
#define NB_BCD 4
/*-----------------------------------------------------------------------------
  Functions prototypes
  ----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
   @brief Apply the coherent processing (mat_proc_coher)
   @param *frameset           contains the frames
   @param *parlist            contains the recipes parameters
   @param recname            Name of the recipes calling this function
   @return 0 if no error 
*/
int mat_proc_coher_lib(cpl_frameset      *frameset,
                       cpl_parameterlist *parlist,
                       const char        *recname)
{
    
    /* printf( "This is mat_proc_coher_lib function\n"); */
    
    /* cpl_parameter *useAvgPhot=NULL; */
    /* cpl_parameter *parHighSens=NULL; */
    cpl_frame *cur_frame = NULL;
    cpl_frame *sel_frame = NULL;
    char *pszFileName    = NULL;
    char *pszFileTag     = NULL;
    char *detName        = NULL;
    char *sliderPhot     = NULL;
    char mode[3]         = " ";
    cpl_frame *dup_frame = NULL;
    /* char *bcdStatus      = NULL; */
    char *bcdMode      = NULL;
    /* char *bcd2Status=NULL; */
    /* char bcd1StatusFirst[100]=""; */
    /* char bcd2StatusFirst[100]=""; */
    cpl_propertylist *plist=NULL;
    int i=0;
    int j=0;
    int k=0;
    int l=0;
    /* int expert=0; */
    int cpt=0;
    int nbCorrFlux = 0;
    int nbPhot = 0;
    int nbOPD  = 0;
    int ixPhot     = 0;
    int ixOPD      = 0;
    int ixCorrFlux = 0;
    mat_photbeams **phot     = NULL;
    mat_corrflux  **corrFlux = NULL;
    mat_oifits    **oifits   = NULL;
    mat_oiopdwvpo **oiopd    = NULL;
    cpl_frameset   *usedframes = NULL;
    /* char            filename[200]=""; */
    char           *filename  = NULL;
    cpl_frame      *frameCorrFlux = NULL;
    cpl_frame      *framePhot = NULL;
    cpl_frame      *frameOPD  = NULL;
    cpl_frameset_iterator *it = NULL;
    cpl_errorstate  prestate  = cpl_errorstate_get();
    int indexFile   = 1;
    int flagProcess = 1;
    int flagPhot    = 1;
    cpl_frameset *framesetsorted  = NULL;
    mat_photbeams *photPointer    = NULL;
    mat_oiopdwvpo *opdPointer     = NULL;
    cpl_parameter *algo = NULL;
    int flagnofringe=0;
    cpl_propertylist *header=NULL;
    char *protech=NULL;
 
    //   Check input parameters
    mat_assert_value((frameset != NULL),CPL_ERROR_NULL_INPUT,CPL_ERROR_NULL_INPUT, "no frameset argument given");
    
    algo=cpl_parameterlist_find(parlist,"matisse.mat_proc_coher.coherentAlgo");
 
    
    // Sort the data versus BCD
    printf("Sorting data vs. BCD ...\n");
    for(int ibcd=0;ibcd<NB_BCD;ibcd++)
    {
        nbCorrFlux = 0;
        nbPhot     = 0;
        nbOPD      = 0;
        ixPhot     = 0;
        ixOPD      = 0;
        ixCorrFlux = 0;
        flagProcess= 1;
        
        framesetsorted = cpl_frameset_new();

        it = cpl_frameset_iterator_new(frameset);
        do {
            cur_frame = cpl_frameset_iterator_get(it);
            if (cur_frame != NULL)
            {
                pszFileName = (char *)cpl_frame_get_filename( cur_frame );
                pszFileTag  = (char *)cpl_frame_get_tag( cur_frame );
                plist=cpl_propertylist_load(pszFileName,0);
                if (strcmp(pszFileTag,"PHOT_BEAMS") == 0 ||
                    strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0 ||
                    strcmp(pszFileTag,"OI_OPDWVPO") == 0 )
                {
                    if ( cpl_propertylist_has(plist,"ESO CFG BCD MODE") )
                    {
   		        bcdMode = (char *) cpl_propertylist_get_string(plist,"ESO CFG BCD MODE");
			if (strcmp(bcdMode, "OUT-OUT") == 0 && ibcd==0)
			  {
			    dup_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(framesetsorted,dup_frame);
			  }	
			if (strcmp(bcdMode, "IN-IN") == 0 && ibcd==1)
			  {
			    dup_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(framesetsorted,dup_frame);
			  }
			if (strcmp(bcdMode, "OUT-IN") == 0 && ibcd==2)
			  {
			    dup_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(framesetsorted,dup_frame);
			  }
			if (strcmp(bcdMode, "IN-OUT") == 0 && ibcd==3)
			  {
			    dup_frame=cpl_frame_duplicate(cur_frame);
			    cpl_frameset_insert(framesetsorted,dup_frame);
			  }
			header = cpl_propertylist_load(pszFileName,0);
			protech=(char *)cpl_propertylist_get_string(header,"ESO PRO TECH");
			if (protech == NULL)
			  {
			    cpl_msg_error(cpl_func,"No PRO TYPE keyword");
			    return -1;
			  }
			if (flagnofringe == 0 && strstr(protech,"NOFRINGE") != NULL)
			  {
			    flagnofringe=1;
			  }
			cpl_propertylist_delete(header);		    
 		    }
                }

                cpl_propertylist_delete(plist);
            }
        }
        while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
        cpl_frameset_iterator_delete(it);
        
	if ( (cpl_frameset_count_tags(framesetsorted,"OBJ_CORR_FLUX") == 0 && flagnofringe == 0) ||
	     (cpl_frameset_count_tags(framesetsorted,"OBJ_CORR_FLUX") == 1 && flagnofringe == 1) )
	  {
 	   if (ibcd==0)
	     {
	       cpl_msg_warning(cpl_func,"No OBJ_CORR_FLUX frame to process for BCD OUT-OUT");
	       flagProcess=0;
	     }
	   if (ibcd==1)
	     {
	       cpl_msg_warning(cpl_func,"No OBJ_CORR_FLUX frame to process for BCD IN-IN");
	       flagProcess=0;
	     }
	   if (ibcd==2)
	     {
	       cpl_msg_warning(cpl_func,"No OBJ_CORR_FLUX frame to process for BCD OUT-IN");
	       flagProcess=0;
	     }
	   if (ibcd==3)
	     {
	       cpl_msg_warning(cpl_func,"No OBJ_CORR_FLUX frame to process for BCD IN-OUT");
	       flagProcess=0;
	     }
        }
        else
        {
            if (cpl_frameset_count_tags(framesetsorted,"PHOT_BEAMS") == 0)
            {
                if (ibcd==0)
                {
                    cpl_msg_warning(cpl_func,"No PHOT_BEAMS frame to process for BCD OUT-OUT");
                    flagProcess=1;
                    flagPhot=0;
                }
                if (ibcd==1)
                {
                    cpl_msg_warning(cpl_func,"No PHOT_BEAMS frame to process for BCD IN-IN");
                    flagProcess=1;
                    flagPhot=0;
                }
               if (ibcd==2)
                {
                    cpl_msg_warning(cpl_func,"No PHOT_BEAMS frame to process for BCD OUT-IN");
                    flagProcess=1;
                    flagPhot=0;
                }
               if (ibcd==3)
                {
                    cpl_msg_warning(cpl_func,"No PHOT_BEAMS frame to process for BCD IN-OUT");
                    flagProcess=1;
                    flagPhot=0;
                }
            }
        }
    
	printf("Entering flagprocess ...\n");
        if (flagProcess==1)
        {
            // 1. Check the data type of the input frames
            cpt=0;
            prestate=cpl_errorstate_get();
            it= cpl_frameset_iterator_new(framesetsorted);
            do
            {
                cur_frame = cpl_frameset_iterator_get(it);
                if (cur_frame != NULL)
                {
                    /* File name */
                    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
                    /* Tag */
                    pszFileTag  = (char *)cpl_frame_get_tag( cur_frame );
                    /* Primary Header */
                    plist       = cpl_propertylist_load(pszFileName,0);
		    protech=(char *)cpl_propertylist_get_string(plist,"ESO PRO TECH");

                    if ( (strcmp(pszFileTag,"PHOT_BEAMS") == 0 || strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0) &&
			 strstr(protech,"NOFRINGE") == NULL )
                    {
                        // Count the photbeams files
                        if (strcmp(pszFileTag,"PHOT_BEAMS") == 0) 
                        {
                            nbPhot++;
                        }
                        // Count the corrflux files
                        if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0)
                        {
                            nbCorrFlux++;
                        }
                        detName=(char *)cpl_propertylist_get_string(plist,"ESO DET CHIP NAME");
                        if (detName == NULL)
                        {
                            cpl_msg_error(cpl_func,
                                          "no ESO DET CHIP NAME keyword in frame");
                            return -1;
                        }
                        if(!strcmp(detName, "AQUARIUS"))
                        {
                            sliderPhot=
                                (char *)cpl_propertylist_get_string(plist, 
                                                                    "ESO INS PIN NAME");        
                        }
                        else
                        {
                            sliderPhot=
                                (char *)cpl_propertylist_get_string(plist, 
                                                                    "ESO INS PIL NAME");        
                        }
                        if (!strcmp(sliderPhot, "PHOTO"))
                        {
                            sprintf(mode,"s");
                        }
                        else
                        {
                            sprintf(mode,"h");
                        }
                        cpt++;
                    }
                    // Count number of OPD files
                    else if(strcmp(pszFileTag,"OI_OPDWVPO") == 0)
                    {
                        nbOPD++;        
                    }
                    // Get next frame from SOF
                    cpl_propertylist_delete(plist);
                }
            }
            while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);

            cpl_frameset_iterator_delete(it);
            if (!cpl_errorstate_is_equal(prestate))
            {
                cpl_errorstate_set(prestate);
            }

	    if(flagPhot==1)
	    {
		/* Allocate tables as a function of files numbers */
		/* Photometry */
		phot = cpl_calloc(nbPhot,sizeof(mat_photbeams *));
		if (phot == NULL)
		{
		    cpl_msg_error(cpl_func,"could not allocate memory for phot");
		    cpl_free(phot);
		    return -1;
		}
	    }
	    else
	    {
		phot = NULL;
	    }
            /* Correlated flux */
            corrFlux = cpl_calloc(nbCorrFlux,sizeof(mat_photbeams *));
            if (corrFlux == NULL)
            {
                cpl_msg_error(cpl_func,"could not allocate memory for corrFlux");
                cpl_free(phot);
                cpl_free(corrFlux);
                return -1;
            }
            /* OPD structure */
            oiopd = cpl_calloc(nbOPD,sizeof(mat_oiopdwvpo *));
            if ((nbOPD!=0)&&(oiopd == NULL))
            {
                cpl_msg_error(cpl_func,"could not allocate memory for oiopd");
                cpl_free(phot);
                cpl_free(corrFlux);
                cpl_free(oiopd);
                return -1;
            }
            // Initialization of the mat_oifits structure
            oifits=cpl_calloc(nbCorrFlux,sizeof(mat_oifits *));

            // 2.Load PHOT_BEAMS and OBJ_CORR_FLUX
            cpl_msg_info(cpl_func,
                         "Loading PHOT_BEAMS, OBJ_CORR_FLUX and OI_OPDWVPO files");
            cpl_matrix *dispCoef = cpl_matrix_new(N_DEG_DISPERSION_LAW+1,nbCorrFlux);
            prestate = cpl_errorstate_get();
            it       = cpl_frameset_iterator_new(framesetsorted);
            do
            {
                cur_frame = cpl_frameset_iterator_get(it);
                if (cur_frame != NULL)
                {
                    // Load PHOTBEAMS
                    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
                    pszFileTag  = (char *)cpl_frame_get_tag( cur_frame );
		    plist=cpl_propertylist_load(pszFileName,0);
		    protech=(char *)cpl_propertylist_get_string(plist,"ESO PRO TECH");
		    if (protech == NULL) {
		      cpl_msg_error(cpl_func,"No PRO TYPE keyword");
		      return -1;
		    }
                    if (strcmp(pszFileTag,"PHOT_BEAMS") == 0)
                    {
                        cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
                        // Loading PHOT_BEAMS frame
                        phot[ixPhot] = mat_photbeams_load(cur_frame);
                        ixPhot++;
                    }
                    // Load CORRFLUX
                    if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0 && strstr(protech,"NOFRINGE") == NULL)
                    {
                        cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
                        // Loading OBJ_CORR_FLUX frames
                        corrFlux[ixCorrFlux] = mat_corrflux_load(cur_frame);
                        cpl_matrix_set(dispCoef,0,ixCorrFlux,cpl_propertylist_get_double(
                                                                                         corrFlux[ixCorrFlux]->keywords,
                                                                                         "PRO DISP COEF0"));
                        cpl_matrix_set(dispCoef,1,ixCorrFlux,cpl_propertylist_get_double(
                                                                                         corrFlux[ixCorrFlux]->keywords,
                                                                                         "PRO DISP COEF1"));
                        cpl_matrix_set(dispCoef,2,ixCorrFlux,cpl_propertylist_get_double(
                                                                                         corrFlux[ixCorrFlux]->keywords,
                                                                                         "PRO DISP COEF2"));
                        cpl_matrix_set(dispCoef,3,ixCorrFlux,cpl_propertylist_get_double(
                                                                                         corrFlux[ixCorrFlux]->keywords,
                                                                                         "PRO DISP COEF3"));
                        cpl_matrix_set(dispCoef,4,ixCorrFlux,cpl_propertylist_get_double(
                                                                                         corrFlux[ixCorrFlux]->keywords,
                                                                                         "PRO DISP COEF4"));

                        // Initializing the mat_oifits structure
                        oifits[ixCorrFlux] = cpl_malloc(sizeof(mat_oifits));
                        mat_oifits_init_from_corrflux(corrFlux[ixCorrFlux],oifits[ixCorrFlux]);
                        ixCorrFlux++;
                    }
                    //  load OPD
                    if (strcmp(pszFileTag,"OI_OPDWVPO") == 0)
                    {
                        //  load OPD
                        cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
                        oiopd[ixOPD] = mat_oiopdwvpo_load(cur_frame);
                        ixOPD++;
                    }
		    cpl_propertylist_delete(plist);
                }
            }
            while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
            cpl_frameset_iterator_delete(it);
    
            if (!cpl_errorstate_is_equal(prestate))
            {
                cpl_errorstate_set(prestate);
            }
    
            // Checking the number of PHOTBEAMS frames with respect to the mode
            // only if corrFlux=FALSE
            if (strstr(mode,"s") == NULL)
            {
                cpl_msg_info(cpl_func,"HighSens mode");
                /* cpl_msg_info(cpl_func,"In this mode the useAvgPhot option is not used"); */
                // In the case of HighSens only 1 PHOTBEAMS is necessary
                // If several PHOTBEAMS, only the first PHOTBEAMS will be used
                switch (nbPhot)
                {
                    case 0:
                        cpl_msg_warning(cpl_func,"No PHOTBEAMS frame found in the sof file. Computing corrflux only...");
			phot = NULL;
                        //cpl_matrix_delete(dispCoef); dispCoef = NULL;
                        //mat_oifits_list_delete(oifits,nbCorrFlux); oifits = NULL;
                        //return CPL_ERROR_INCOMPATIBLE_INPUT;
			break;
                    case 1:
                        cpl_msg_info(cpl_func,"1 PHOTBEAMS frame found in the sof file");
                        break;
                    default:
                        cpl_msg_warning(cpl_func,"%d PHOTBEAMS frame found in the sof file",nbPhot);
                        cpl_msg_warning(cpl_func,"Only the first PHOTBEAMS frame will be considered in the following");
                        break;
                }
            }
            else
            {
                cpl_msg_info(cpl_func,"SiPhot mode");
		if (nbPhot == 0)
		  {
		    cpl_msg_warning(cpl_func,"No PHOTBEAMS frame found in the sof file. Computing corrflux only...");
		    phot = NULL;
		  }
		else {
		  if (nbPhot != nbCorrFlux)
		    {
		      cpl_msg_error(cpl_func,"The number of PHOT_BEAMS files should be equal to the the number OBJ_CORR_FLUX files");
		      cpl_matrix_delete(dispCoef);
		      cpl_free(phot);
		      cpl_free(corrFlux);
		      cpl_free(oifits);
		      cpl_free(oiopd);
		      return CPL_ERROR_INCOMPATIBLE_INPUT;
		    }
		  else
		    {
		      cpl_msg_info(cpl_func,"%d PHOTBEAMS frame and %d OBJ_CORR_FLUX found in the sof file",nbPhot,nbCorrFlux);
		    }
		}
            }
                
        
            // Start estimation of interferometric observables
            for(i=0;i<nbCorrFlux;i++)
            {
                // Preparing usedframes frameset
                k=0;
                j=0;
                l=0;
                prestate = cpl_errorstate_get();
                it       = cpl_frameset_iterator_new(framesetsorted);
                // Browse again frameset
                // Just for history records
                do
                {
                    cur_frame = cpl_frameset_iterator_get(it);
                    if (cur_frame != NULL)
                    {
                        pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
                        if (strcmp(pszFileTag,"PHOT_BEAMS") == 0)
                        {
                            // HiSens mode
                            if (strstr(mode,"s") == NULL)
                            {
                                if (k==0)
                                {
                                    // Take just the first photbeams file
                                    framePhot=cpl_frame_new();
                                    cpl_frame_set_filename(framePhot,cpl_frame_get_filename(cur_frame));
                                    cpl_frame_set_group   (framePhot,cpl_frame_get_group(cur_frame));
                                    cpl_frame_set_level   (framePhot,cpl_frame_get_level(cur_frame));
                                    cpl_frame_set_tag     (framePhot,pszFileTag);
                                    cpl_frame_set_type    (framePhot,cpl_frame_get_type(cur_frame));
                                }
                            }
                            else
                            {
                                // SiPhot mode
                                if (i==k)
                                {
                                    framePhot=cpl_frame_new();
                                    cpl_frame_set_filename(framePhot,cpl_frame_get_filename(cur_frame));
                                    cpl_frame_set_group   (framePhot,cpl_frame_get_group(cur_frame));
                                    cpl_frame_set_level   (framePhot,cpl_frame_get_level(cur_frame));
                                    cpl_frame_set_tag     (framePhot,pszFileTag);
                                    cpl_frame_set_type    (framePhot,cpl_frame_get_type(cur_frame));
                                }
                            }
                            k++;
                        }
                        if (strcmp(pszFileTag,"OBJ_CORR_FLUX") == 0)
                        {
                            if (i==j)
                            {
                                frameCorrFlux=cpl_frame_new();
                                cpl_frame_set_filename(frameCorrFlux,cpl_frame_get_filename(cur_frame));
                                cpl_frame_set_group   (frameCorrFlux,cpl_frame_get_group(cur_frame));
                                cpl_frame_set_level   (frameCorrFlux,cpl_frame_get_level(cur_frame));
                                cpl_frame_set_tag     (frameCorrFlux,pszFileTag);
                                cpl_frame_set_type    (frameCorrFlux,cpl_frame_get_type(cur_frame));
                            }
                            j++;
                        }
                        // Just for history records
                        if (strcmp(pszFileTag,"OI_OPDWVPO") == 0)
                        {
                            if (i==l)
                            {
                                frameOPD=cpl_frame_new();
                                cpl_frame_set_filename(frameOPD,cpl_frame_get_filename(cur_frame));
                                cpl_frame_set_group   (frameOPD,cpl_frame_get_group(cur_frame));
                                cpl_frame_set_level   (frameOPD,cpl_frame_get_level(cur_frame));
                                cpl_frame_set_tag     (frameOPD,pszFileTag);
                                cpl_frame_set_type    (frameOPD,cpl_frame_get_type(cur_frame));
                            }
                            l++;
                        }
                    }
                }
                while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);

                cpl_frameset_iterator_delete(it);
                if (!cpl_errorstate_is_equal(prestate))
                {
                    cpl_errorstate_set(prestate);
                }
        
                /* 3. Differential phase estimation */
                if (strstr(mode,"s") == NULL)
                {
                    // High sens
                    /* parHighSens=cpl_parameter_duplicate(useAvgPhot); */
                    /* cpl_parameter_set_bool(parHighSens,CPL_TRUE); */
                    
                    if(oiopd!=NULL)
                        opdPointer = oiopd[i];
                    else
                        opdPointer = NULL;
                    
                    if(phot!=NULL)
                        photPointer = phot[0];
                    else
                        photPointer = NULL;
                    
		    if ( cpl_parameter_get_int(algo) == 2)
		      {
			mat_compute_coherent_observable(corrFlux[i],photPointer,oifits[i],opdPointer);
		      }
		    else
		      {
			mat_compute_phidiff(corrFlux[i],photPointer,oifits[i],opdPointer);
		      }
                }
                else
                {
                    if(oiopd!=NULL)
                        opdPointer = oiopd[i];
                    else
                        opdPointer = NULL;

                    if(phot!=NULL)
                        photPointer = phot[i];
                    else
                        photPointer = NULL;
                    
		    if ( cpl_parameter_get_int(algo) == 2)
		      {
			mat_compute_coherent_observable(corrFlux[i],photPointer,oifits[i],opdPointer);
		      }
		    else
		      {
			mat_compute_phidiff(corrFlux[i],photPointer,oifits[i],opdPointer);
		      }
                }
		// Add keywords AMPTYP and PHITYP in header of OIVIS
		oifits[i]->oivis->phityp=cpl_sprintf("differential");
		if ( cpl_parameter_get_int(algo) == 1)
		  {
		    oifits[i]->oivis->amptyp=cpl_sprintf("differential");
		  }
		else
		  {
		    if (photPointer != NULL)
		      {
			oifits[i]->oivis->amptyp=cpl_sprintf("absolute");
		      }
		    else
		      {
			oifits[i]->oivis->amptyp=cpl_sprintf("correlated flux");
		      }
		  }

		
                /* /\*     //6. Save OIVIS table in oifits *\/ */

		printf("Saving OIFITS file ...\n");
		
		if (cpl_frameset_find(frameset,"CALIB_RAW") != NULL ||
		    cpl_frameset_find(frameset,"TARGET_RAW") != NULL ||
		    cpl_frameset_find(frameset,"CALIB_SRC_RAW") != NULL)
		  {
		    usedframes=cpl_frameset_new();
		    it= cpl_frameset_iterator_new(frameset);
		    do
		      {
			cur_frame = cpl_frameset_iterator_get(it);
			if (cur_frame != NULL)
			  {
			    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
			    pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
			    if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0 || strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
			      {
				plist=cpl_propertylist_load(pszFileName,0);
				if (strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO") )
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO") )
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO") )
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO") )
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				cpl_propertylist_delete(plist);
			      }
			  }
		      } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		    cpl_frameset_iterator_delete(it);
		    it= cpl_frameset_iterator_new(frameset);
		    do
		      {
			cur_frame = cpl_frameset_iterator_get(it);
			if (cur_frame != NULL)
			  {
			    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
			    pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
			    if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0 || strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
			      {
				plist=cpl_propertylist_load(pszFileName,0);
				if (strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO") )
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO"))
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO"))
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				else if(strcmp(cpl_propertylist_get_string(oifits[i]->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
				  {
				    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
					strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
					cpl_propertylist_get_int(plist,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits[i]->keywords,"ESO TPL EXPNO"))
				      {
					sel_frame=cpl_frame_duplicate(cur_frame);
					cpl_frameset_insert(usedframes,sel_frame);
				      }
				  }
				cpl_propertylist_delete(plist);
			      }
			    else if (strcmp(pszFileTag, "BADPIX") == 0 || strcmp(pszFileTag, "NONLINEARITY") == 0 ||
				     strcmp(pszFileTag, "SHIFT_MAP") == 0 || strcmp(pszFileTag, "KAPPA_MATRIX") == 0 ||
				     strcmp(pszFileTag, "OBS_FLATFIELD") == 0 || strcmp(pszFileTag, "JSDC_CAT") == 0)
			      {
				sel_frame=cpl_frame_duplicate(cur_frame);
				cpl_frameset_insert(usedframes,sel_frame);
			      }
		       
			  }
		      } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		    cpl_frameset_iterator_delete(it);
		    it= cpl_frameset_iterator_new(frameset);
		    do
		      {
			cur_frame = cpl_frameset_iterator_get(it);
			if (cur_frame != NULL)
			  {
			    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
			    pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
			    if (strcmp(pszFileTag, "SKY_RAW") == 0 || strcmp(pszFileTag, "HOT_DARK") == 0 )
			      {
				sel_frame=cpl_frame_duplicate(cur_frame);
				cpl_frameset_insert(usedframes,sel_frame);
			      }
			  }
		      } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		    cpl_frameset_iterator_delete(it);
		  }
		else
		  {
		    usedframes=cpl_frameset_new();
		    cpl_frameset_insert(usedframes,frameCorrFlux);
		    if (flagPhot)
		      {
			cpl_frameset_insert(usedframes,framePhot);
		      }
		    if (frameOPD != NULL)
		      {
			cpl_frameset_insert(usedframes,frameOPD);
		      }
		  }
                filename=cpl_sprintf("RAW_DPHASE_%04d.fits",indexFile);
                mat_oifits_save(oifits[i],frameset,usedframes,parlist,recname,filename,4);
                indexFile++;
                cpl_free(filename);
                cpl_frameset_delete(usedframes);
            }

            // ?. Free Memory
            for(i=0;i<nbPhot;i++)
            {
                if (phot[i] != NULL)
                {
                    mat_photbeams_free(phot[i]);
                }
            }
            if (phot != NULL)
            {
                cpl_free(phot);
            }
            for(i=0;i<nbCorrFlux;i++)
            {
                if (corrFlux[i] != NULL)
                {
                    mat_corrflux_free(corrFlux[i]);
                }
            }
            if (corrFlux != NULL)
            {
                cpl_free(corrFlux);
            }

            for(i=0;i<nbOPD;i++)
            {
                if (oiopd[i] != NULL)
                {
                    mat_oiopdwvpo_delete(oiopd[i]);
                }
            }
            if (oiopd != NULL)
            {
                cpl_free(oiopd);
            }


            if (dispCoef != NULL)
            {
                cpl_matrix_delete(dispCoef);
            }
            mat_oifits_list_delete(oifits,nbCorrFlux);

    
        }
		
        cpl_frameset_delete(framesetsorted);

    }
    return 0;
}
