/* $Id: mat_fit_gauss-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_fit_gauss-test.c $
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_blas.h>
#include <gsl/gsl_multifit_nlin.h>
#include "../mat_fit_gauss.h"

int main(int argc, char ** argv) {
  
    double res=0.;
    double params[3];
    double pos_err;
    const int n = 300;
    int i=0;

// Create values for 3 gaussians curves in a vector
    gsl_vector *vector_1=NULL;
    gsl_vector *vector_2=NULL;
    cpl_errorstate prestate = cpl_errorstate_get();
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    vector_1 = gsl_vector_alloc(n);
    vector_2 = gsl_vector_alloc(n);

    for(i=0; i<n; i++) {
	gsl_vector_set(vector_1, i,   1 * exp (pow(i-50, 2)/(-2*pow(10,2))));
    }

    for(i=0; i<300; i++) {
	gsl_vector_set(vector_2, i,   0 * exp (pow(i-50, 2)/(-2*pow(10,2))));
    }


// Set the coefficients which are used to sit the results
    params[0]=1.0;
    params[1]=50.0;
    params[2]=10.0;


// Call function mat_fit_3gauss (1)
    res = mat_fit_gauss(n, vector_1, params, &pos_err);

/* Error handling */
    if (!cpl_errorstate_is_equal(prestate)) { 
	cpl_errorstate_dump(prestate, CPL_FALSE, cpl_errorstate_dump_one);
	cpl_errorstate_set(prestate);
    }

// Test the result (1)
    cpl_test_rel(res, 50.0, 0.0001);


// Call function mat_fit_3gauss (2)
    params[0]=0.0;
    params[1]=0.0;
    params[2]=0.0;

    res = mat_fit_gauss(300, vector_2, params, &pos_err);

/* Error handling */
    if (!cpl_errorstate_is_equal(prestate)) { 
	cpl_errorstate_dump(prestate, CPL_FALSE, cpl_errorstate_dump_one);
	cpl_errorstate_set(prestate);
    }

// Test the result (2)
    cpl_test_rel(res, 0.0, 0.0001);


// Free Memory
    gsl_vector_free(vector_1);
    gsl_vector_free(vector_2);
  

// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

