/* $Id: mat_gendata_duplicate-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_gendata_duplicate-test.c $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_gendata.h"
#include <string.h>

int main(int argc, char ** argv) {
  
    cpl_frame* frame=NULL;
    mat_gendata* genData=NULL;
    mat_gendata *genData_dup=NULL;

    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_02.fits", MAT_TESTDATADIR);
    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);


// Load a mat_gendata structure
    genData = mat_gendata_load(frame, CPL_TYPE_FLOAT);

// DUPLICATE this structure
    genData_dup = mat_gendata_duplicate(genData, CPL_TYPE_FLOAT);

// Test attribute keywords
    cpl_test(strcmp((char*)cpl_propertylist_get_string((*genData_dup).keywords,
						       "ESO INS MODE"),
		    (char*)cpl_propertylist_get_string((*genData).keywords,
						       "ESO INS MODE")) == 0);
// Test attribute imgdet
    cpl_test((*genData_dup).imgdet->list_region[4]->naxis[0] == 
	     (*genData).imgdet->list_region[4]->naxis[0]);
// Test attribute array
    cpl_test_rel((*genData_dup).array->list_station[2]->staxyz[1], 
		 (*genData).array->list_station[2]->staxyz[1], 0.0001 );
// Test attribute imgdata
    cpl_test((*genData_dup).imgdata->list_frame[0]->list_subwin[4]->numregion 
	     == (*genData_dup).imgdata->list_frame[0]->
	     list_subwin[4]->numregion);
    cpl_test(mat_gendata_duplicate(NULL, CPL_TYPE_FLOAT) == NULL);

// Free mat_gendata structures
    mat_gendata_delete(genData); 
    mat_gendata_delete(genData_dup);   
    cpl_frame_delete(frame);

 

// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}
