/* $Id: mat_gendata_save-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_gendata_save-test.c $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_gendata.h"

int main(int argc, char ** argv) {
  
    cpl_frame *frame = NULL;
    cpl_frame *sel_frame = NULL;
    cpl_frameset *set = NULL;
    mat_gendata *genData = NULL;
    cpl_parameterlist *parlist = NULL;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_03.fits", MAT_TESTDATADIR);

    set = cpl_frameset_new();
    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
    sel_frame=cpl_frame_duplicate(frame);
    cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
    cpl_frame_set_tag(sel_frame,"RAW_VIS2");
    cpl_frameset_insert(set, sel_frame);


// Load structure mat_gendata
    genData = mat_gendata_load(frame, CPL_TYPE_FLOAT);
    parlist=cpl_parameterlist_new();
    cpl_test(mat_gendata_save(genData, set, set, parlist, "test",
    			      "SCIENCE", "IMAGE", "OBJECT",
    			      (char *)"testGendata_save.fits",
			      CPL_TYPE_FLOAT) 
	     == CPL_ERROR_NONE);

    cpl_test(mat_gendata_append(genData,(char *)"testGendata_save.fits",
				CPL_TYPE_FLOAT)== CPL_ERROR_NONE);
    remove("testGendata_save.fits");
    mat_gendata_delete(genData);
    cpl_frame_delete(frame);
    cpl_parameterlist_delete(parlist);
    cpl_frameset_delete(set);
// Check for memory leak
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
