/* $Id: mat_imagingdata_duplicate-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imagingdata_duplicate-test.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <string.h>
#include <sys/stat.h>
#include "../mat_imagingdata.h"
#include "../mat_imagingdetector.h"
#include "../mat_array.h"

int main(int argc, char ** argv) {
  
    cpl_frame* frame=NULL;
    int i=0,j=0, nbExtent=0, nbrow_opti=0, *staindex=NULL, *armindex=NULL;
    char **telname_array=NULL, **telname_opti=NULL, *keyExtname=NULL;
    cpl_propertylist* plist=NULL;
    cpl_table *table=NULL, *tableopti=NULL;
    mat_imagingdetector *imgdet=NULL;
    mat_array *array=NULL;
    mat_imagingdata *imgdata=NULL, *imgdata_dup=NULL;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_01.fits", MAT_TESTDATADIR);
    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);

    nbExtent=cpl_frame_get_nextensions(frame);

// LOAD a mat_imagingdata structure to duplicate
    // Load structure imgdet
    for(i=0;i<nbExtent;i++) {
	plist=cpl_propertylist_load(cpl_frame_get_filename(frame),i+1);
    
	keyExtname=(char *)cpl_propertylist_get_string(plist,"EXTNAME");

	if (keyExtname != NULL) {
	    table=cpl_table_load(cpl_frame_get_filename(frame),i+1,0);
	    // Call method mat_imagingdetector_load
	    if (!strcmp(keyExtname,"IMAGING_DETECTOR")) {
		imgdet = mat_imagingdetector_from_table(plist, table);
	    }
	    // Call method mat_array_load
	    if (!strcmp(keyExtname,"ARRAY_GEOMETRY")) {
		array = mat_array_from_table(plist, table);

		telname_array= cpl_calloc(array->nbstation, sizeof(char *));
		// Get info for IMAGING_DATA
		staindex= cpl_calloc(array->nbstation, sizeof(int));
		for(j=0; j<array->nbstation; j++) {
		    telname_array[j]= cpl_calloc(17, sizeof(char));
		    strncpy(telname_array[j], array->list_station[j]->telname
			    ,17);
		    staindex[j]= array->list_station[j]->staindex;
		}
	    }
      
	    if (!strcmp(keyExtname,"OPTICAL_TRAIN")) {
		tableopti = cpl_table_load(cpl_frame_get_filename(frame),i+1,0);

		nbrow_opti= cpl_table_get_nrow(tableopti);
		telname_opti= cpl_calloc(nbrow_opti, sizeof(char *));
		for(j=0;j<nbrow_opti;j++) {
		    telname_opti[j]= cpl_calloc(17, sizeof(char));
		    strncpy(telname_opti[j], cpl_table_get_string(tableopti, 
								  "TEL_NAME", 
								  j),17);
		}
	    }
	    cpl_table_delete(table);
	}
	cpl_propertylist_delete(plist);
    }

    // Set armindex parameter
    armindex=cpl_calloc(nbrow_opti, sizeof(int));
    for(i=0;i<nbrow_opti;i++) {
	for(j=0;j<nbrow_opti;j++) {
	    if (!strcmp(telname_opti[i], telname_array[j])) {
		armindex[i] = cpl_table_get_int(tableopti, "INDEX", j, NULL);
	    }
	}
    }

    // Load structure imgdata
    for(i=1;i<nbExtent;i++) {
	plist=cpl_propertylist_load(cpl_frame_get_filename(frame),i+1);
    
	keyExtname=(char *)cpl_propertylist_get_string(plist,"EXTNAME");

	if (keyExtname != NULL) {
	    table=cpl_table_load(cpl_frame_get_filename(frame),i+1,0);
	    // Call method mat_imagingdata_load
	    if (!strcmp(keyExtname,"IMAGING_DATA")) {
		imgdata = mat_imagingdata_load(plist, table, imgdet, 
					       staindex, armindex, CPL_TYPE_FLOAT);
	    }
	    cpl_table_delete(table);
	}
	cpl_propertylist_delete(plist);
    }

// DUPLICATE the mat_imagingdata structure
    imgdata_dup = mat_imagingdata_duplicate(imgdata, CPL_TYPE_FLOAT);

// Test imgdata_dup attributes
//  cpl_test(strcmp((*imgdata_dup).dateobs,
//                  "2012-06-12T14:51:22") == 0);
    //cpl_test((*imgdata_dup).list_frame[1]->exptime == 2);
    //cahnger valeur comment le lire dans fv?
    cpl_test((*imgdata_dup).staindex[2] == 33);
    cpl_test((*imgdata_dup).armindex[2] == 3);
    cpl_test((*imgdata_dup).list_frame[0]->list_subwin[4]->numregion ==
             imgdet->list_region[4]->numregion);
    cpl_test(mat_imagingdata_duplicate(NULL, CPL_TYPE_FLOAT) == NULL);

// Free memory
    cpl_free(staindex);
    cpl_free(armindex);
    for(i=0; i<array->nbstation; i++) {
	cpl_free(telname_array[i]);
    }
    cpl_free(telname_array);
    for(i=0; i<nbrow_opti; i++) {
	cpl_free(telname_opti[i]);
    }
    cpl_free(telname_opti);
    mat_imagingdata_delete(imgdata);
    mat_imagingdata_delete(imgdata_dup);
    mat_array_delete(array);
    mat_imagingdetector_delete(imgdet);
  

    cpl_table_delete(tableopti);
    cpl_frame_delete(frame);
  
// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}
