/* $Id: mat_imagingdetector_save-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imagingdetector_save-test.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include <string.h>
#include "../mat_imagingdetector.h"

int main(int argc, char ** argv) {
  
    cpl_frame* frame=NULL;
    int i=0, nbExtent=0;
    char *keyExtname=NULL;
    cpl_propertylist* plist=NULL;
    cpl_table *table=NULL;
    mat_imagingdetector* imgdet=NULL;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_02.fits", MAT_TESTDATADIR);
    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);

    nbExtent=cpl_frame_get_nextensions(frame);

// Load structure imgdet
    for(i=1;i<nbExtent;i++) {
	plist=cpl_propertylist_load(cpl_frame_get_filename(frame),i+1);
    
	keyExtname=(char *)cpl_propertylist_get_string(plist,"EXTNAME");

	if (keyExtname != NULL) {
	    table=cpl_table_load(cpl_frame_get_filename(frame),i+1,0);
	    // Call method mat_imagingdetector_load
	    if (!strcmp(keyExtname,"IMAGING_DETECTOR")) {
		imgdet = mat_imagingdetector_from_table(plist, table);
	    }
	    cpl_table_delete(table);
	}
	cpl_propertylist_delete(plist);
    }

    plist=cpl_propertylist_load(cpl_frame_get_filename(frame),1);
    remove("saveImagingdetector.fits");
    cpl_test(mat_imagingdetector_save(imgdet, plist,"saveImagingdetector.fits") 
	     ==CPL_ERROR_NONE );
    cpl_test(mat_imagingdetector_save(imgdet, plist,"saveImagingdetector.fits") 
	     ==CPL_ERROR_UNSPECIFIED);
    remove("saveImagingdetector.fits");
    cpl_test(mat_imagingdetector_save(NULL,  plist,"saveImagingdetector.fits") 
	     ==  CPL_ERROR_UNSPECIFIED);
    remove("saveImagingdetector.fits");

// Free memory
    // Call method mat_imagingdetector_free
    mat_imagingdetector_delete(imgdet);
    cpl_frame_delete(frame);
    cpl_propertylist_delete(plist);
// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}
