/* $Id: mat_oifits_save-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oifits_save-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oiwavelength.h"
#include "../mat_oifits.h"
#include "../mat_array.h"
#include "../mat_oit3.h"
#include "../mat_oivis.h"
#include "../mat_oivis2.h"
#include "../mat_drl.h"

static cpl_error_code mat_oifits_save_test_basics(void)
{
  cpl_frame *frame;
  cpl_frameset *set = NULL;
  cpl_parameterlist *parlist = NULL;
  /* cpl_propertylist* p_list_array = NULL; */
  cpl_propertylist* p_list = NULL;
  cpl_table *table = NULL;
  mat_oifits *oifits = NULL;
  mat_array *array = NULL;
  mat_oiwavelength *oiwave = NULL;
  mat_oit3 *oit3 = NULL;
  mat_oivis *oivis = NULL;
  mat_oivis2 *oivis2 = NULL;
  mat_oispectrum *oispectrum = NULL;
  char *p_filename = NULL;                                    
  int nb_extent = 0;
  int i = 0;
  char *keyExtname = NULL; 

  char *filename = NULL;
  filename = cpl_sprintf("%s/unit_12.fits", MAT_TESTDATADIR);

  frame = cpl_frame_new();
  cpl_frame_set_filename(frame, filename);
  cpl_free(filename);
  cpl_frame_set_group(frame,CPL_FRAME_GROUP_RAW);
  cpl_frame_set_tag(frame,"TAG");
  set = cpl_frameset_new();
  cpl_frameset_insert(set, frame);

  p_filename = (char *)cpl_frame_get_filename(frame);
  nb_extent = cpl_frame_get_nextensions(frame);
  /*Load frame in a oifits structure*/
  for(i = 0; i<nb_extent; i++)
    {
      p_list = cpl_propertylist_load(cpl_frame_get_filename(frame),i+1);
      keyExtname = (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
      /*oi_vis2 header*/
      if (keyExtname != NULL)
	{
	  /*oi_array data*/
	  if (!strcmp(keyExtname,"OI_ARRAY"))
	    {
	      table=cpl_table_load(p_filename,i+1,0);
	      array = mat_array_from_table(p_list, table);
	      cpl_table_delete(table);
	    }
	}
      cpl_propertylist_delete(p_list);
    }
    
  oifits = mat_oifits_load(frame);
  parlist=cpl_parameterlist_new();
  cpl_test(mat_oifits_save(oifits, set, set, parlist, "test",
  			   (char *)"oifitsSave.fits", 1) == CPL_ERROR_NONE);
  cpl_test(mat_oifits_delete(oifits) == CPL_ERROR_NONE);

  cpl_test( mat_array_append( (char *)"oifitsSave.fits", array) == CPL_ERROR_NONE);
  cpl_test(mat_array_delete(array)== CPL_ERROR_NONE);
  
  oiwave = mat_oiwavelength_load(frame);
  cpl_test( mat_oiwavelength_append( (char *)"oifitsSave.fits", oiwave)
  	    == CPL_ERROR_NONE);
  cpl_test(mat_oiwavelength_delete(oiwave) == CPL_ERROR_NONE);

  oit3 = mat_oit3_load(frame);
  cpl_test( mat_oit3_append( (char *)"oifitsSave.fits", oit3) == CPL_ERROR_NONE);
  cpl_test(mat_oit3_delete(oit3) == CPL_ERROR_NONE);

  oivis = mat_oivis_load(frame);
  cpl_test( mat_oivis_append( (char *)"oifitsSave.fits", oivis) == CPL_ERROR_NONE);
  cpl_test(mat_oivis_delete(oivis) == CPL_ERROR_NONE);

  oivis2 = mat_oivis2_load(frame);
  cpl_test( mat_oivis2_append( (char *)"oifitsSave.fits", oivis2) == CPL_ERROR_NONE);
  cpl_test(mat_oivis2_delete(oivis2) == CPL_ERROR_NONE);

  filename = cpl_sprintf("%s/unit_11.fits", MAT_TESTDATADIR);
  cpl_frame_set_filename(frame, filename);
  cpl_free(filename);

  oispectrum = mat_oispectrum_load(frame);
  oiwave = mat_oiwavelength_load(frame);

  cpl_test( mat_oispectrum_append( (char *)"oifitsSave.fits", oispectrum)
  	    == CPL_ERROR_NONE);

  cpl_test(mat_oiwavelength_delete(oiwave) == CPL_ERROR_NONE);
  cpl_test( mat_oispectrum_delete(oispectrum)== CPL_ERROR_NONE);

  cpl_parameterlist_delete(parlist);
  cpl_frameset_delete(set);

  return cpl_error_get_code();
}

/*----------------------------------------------------------------------------*/
/**
  @brief   Unit tests of OIFITS saving module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

 /* TODO Currently deactivated - PLEASE ACTIVATE AGAIN !!!*/
    mat_oifits_save_test_basics();

    cpl_test_error(CPL_ERROR_NONE);
    return cpl_test_end(0);
}

