/* $Id: mat_oitarget-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oitarget-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oitarget.h"
#include "../mat_oifits.h"

int main(int argc, char ** argv) {
    
    mat_oitarget *oitarget = NULL;                                    
    cpl_table *table;
    cpl_propertylist *plist;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

     
    oitarget = mat_oitarget_new();
    cpl_test(oitarget != NULL);
    plist=cpl_propertylist_new();
    table=mat_oitarget_to_table(oitarget,plist);
    cpl_test(table != NULL);
    cpl_test(mat_oitarget_delete(oitarget) == CPL_ERROR_NONE);
    oitarget=mat_oitarget_from_table(plist,table);
    cpl_test(oitarget != NULL);
    cpl_test( mat_oitarget_append( (char *)"foo.fits", oitarget) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oitarget_delete(oitarget) == CPL_ERROR_NONE);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
