/* $Id: mat_oitf2_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oitf2_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_drl.h"
#include "../mat_oitf2.h"
#include "../mat_merge_results_lib.h"


int main(int argc, char ** argv) {
    
/* Remove comment block once unittest gets re-activated
    cpl_frame *frame;    
    mat_oitf2 *oitf2 = NULL;
    cpl_table *table=NULL;
    cpl_propertylist *plist=NULL;
    double mjdmin;
    double mjdmax;
*/
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

 /*   char *filename = NULL;
    filename = cpl_sprintf("%s/unit_09.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
    oitf2 = mat_oitf2_load_nt(frame);
    cpl_test(oitf2->nbtf2  == 3 ); 
    cpl_test(oitf2->nbchannel == 15);
    cpl_frame_delete(frame);
    plist=cpl_propertylist_new();
    table=mat_oitf2_to_table(oitf2,plist);
    cpl_test(table != NULL);
    cpl_test(mat_oitf2_delete_nt(oitf2) == CPL_ERROR_NONE);
    oitf2=mat_oitf2_from_table(plist,table);
    cpl_test(oitf2 != NULL);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    cpl_test(mat_oitf2_delete_nt(oitf2) == CPL_ERROR_NONE);
    
    oitf2=mat_oitf2_new(2,10);
    cpl_test(oitf2 != NULL);
    cpl_test(mat_tf2elem_delete(oitf2->list_tf2[1]) == CPL_ERROR_NONE);
    oitf2->list_tf2[1]=mat_tf2elem_new(10);
    cpl_test(oitf2->list_tf2[1]!=NULL);
    cpl_test( mat_oitf2_append_nt( (char *)"foo.fits", oitf2) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oitf2_get_mjd_span(oitf2,&mjdmin,&mjdmax) == CPL_ERROR_NONE);
    cpl_test(mat_oitf2_delete_nt(oitf2) == CPL_ERROR_NONE);
*/
    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
