/* $Id: mat_opd_wvpo-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_opd_wvpo-test.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_corrflux.h"
#include "../mat_opd_wvpo.h"

int main(int argc, char ** argv) {
    int i=0;
    int j=0;
    int k=0;
    mat_corrflux *corrflux=NULL;
    mat_oiopdwvpo *oiopdwvpo=NULL;
    mat_oiopdwvpo **list_oiopdwvpo=NULL;
    mat_oiopd *oiopd=NULL;
    cpl_propertylist *plist=NULL;
    cpl_table *table=NULL;
    /* char output[]="oiopd.fits"; */
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    // Load a dummy corrflux
    corrflux=(mat_corrflux *)cpl_calloc(1, sizeof(mat_corrflux));
    corrflux->keywords=cpl_propertylist_new();
    cpl_propertylist_append_int(corrflux->keywords,"CORRFLUX UNIT TEST",1);
    /* cpl_propertylist_append_string(corrflux->keywords,"ESO INS MODE","4T_LSL_LSN"); */
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF T1NAME","UT1");
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF STATION1","U1");
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T1X",-9.925);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T1Y",-20.335);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T1Z",0.);
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF T2NAME","UT2");
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF STATION2","U2");
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T2X",14.887);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T2Y",30.502);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T2Z",0.);
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF T3NAME","UT3");
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF STATION3","U3");
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T3X",44.915);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T3Y",66.183);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T3Z",0.);
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF T4NAME","UT4");
    cpl_propertylist_append_string(corrflux->keywords,"ESO ISS CONF STATION4","U4");
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T4X",103.306);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T4Y",43.999);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS CONF T4Z",0.);
    cpl_propertylist_append_string(corrflux->keywords,"ESO OBS TARGET NAME","foo");
    cpl_propertylist_append_double(corrflux->keywords,"ESO COU GUID RA",-68.7768);
    cpl_propertylist_append_double(corrflux->keywords,"ESO COU GUID DEC",312.325);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS GEOLAT",-24.6274);
    cpl_propertylist_append_double(corrflux->keywords,"ESO ISS GEOLON",-70.405);
    cpl_propertylist_append_string(corrflux->keywords,"ESO TPL START","2014-04-14T09:42:48");
    cpl_propertylist_append_double(corrflux->keywords,"PRO DISP COEF0",5.05748);
    cpl_propertylist_append_double(corrflux->keywords,"PRO DISP COEF1",0.090462);
    cpl_propertylist_append_double(corrflux->keywords,"PRO DISP COEF2",-2.163E-5);
    cpl_propertylist_append_string(corrflux->keywords,"ESO INS BCD1 ID","OUT");
    cpl_propertylist_append_string(corrflux->keywords,"ESO INS BCD2 ID","OUT");
    cpl_propertylist_append_string(corrflux->keywords,"ESO DET CHIP NAME","AQUARIUS");
    cpl_propertylist_append_bool(corrflux->keywords,"ESO PRO SCIENCE",0);
    cpl_propertylist_append_string(corrflux->keywords,"ESO CFG BCD MODE","IN-IN");
   
    corrflux->nbframe=2;
    corrflux->imgdet=(mat_imagingdetector *)cpl_calloc(1, sizeof(mat_imagingdetector));
    //corrflux->imgdet->origin=cpl_strdup("UNIT TEST");
    corrflux->imgdet->instrument=cpl_strdup("MATISSE");
    corrflux->imgdet->dateobsmjd=0.;
    corrflux->imgdet->dateobs=cpl_strdup("dummy");
    //corrflux->imgdet->date=cpl_strdup("dummy");
    corrflux->imgdet->dcsdictionaryid=cpl_strdup("dummy");
    corrflux->imgdet->dcsid=cpl_strdup("dummy");

    corrflux->imgdet->nbdetector=1;
    corrflux->imgdet->nbtel=4;
    corrflux->imgdet->nbregion=1;
    corrflux->imgdet->list_region=cpl_calloc(corrflux->imgdet->nbregion,
					     sizeof(mat_region *));
    corrflux->imgdet->list_region[0]= (mat_region *)cpl_calloc(1, sizeof(mat_region));
    corrflux->imgdet->list_region[0]->numregion=1;
    corrflux->imgdet->list_region[0]->numdetector=1;
    corrflux->imgdet->list_region[0]->regionname=cpl_strdup("dummy");

    corrflux->imgdet->list_region[0]->numbeam=
	cpl_calloc(corrflux->imgdet->nbtel,sizeof(int));
    corrflux->imgdet->list_region[0]->correlation=1;
    corrflux->imgdet->list_region[0]->corner[0]=0;
    corrflux->imgdet->list_region[0]->corner[1]=0;
    corrflux->imgdet->list_region[0]->gain=1.;
    corrflux->imgdet->list_region[0]->crval[0]=0.;
    corrflux->imgdet->list_region[0]->crval[1]=0.;
    corrflux->imgdet->list_region[0]->crpix[0]=0;
    corrflux->imgdet->list_region[0]->crpix[1]=0;
    corrflux->imgdet->list_region[0]->ctype[0]=cpl_malloc(10*sizeof(char));
    corrflux->imgdet->list_region[0]->ctype[1]=cpl_malloc(10*sizeof(char));
    strncpy(corrflux->imgdet->list_region[0]->ctype[0],"dummy",10);
    strncpy(corrflux->imgdet->list_region[0]->ctype[1],"dummy",10);


    corrflux->imgdet->list_region[0]->naxis[0]=120;
    corrflux->imgdet->list_region[0]->naxis[1]=120;

    corrflux->list_corr=cpl_calloc(corrflux->nbframe, sizeof(mat_imgcorr *));
    for(k=0;k<corrflux->nbframe;k++) {
      corrflux->list_corr[k]= (mat_imgcorr *)cpl_calloc(1, sizeof(mat_imgcorr));
	corrflux->list_corr[k]->numregion=1;
	corrflux->list_corr[k]->numdetector=1;

	corrflux->list_corr[k]->time=1.;
	corrflux->list_corr[k]->exptime=0.02;
	corrflux->list_corr[k]->nbimgreg=2;
	corrflux->list_corr[k]->imgreg=cpl_malloc(2*sizeof(cpl_image *));
	corrflux->list_corr[k]->imgreg[0]=cpl_image_new(1000,1000,CPL_TYPE_FLOAT);
	corrflux->list_corr[k]->imgreg[1]=cpl_image_new(1000,1000,CPL_TYPE_FLOAT);
	for(i=0;i<1000;i++) {
	    for(j=0;j<1000;j++) {
		cpl_image_set(corrflux->list_corr[k]->imgreg[0],i+1,j+1,1.);
		cpl_image_set(corrflux->list_corr[k]->imgreg[1],i+1,j+1,2.);
	    }
	}
    }

    oiopdwvpo=cpl_malloc(sizeof(mat_oiopdwvpo));
    cpl_test(mat_oiopdwvpo_init_from_corrflux(corrflux,oiopdwvpo) == 0);
    cpl_test(oiopdwvpo != NULL);




    cpl_test(mat_oiopdwvpo_delete(oiopdwvpo) == CPL_ERROR_NONE);
    mat_corrflux_free(corrflux);

    list_oiopdwvpo=cpl_calloc(1,sizeof(mat_oiopdwvpo *));
    cpl_test(mat_oiopdwvpo_list_delete(list_oiopdwvpo,0) == CPL_ERROR_NONE);

    oiopd=mat_oiopd_new(6,10);
    cpl_test(oiopd != NULL);
    plist=cpl_propertylist_new();
    table=mat_oiopd_to_table(oiopd,NULL);
    cpl_test(table != NULL);
    cpl_test(mat_oiopd_delete(oiopd) == CPL_ERROR_NONE);
    oiopd=mat_oiopd_from_table(plist,table);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    cpl_test( mat_oiopd_append( (char *)"foo.fits", oiopd,2) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oiopd_delete(oiopd) == CPL_ERROR_NONE);
    
// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

