/* $Id: mat_photbeams-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_photbeams-test.c $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_photbeams.h"
  
int main(int argc, char **argv) {
    int i=0;
    int j=0;
    int k=0;
    int l=0;
    int ix=0;
    mat_photbeams *phot=NULL;
    mat_photbeams *photLoad=NULL;
    cpl_frameset *frames=NULL;
    cpl_frameset *sel_frames=NULL;
    cpl_frame *dummyframe=NULL;
    cpl_frame *dummyframedup=NULL;
    cpl_propertylist *pheader=NULL;
    cpl_parameterlist *parlist=NULL;
    char output[]="photbeams-save.fits";
    (void) argc;
    (void) argv;

    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    remove("photbeams-save.fits");
   
  // Define a dummy matphotbeams
  phot=cpl_malloc(sizeof(mat_photbeams ));
  phot->keywords=NULL;
  phot->list_phot=NULL;
  phot->nbphotxframe=8;

  phot->keywords=cpl_propertylist_new();
  cpl_propertylist_append_string(phot->keywords,CPL_DFS_PRO_CATG, "PHOT_BEAMS");
  cpl_propertylist_append_string(phot->keywords,"ESO INS MODE","MODEMODEMODE");
  cpl_propertylist_append_string(phot->keywords,"ESO INS PIN NAME","PHOTO");
  cpl_propertylist_append_string(phot->keywords,"ESO DET CHIP NAME","AQUARIUS");
  cpl_propertylist_append_string(phot->keywords,"EXTNAME","PHOT_BEAMS");
  phot->imgdet=cpl_malloc(sizeof(mat_imagingdetector));

  //phot->imgdet->origin=cpl_strdup("SIMU");
  phot->imgdet->instrument=cpl_strdup("MATISSE");
  phot->imgdet->dateobs=cpl_strdup("today");
  //phot->imgdet->date=cpl_strdup("today");
  phot->imgdet->dcsdictionaryid=cpl_strdup("1.0");
  phot->imgdet->dcsid=cpl_strdup("1.0");
  phot->imgdet->dateobsmjd=1.;
  phot->imgdet->nbdetector=1;
  phot->imgdet->nbtel=4;
  phot->imgdet->nbregion=4;

  phot->imgdet->list_region=cpl_malloc(phot->imgdet->nbregion*
				       sizeof(mat_region *));
  for(ix=0;ix<phot->imgdet->nbregion;ix++) {
    phot->imgdet->list_region[ix]=cpl_malloc(sizeof(mat_region));
    phot->imgdet->list_region[ix]->numregion=1;
    phot->imgdet->list_region[ix]->regionname=cpl_malloc(10*sizeof(char));
    strncpy(phot->imgdet->list_region[ix]->regionname,"test",10);
    phot->imgdet->list_region[ix]->numdetector=1;
    phot->imgdet->list_region[ix]->numbeam=cpl_malloc(phot->imgdet->nbtel*
						     sizeof(int));
    for(i=0;i<phot->imgdet->nbtel;i++) {
      phot->imgdet->list_region[ix]->numbeam[i]=1;
    }
    phot->imgdet->list_region[ix]->correlation=1;
    phot->imgdet->list_region[ix]->corner[0]=1;
    phot->imgdet->list_region[ix]->corner[1]=1;
    phot->imgdet->list_region[ix]->gain=1.0;
    phot->imgdet->list_region[ix]->crval[0]=0.;
    phot->imgdet->list_region[ix]->crval[1]=0.;
    phot->imgdet->list_region[ix]->crpix[0]=0.;
    phot->imgdet->list_region[ix]->crpix[1]=0.;
    for(i=0;i<2;i++) {
      phot->imgdet->list_region[ix]->ctype[i]=cpl_malloc(10*sizeof(char));
      strncpy(phot->imgdet->list_region[ix]->ctype[i],"PIXEL",10);
    }
    phot->imgdet->list_region[ix]->naxis[0]=10;
    phot->imgdet->list_region[ix]->naxis[1]=10;
  }

  phot->list_phot=cpl_malloc(phot->nbphotxframe*sizeof(mat_imgreg *));
  for(l=0;l<phot->nbphotxframe;l++) {
    phot->list_phot[l]=cpl_malloc(sizeof(mat_imgreg));
    phot->list_phot[l]->numregion=1;
    phot->list_phot[l]->numdetector=1;
    phot->list_phot[l]->nbimgreg=1;
    phot->list_phot[l]->imgreg=cpl_calloc(phot->list_phot[l]->nbimgreg,
					  sizeof(cpl_image *));
    for(k=0;k<phot->list_phot[l]->nbimgreg;k++) {
      phot->list_phot[l]->imgreg[k]=cpl_image_new(
	  phot->imgdet->list_region[0]->naxis[0],
	  phot->imgdet->list_region[0]->naxis[1],
	  CPL_TYPE_FLOAT);
      for(i=1;i<=phot->imgdet->list_region[0]->naxis[0];i++) {
      	for(j=1;j<=phot->imgdet->list_region[0]->naxis[1];j++) {
      	  cpl_image_set(phot->list_phot[l]->imgreg[k],i,j,i+j);
      	}
      }
    }
  }

  char *filename = NULL;
  filename = cpl_sprintf("%s/unit_01.fits", MAT_TESTDATADIR);

  frames=cpl_frameset_new();
  sel_frames=cpl_frameset_new();
  dummyframe=cpl_frame_new();
  cpl_frame_set_filename(dummyframe,filename);
  cpl_free(filename);
  cpl_frame_set_group(dummyframe,CPL_FRAME_GROUP_RAW);
  cpl_frame_set_tag(dummyframe,"DARK");
  cpl_frameset_insert(frames,dummyframe);
  dummyframedup=cpl_frame_duplicate(dummyframe);
  cpl_frameset_insert(sel_frames,dummyframedup);
  pheader=cpl_propertylist_new();
  cpl_propertylist_append_int(pheader,"CORRFLUX UNIT TEST",1);
  parlist=cpl_parameterlist_new();
  
  cpl_test(mat_photbeams_save(phot,pheader,frames,sel_frames,parlist,
			      "DUMMY","DUMMY","DUMMY","DUMMY",
			      output)==0);
  mat_imagingdetector_save(phot->imgdet,pheader,output);
  cpl_parameterlist_delete(parlist);
  cpl_propertylist_delete(pheader);
  cpl_frameset_delete(frames);
  cpl_frameset_delete(sel_frames);



  dummyframe=cpl_frame_new();
  cpl_frame_set_filename(dummyframe,"photbeams-save.fits");
  cpl_frame_set_group(dummyframe,CPL_FRAME_GROUP_RAW);
  cpl_frame_set_tag(dummyframe,"PHOT_BEAMS");
  photLoad=mat_photbeams_load(dummyframe);
  cpl_test(photLoad!=NULL);
  cpl_frame_delete(dummyframe);
    
  /* // Free memory */
  mat_photbeams_free(phot);
  mat_photbeams_free(photLoad);


// Check for memory leak
  cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

