/* $Id: mat_est_opd.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_est_opd.c $
 */
/*------------------------------------------------------------------------------
                                   Includes
 ------------------------------------------------------------------------------*/
#include <cpl.h>
#include "mat_drl.h"
#include "mat_est_opd_lib.h"
/*------------------------------------------------------------------------------
                                   Define
 ------------------------------------------------------------------------------*/
#define TEL_NUMBER 4
#define RECIPE_NAME "mat_est_opd"



/* Plugin detailed description */
static const char *
mat_est_opd_help = 
  "This plugin estimates the OPD for each baseline for each frame. It takes as input teh correlated flux.\n"
  " It alloaws aslo to estimate chromatic OPD by fitting the Matthar's model (2007). If  ChromaticOpdFit=TRUE,  \n"
  " the output contains temperature and relative humidity offsets (Matthar's model).\n"
  "\n"
  "Input Files:\n"
  "\n"
  "    DO category:           Explanation:                Required:\n"
  "    OBJ_CORR_FLUX          Correlated flux             Yes \n"
  "\n"
  "Output Files:\n"
  "\n"
  "    DO category:           Explanation:\n"
  "    OI_OPDWVPO             OPD estimation\n";
static int mat_est_opd_create(cpl_plugin *);
static int mat_est_opd_exec(cpl_plugin *);
static int mat_est_opd_destroy(cpl_plugin *);

int cpl_plugin_get_info(cpl_pluginlist *list)
{
    cpl_recipe *recipe = cpl_calloc(1, sizeof *recipe);
    cpl_plugin *plugin = (cpl_plugin *)recipe;
    cpl_plugin_init(plugin,
                     CPL_PLUGIN_API,
                     MATISSE_BINARY_VERSION,
                     CPL_PLUGIN_TYPE_RECIPE,
                     "mat_est_opd",
                     "Estimation of the OPD",
                     mat_est_opd_help,
                     "Philippe Berio",
                     PACKAGE_BUGREPORT,
                     "GPL",
                     mat_est_opd_create,
                     mat_est_opd_exec,
                     mat_est_opd_destroy);
    cpl_pluginlist_append(list, plugin);
    return 0;
    }

static int mat_est_opd_create(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    /* cpl_parameter *p; */
    recipe->parameters = cpl_parameterlist_new();

    /* p = cpl_parameter_new_value("matisse.mat_est_opd.ChromaticOpdFit", */
    /* 				CPL_TYPE_BOOL,  */
    /* 				"Chromatic OPD Fit Option. If ChromaticOpdFit=TRUE, we fit the chromatic OPD following Matthar's model. ", */
    /* 				"matisse.mat_est_opd",FALSE); */
    /* cpl_parameter_set_alias(p, CPL_PARAMETER_MODE_CLI, "ChromaticOpdFit") ; */
    /* cpl_parameterlist_append(recipe->parameters, p) ; */

    cpl_msg_info("mat_est_opd_create", "Parameters created.");

    return 0;
}
static int mat_est_opd_destroy(cpl_plugin *plugin)
{
    cpl_recipe *recipe = (cpl_recipe *)plugin;
    cpl_parameterlist_delete(recipe->parameters);
    //cpl_memory_dump();
    return 0;
}


static int mat_est_opd_exec(cpl_plugin *plugin)
{
  cpl_recipe *recipe = (cpl_recipe *)plugin;

  if (mat_est_opd_lib(recipe->frames,recipe->parameters,RECIPE_NAME)) {
    cpl_msg_warning(cpl_func,"Error in mat_est_opd_lib");
    return CPL_ERROR_ILLEGAL_OUTPUT;
  }
  return 0;
}

