#!/usr/bin/env python

# import reflex module
from __future__ import print_function
from __future__ import absolute_import
from astropy.io import fits
import string
import numpy as np
import sys
from decimal import *

def computeLambdas(C0, C1, C2, C3, C4, CORNER, N, lambd):

   # lambd = []
    for i in range(N):
        lambd.append(C0+C1*(i+CORNER)+C2*(i+CORNER)*(i+CORNER)+C3*(i+CORNER)*(i+CORNER)*(i+CORNER)+C4*(i+CORNER)*(i+CORNER)*(i+CORNER)*(i+CORNER))
#2 CHIFFRES APRES LA VIRGULE


def readLambda(fitsFileName):
    f = fits.open(fitsFileName) 
    prihdr=f[0].header 
    data_corner = f[f.index_of('IMAGING_DETECTOR')].data
    f.close()
  #data use to calculate lambda
    C0 = float(prihdr['HIERARCH PRO DISP COEF0'])
    C1 = float(prihdr['HIERARCH PRO DISP COEF1'])
    C2 = float(prihdr['HIERARCH PRO DISP COEF2'])
    CORNER = np.array(data_corner.field("CORNER"), np.int16)[0][1]
    N = np.array(data_corner.field("NAXIS"), np.int16)[0][1]
    #lambda
    lambd = []
    for i in range(N):
        lambd.append(C0+C1*(i+CORNER)+C2*(i+CORNER)*(i+CORNER))
    return lambd

#factoriser calcul des lambdas?
def readFile(fitsFileName):

    #read data file
    f = fits.open(fitsFileName) 
#print(f.info())
    #primary header
    prihdr=f[0].header 
    #table "PHOT_BEAMS"
    data_phot = f[f.index_of('PHOT_BEAMS')].data
    data = []
    #table "IMAGING_DETECTOR"
    data_corner = f[f.index_of('IMAGING_DETECTOR')].data
    f.close()

#    datas={'obj': prihdr['HIERARCH ESO OBS TARGET NAME'], 'dit':prihdr['HIERARCH ESO DET DIT'],'date':prihdr['DATE'],'detector': prihdr['HIERARCH ESO DET CHIP NAME']}


    #data use to calculate lambda
    C0 = float(prihdr['HIERARCH PRO DISP COEF0'])
    C1 = float(prihdr['HIERARCH PRO DISP COEF1'])
    C2 = float(prihdr['HIERARCH PRO DISP COEF2'])
    C3 = float(prihdr['HIERARCH PRO DISP COEF3'])
    C4 = float(prihdr['HIERARCH PRO DISP COEF4'])
    CORNER = np.array(data_corner.field("CORNER"), np.int16)[0][1]
    N = np.array(data_corner.field("NAXIS"), np.int16)[0][1]


    #PHOT_BEAMS
    #binary table
    vec = []
    spec = []
    image = np.array(data_phot.field("DATANOSKY1"), np.float32)#nbraw*naxis[0]*naxis[1]
#spectre, sommer les images[i] => un seul vecteur nblambda*nb
#np.sum(image)
#que datanosky
    aux = []
    addIm = image[0]
    for i in range(0,len(image)-1):
        aux.append(np.sum(image[i], axis = 1))  
        if i > 0:
            addIm = np.add(addIm,image[i])
    vec.append(aux) #SOMME POUR CHAQUE IMAGE !!! 
    spec.append(np.sum(addIm, axis = 1))

    image = np.array(data_phot.field("DATANOSKY2"), np.float32)    
    aux = []
    addIm = image[0]
    for i in range(0,len(image)-1):
        aux.append(np.sum(image[i], axis = 1))
        if i > 0:
            addIm = np.add(addIm,image[i])
    vec.append(aux)
    spec.append(np.sum(addIm, axis = 1))

    image = np.array(data_phot.field("DATANOSKY3"), np.float32)
    aux = []
    addIm = image[0]
    for i in range(0,len(image)-1):
        aux.append(np.sum(image[i], axis = 1))
        if i > 0:
            addIm = np.add(addIm,image[i])
    vec.append(aux)
    spec.append(np.sum(addIm, axis = 1))
    

    image = np.array(data_phot.field("DATANOSKY4"), np.float32)
    aux = []
    addIm = image[0]
    for i in range(0,len(image)-1):
        aux.append(np.sum(image[i], axis = 1))
        if i > 0:
            addIm = np.add(addIm,image[i])
    vec.append(aux)
    spec.append(np.sum(addIm, axis = 1))
                



    #lambda
    lambd = []
    for i in range(N):
        #lambd.append(C0+C1*(i+CORNER)+C2*(i+CORNER)*(i+CORNER))
        lambd.append(C0+C1*(i+CORNER)+C2*(i+CORNER)*(i+CORNER)+C3*(i+CORNER)*(i+CORNER)*(i+CORNER)+C4*(i+CORNER)*(i+CORNER)*(i+CORNER)*(i+CORNER))
   # print(lambd)
    
#return dictionary vec, vecsky, lambd
    return {'phot':vec, 'lambda':lambd, 'spectrum':spec}
    #return {'phot':vec, 'sky': vecSky, 'lambda':lambd, 'spectrum':spec}

  
def readIndice(array, value):
    i = 0
    while i<len(array):
        if array[i] == value:
            return i
        else:
            i = i+1
    return -1
    
def readIndiceMean(array, value):
    near_value = array[0]
    i = 1
    while i<len(array):
        if abs(value-array[i]) < abs(value-near_value):
            near_value = array[i]
        i = i+1
    return readIndice(array, near_value)
        

def readData(header):
    return {'obj': header['OBJECT'], 'time': header["EXPTIME"], 'date': header['DATE-OBS'], 'name': header['ESO DET CHIP NAME']}
