from edps import classification_rule

from . import matisse_keywords as kwd
from . import matisse_rules as rules

# Dictionaries containing the values of header keywords that define calibrations and science data
# in the red and blue arms.
matisse = {kwd.instrume: "MATISSE"}
calib_kwd = {**matisse, kwd.dpr_catg: "CALIB"}
test_kwd = {**matisse, kwd.dpr_catg: "TEST"}
calib_spectrum_kwd = {**calib_kwd, kwd.dpr_tech: "SPECTRUM", }
calib_image_kwd = {**calib_kwd, kwd.dpr_tech: "IMAGE"}
calib_image_basic_kwd = {**calib_kwd, kwd.dpr_tech: "IMAGE,BASIC"}
calib_image_extended_kwd = {**calib_kwd, kwd.dpr_tech: "IMAGE,EXTENDED"}
calib_image_remanence_kwd = {**calib_kwd, kwd.dpr_tech: "IMAGE,REMANENCE"}
calib_interferometry_kwd = {**calib_kwd, kwd.dpr_tech: "INTERFEROMETRY"}
test_interferometry_kwd = {**test_kwd, kwd.dpr_tech: "INTERFEROMETRY"}

science_kwd = {**matisse, kwd.dpr_catg: "SCIENCE"}
science_interferometry_kwd = {**science_kwd, kwd.dpr_tech: "INTERFEROMETRY"}
acquisition_kwd = {**matisse, kwd.dpr_catg: ["CALIB", "ACQUISITION"]}
acquisition_interferometry_kwd = {**acquisition_kwd, kwd.dpr_tech: "INTERFEROMETRY"}
acquisition_image_kwd = {**acquisition_kwd, kwd.dpr_tech: "IMAGE"}

slow_speed_calib_kwd = {**calib_kwd, kwd.det_read_curname: "SCI-SLOW-SPEED"}
fast_speed_calib_kwd = {**calib_kwd, kwd.det_read_curname: "SCI-FAST-SPEED"}
low_gain_calib_kwd = {**calib_kwd, kwd.det_read_curname: "SCI-LOW-GAIN"}
high_gain_calib_kwd = {**calib_kwd, kwd.det_read_curname: "SCI-HIGH-GAIN"}

# ---- Classification rules  -----------------


# --- Matisse Raw types
# -Raw classes for detector calibration
dark_class = classification_rule("DARK", rules.is_dark)
flat_class = classification_rule("FLAT", rules.is_flat)

# -Raw classes for flat fielding


flat_off_class = classification_rule("OBSDARK", {**calib_spectrum_kwd, kwd.dpr_type: ["DARK", "FLAT,OFF"]})
flat_on_class = classification_rule("OBSFLAT", {**calib_spectrum_kwd, kwd.dpr_tech: "INTERFEROMETRY",
                                                kwd.dpr_type: ["FLAT", "FLAT,BLACKBODY"]})

# - Raw classes for distortion correction
distor_hotdark_class = classification_rule("DISTOR_HOTDARK",
                                           {**calib_image_kwd, kwd.dpr_type: ["DARK", "DARK,WAVE"]})

distor_images_class = classification_rule("DISTOR_IMAGES", rules.is_distor_images)

spectra_hotdark_class = classification_rule("SPECTRA_HOTDARK",
                                            {**calib_spectrum_kwd, kwd.dpr_type: ["SOURCE,LAMP", "WAVE,LAMP,SLIT"]})

spectra_images_class = classification_rule("SPECTRA_IMAGES",
                                           {**calib_spectrum_kwd, kwd.dpr_type: ["SOURCE,WAVE", "WAVE,LAMP,FOIL"]})

im_cold_class = classification_rule("IM_COLD", {**calib_image_basic_kwd, kwd.dpr_type: "DARK"})

# very high resolution
distortion_calibrator = classification_rule("CALIB_RAW",
                                            {**calib_interferometry_kwd, kwd.dpr_type: ["STD,WAVE", "OBJECT"]})
distortion_sky = classification_rule("CALIB_SKY", {**calib_interferometry_kwd, kwd.dpr_type: "SKY,WAVE"})

# Classification rules for instrument monitor or test acquisitions exposures

test_calib_raw_class = classification_rule("RMNREC", {**test_interferometry_kwd,
                                                      kwd.dpr_type: ["STD,RMNREC", "OBJECT,RMNREC",
                                                                     "OBJECT,FLUX,RMNREC"]})

calib_raw_rmnrec_class = classification_rule("RMNREC", {**calib_interferometry_kwd,
                                                        kwd.dpr_type: ["STD,RMNREC", "OBJECT,RMNREC",
                                                                       "OBJECT,FLUX,RMNREC"]})

cophasing_lab_dark_class = classification_rule("COPHASING_LAB_DARK",
                                               {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST", "CALIB"],
                                                kwd.dpr_tech: "INTERFEROMETRY",
                                                kwd.dpr_type: "FRINGE,BACKGROUND"})

cophasing_lab_lamp_class = classification_rule("COPHASING_LAB_LAMP",
                                               {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST", "CALIB"],
                                                kwd.dpr_tech: "INTERFEROMETRY",
                                                kwd.dpr_type: "FRINGE,LAMP"})

cophasing_image_hotdark_class = classification_rule("PER_IMG_HOTDARK",
                                                    {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST"],
                                                     kwd.dpr_tech: "IMAGE,PERISCOPE",
                                                     kwd.dpr_type: "FOCUS,BACKGROUND"})

cophasing_image_lamp_class = classification_rule("PER_IMG_LAMP", {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST"],
                                                                  kwd.dpr_tech: "IMAGE,PERISCOPE",
                                                                  kwd.dpr_type: ["FOCUS,LAMP", "SOURCE,FOCUS"]})

cophasing_pupil_hotdark_class = classification_rule("PER_PUP_HOTDARK",
                                                    {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST"],
                                                     kwd.dpr_tech: "IMAGE,PERISCOPE",
                                                     kwd.dpr_type: "PUPIL,BACKGROUND"})

cophasing_pupil_lamp_class = classification_rule("PER_PUP_LAMP", {**matisse, kwd.dpr_catg: ["TECHNICAL", "TEST"],
                                                                  kwd.dpr_tech: "IMAGE,PERISCOPE",
                                                                  kwd.dpr_type: "PUPIL,LAMP"})

raw_std_image_class = classification_rule("STD_IMAGE", {**calib_image_kwd, kwd.dpr_type: "STD"})

raw_ali_refpix_class = classification_rule("IM_REF", {**matisse, kwd.dpr_catg: ["TECHICAL", "TEST", "CALIB"],
                                                      kwd.dpr_tech: "IMAGE", kwd.dpr_type: "DARK,FOCUS"})

raw_acq_search_sky_class = classification_rule("ACQ_FR_SKY",
                                               {**acquisition_interferometry_kwd, kwd.dpr_type: "SEARCH,SKY"})

raw_acq_search_object_class = classification_rule("ACQ_FR_OBJECT",
                                                  {**acquisition_interferometry_kwd, kwd.dpr_type: "SEARCH,OBJECT"})

raw_acq_search_calib_class = classification_rule("ACQ_FR_CALIB",
                                                 {**acquisition_interferometry_kwd, kwd.dpr_type: "SEARCH,STD"})

raw_acq_image_sky_class = classification_rule("ACQ_IMG_SKY",
                                              {**acquisition_image_kwd, kwd.dpr_type: ["SEARCH,SKY", "SKY"]})

raw_acq_image_object_class = classification_rule("ACQ_IMG_OBJECT",
                                                 {**acquisition_image_kwd, kwd.dpr_type: "SEARCH,OBJECT"})

raw_acq_image_calib_class = classification_rule("ACQ_IMG_CALIB",
                                                {**acquisition_image_kwd, kwd.dpr_type: ["SEARCH,STD", "STD"]})

raw_acq_pupil_sky_class = classification_rule("ACQ_PUP_SKY", {**acquisition_image_kwd, kwd.dpr_type: "PUPIL,SKY"})

raw_acq_pupil_object_class = classification_rule("ACQ_PUP_OBJECT",
                                                 {**acquisition_image_kwd, kwd.dpr_type: "PUPIL,OBJECT"})

raw_acq_pupil_calib_class = classification_rule("ACQ_PUP_CALIB", {**acquisition_image_kwd, kwd.dpr_type: "PUPIL,STD"})

target_raw_rmnrec_class = classification_rule("TARGET_RAW_RMNREC", {**science_interferometry_kwd,
                                                                    kwd.dpr_type: ["OBJECT,RMNREC",
                                                                                   "OBJECT,FLUX,RMNREC"]})

im_extended_class = classification_rule("IM_FLAT", {**calib_image_extended_kwd, kwd.dpr_type: "FLAT"})

im_remanence1_class = classification_rule("IM_PERIODIC", {**calib_image_remanence_kwd, kwd.dpr_type: "DARK"})
im_remanence2_class = classification_rule("IM_PERIODIC", {**calib_image_kwd, kwd.dpr_type: "DARK,FLAT"})

# - Raw classes for correction of relative intensity and geometry distortion between beams
kappa_hotdark_class = classification_rule("KAPPA_HOTDARK", rules.is_kappa_hotdark)
kappa_src_class = classification_rule("KAPPA_SRC", rules.is_kappa_src)
kappa_object_class = classification_rule("KAPPA_OBJ", {**calib_image_kwd, kwd.dpr_type: "OBJECT,FLUX"})

# -Interferometric calibrations
hot_dark_shutter_open_class = classification_rule("HOT_DARK", rules.is_hot_dark_open)
hot_dark_shutter_closed_class = classification_rule("HOT_DARK", rules.is_hot_dark_closed)
hot_lamp_shutter_open_class = classification_rule("CALIB_SRC_RAW", rules.is_hot_lamp_open)
hot_lamp_shutter_closed_class = classification_rule("CALIB_SRC_RAW", rules.is_hot_lamp_closed)

# -Target calibrators
raw_target_calib_shutter_open_class = classification_rule("CALIB_RAW", rules.is_target_calib_shutter_open)
raw_target_calib_shutter_closed_class = classification_rule("CALIB_RAW", rules.is_target_calib_shutter_closed)
raw_source_calib_shutter_open_class = classification_rule("CALIB_SRC_RAW", rules.is_source_calib_shutter_open)
raw_source_calib_shutter_closed_class = classification_rule("CALIB_SRC_RAW", rules.is_source_calib_shutter_closed)

# -Science targets
raw_target_sci_shutter_open_class = classification_rule("TARGET_RAW", rules.is_science_target_open)
raw_target_sci_shutter_closed_class = classification_rule("TARGET_RAW", rules.is_science_target_closed)

raw_sky_class = classification_rule("SKY_RAW", {**calib_interferometry_kwd, kwd.dpr_type: "SKY"})

# --- Matisse products types
# -Reduced data for target and calibrator
reduced_target_outout_class = classification_rule("TARGET_RAW_INT", {**matisse, kwd.pro_catg: "TARGET_RAW_INT",
                                                                     kwd.cfg_bcd_mode: "OUT-OUT"})
reduced_target_inin_class = classification_rule("TARGET_RAW_INT",
                                                {**matisse, kwd.pro_catg: "TARGET_RAW_INT", kwd.cfg_bcd_mode: "IN-IN"})
reduced_target_inout_class = classification_rule("TARGET_RAW_INT", {**matisse, kwd.pro_catg: "TARGET_RAW_INT",
                                                                    kwd.cfg_bcd_mode: "IN-OUT"})
reduced_target_outin_class = classification_rule("TARGET_RAW_INT", {**matisse, kwd.pro_catg: "TARGET_RAW_INT",
                                                                    kwd.cfg_bcd_mode: "OUT-IN"})

reduced_calibrator_outout_class = classification_rule("CALIB_RAW_INT", rules.is_out_out)
reduced_calibrator_inin_class = classification_rule("CALIB_RAW_INT", rules.is_in_in)
reduced_calibrator_inout_class = classification_rule("CALIB_RAW_INT", rules.is_in_out)
reduced_calibrator_outin_class = classification_rule("CALIB_RAW_INT", rules.is_out_in)

# -Master calibrations
BADPIX = classification_rule('BADPIX', {**matisse, kwd.pro_catg: "BADPIX"})
FLATFIELD = classification_rule('FLATFIELD', {**matisse, kwd.pro_catg: "FLATFIELD"})
NONLINEARITY = classification_rule('NONLINEARITY', {**matisse, kwd.pro_catg: 'NONLINEARITY'})
OBS_FLATFIELD = classification_rule('OBS_FLATFIELD', {**matisse, kwd.pro_catg: 'OBS_FLATFIELD'})
SHIFT_MAP = classification_rule('SHIFT_MAP', {**matisse, kwd.pro_catg: 'SHIFT_MAP'})
KAPPA_MATRIX = classification_rule('KAPPA_MATRIX', {**matisse, kwd.pro_catg: 'KAPPA_MATRIX'})
CALIB_RAW_INT = classification_rule("CALIB_RAW_INT", {**matisse, kwd.pro_catg: "CALIB_RAW_INT"})
TARGET_RAW_INT = classification_rule("TARGET_RAW_INT", {**matisse, kwd.pro_catg: "TARGET_RAW_INT"})

OI_OPDWVPO = classification_rule("OI_OPDWVPO", {**matisse, kwd.pro_catg: "OI_OPDWVPO"})
PHOT_BEAMS = classification_rule("PHOT_BEAMS", {**matisse, kwd.pro_catg: "PHOT_BEAMS"})
OBJ_CORR_FLUX = classification_rule("OBJ_CORR_FLUX", {**matisse, kwd.pro_catg: "OBJ_CORR_FLUX"})

RAW_CPHASE = classification_rule("RAW_CPHASE", {**matisse, kwd.pro_catg: "RAW_CPHASE"})
RAW_DPHASE = classification_rule("RAW_DPHASE", {**matisse, kwd.pro_catg: "RAW_DPHASE"})
RAW_SPECTRUM = classification_rule("RAW_SPECTRUM", {**matisse, kwd.pro_catg: "RAW_SPECTRUM"})
RAW_VIS2 = classification_rule("RAW_VIS2", {**matisse, kwd.pro_catg: "RAW_VIS2"})

# -Static calibrations
jsdc_cat_class = classification_rule('JSDC_CAT', {**matisse, kwd.pro_catg: 'JSDC_CAT'})
atmosphere_class = classification_rule("SPEC_ATM", {**matisse, kwd.pro_catg: "SPEC_ATM"})
