from edps import subworkflow, qc0, qc1calib, task, ReportInput

from .matisse_datasources import same_raw_inputs, group_observations
from .matisse_task_functions import which_bcd_mode, set_bcd_mode


@subworkflow("merge_results", "")
def merge_results(incoherent, coherent, data_type, transfer_function=None):
    # Subworkflow to merge the uncalibrated visibilities.
    #
    # The input data_type ("calibrator"/"science") determines the task name. For "calibrator" data types, the transfer
    # function can to be provided.

    merge = (task("merge_" + data_type)
             .with_recipe("mat_merge_results")
             .with_job_processing(set_bcd_mode)  # Set the recipe parameter bcdMode depending on the type of input data
             .with_dynamic_parameter("which_bcd_mode", which_bcd_mode)
             .with_main_input(incoherent)
             .with_associated_input(coherent, min_ret=0, match_rules=same_raw_inputs)
             .with_grouping_keywords(group_observations))

    if transfer_function is not None:
        merge = merge.with_associated_input(transfer_function, min_ret=0)

    if data_type == "science":
        merge = merge.with_meta_targets([qc0, "merge", "science"])

    elif data_type in ["calibrator", "internal_lamp"]:
        merge = (merge
                 .with_report("matisse_calibrator", ReportInput.RECIPE_INPUTS_OUTPUTS)
                 .with_meta_targets([qc1calib, "merge"]))

    return merge.build()
