from edps.generator.util import match

from . import matisse_keywords as kwd


def is_matisse(f):
    return f[kwd.instrume] == "MATISSE"


def is_calib(f):
    return is_matisse(f) and f[kwd.dpr_catg] == "CALIB"


def is_test(f):
    return is_matisse(f) and f[kwd.dpr_catg] == "TEST"


def is_science(f):
    return is_matisse(f) and f[kwd.dpr_catg] == "SCIENCE"


def is_image(f):
    return is_matisse(f) and f[kwd.dpr_tech] == "IMAGE"


def is_interferometry(f):
    return is_matisse(f) and f[kwd.dpr_tech] == "INTERFEROMETRY"


def is_spectrum(f):
    return is_matisse(f) and f[kwd.dpr_tech] == "SPECTRUM"


def is_image_detchar(f):
    return is_matisse(f) and f[kwd.dpr_tech] == "IMAGE,DETCHAR"


def is_dark(f):
    return (is_calib(f) and is_image(f) and f[kwd.dpr_type] == "DARK,DETCAL") or \
        (is_calib(f) and is_image_detchar(f) and f[kwd.dpr_type] == "DARK")


def is_flat(f):
    return (is_calib(f) and is_image(f) and f[kwd.dpr_type] == "FLAT,DETCAL") or \
        (is_calib(f) and is_image_detchar(f) and f[kwd.dpr_type] == "FLAT")


def is_distor_images(f):
    return is_calib(f) and (is_image(f) and f[kwd.dpr_type] == "SOURCE,WAVE" or
                            is_spectrum(f) and f[kwd.dpr_type] == "WAVE,LAMP,PINHOLE")


def is_kappa_hotdark(f):
    return is_calib(f) and ((is_image(f) and f[kwd.dpr_type] == "DARK,FLUX") or
                            (is_spectrum(f) and f[kwd.dpr_type] in ["KAPPA,BACKGROUND", "KAPPA,DARK"]))


def is_kappa_src(f):
    return is_calib(f) and ((is_image(f) and f[kwd.dpr_type] == "SOURCE,FLUX") or
                            (is_spectrum(f) and f[kwd.dpr_type] == "KAPPA,LAMP"))


def is_out_out(f):
    return f[kwd.pro_catg] == "CALIB_RAW_INT" and f[kwd.cfg_bcd_mode] == "OUT-OUT" and f[kwd.diameter] > 0


def is_in_in(f):
    return f[kwd.pro_catg] == "CALIB_RAW_INT" and f[kwd.cfg_bcd_mode] == "IN-IN" and f[kwd.diameter] > 0


def is_in_out(f):
    return f[kwd.pro_catg] == "CALIB_RAW_INT" and f[kwd.cfg_bcd_mode] == "IN-OUT" and f[kwd.diameter] > 0


def is_out_in(f):
    return f[kwd.pro_catg] == "CALIB_RAW_INT" and f[kwd.cfg_bcd_mode] == "OUT-IN" and f[kwd.diameter] > 0


def is_shutter_open(f):
    return f[kwd.ins_bsn1_st] == True and f[kwd.ins_bsn2_st] == True and f[kwd.ins_bsn3_st] == True and \
        f[kwd.ins_bsn4_st] == True


def is_target_calib(f):
    return is_calib(f) and is_interferometry(f) and f[kwd.dpr_type] in ["STD", "OBJECT", "OBJECT,FLUX"]


def is_target_calib_shutter_open(f):
    return is_target_calib(f) and is_shutter_open(f)


def is_target_calib_shutter_closed(f):
    return is_target_calib(f) and not is_shutter_open(f)


def is_source_calib(f):
    return is_calib(f) and is_interferometry(f) and f[kwd.dpr_type] in ["SOURCE", "SOURCE,FLUX"]


def is_source_calib_shutter_open(f):
    return is_source_calib(f) and is_shutter_open(f)


def is_source_calib_shutter_closed(f):
    return is_source_calib(f) and not is_shutter_open(f)


def is_science_target(f):
    return is_science(f) and is_interferometry(f) and f[kwd.dpr_type] in ["OBJECT", "OBJECT,FLUX"]


def is_science_target_open(f):
    return is_science_target(f) and is_shutter_open(f)


def is_science_target_closed(f):
    return is_science_target(f) and not is_shutter_open(f)


def is_hot_dark(f):
    return (is_calib(f) or is_test(f)) and is_interferometry(f) and f[kwd.dpr_type] in ["DARK", "BACKGROUND"]


def is_hot_dark_open(f):
    return is_hot_dark(f) and is_shutter_open(f)


def is_hot_dark_closed(f):
    return is_hot_dark(f) and not is_shutter_open(f)


def is_hot_lamp(f):
    return (is_calib(f) or is_test(f)) and is_interferometry(f) and f[kwd.dpr_type] == "LAMP"


def is_hot_lamp_open(f):
    return is_hot_lamp(f) and is_shutter_open(f)


def is_hot_lamp_closed(f):
    return is_hot_lamp(f) and not is_shutter_open(f)


# --- ASSOCIATION RULES ---------------------------------------------------------------------------
#  -  first, e.g.  ref=trigger (e.g. science)
#  -  second, e.g.  f=file to associate (e.g. calibration)
#

def is_assoc_dark(ref, f):
    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname]) and (
            (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.det_seq1_dit])) or
            (f[kwd.det_chip_name] == "HAWAII-2RG"))


def is_assoc_flat(ref, f):
    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname, kwd.det_seq1_dit]) and (
            (f[kwd.det_chip_name] == "AQUARIUS" and ref[kwd.ins_pin_name] == "PHOTO" and match(ref, f, [
                kwd.ins_din_name])) or (
                    f[kwd.det_chip_name] == "HAWAII-2RG" and ref[kwd.ins_pil_name] == "PHOTO" and
                    match(ref, f, [kwd.ins_dil_name])))


def is_assoc_flat_science(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-SLOW-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name, kwd.det_win_mtrs2, kwd.det_win_mtrh2]))

    c2 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-FAST-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name]))

    c3 = (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.ins_pin_name, kwd.ins_din_name]))

    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname, kwd.det_seq1_dit]) and (c1 or c2 or c3)


def is_assoc_flat_lamp(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-SLOW-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name, kwd.det_win_mtrs2, kwd.det_win_mtrh2]))

    c2 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-FAST-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name]))

    c3 = (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.ins_pin_name, kwd.ins_din_name]))

    c4 = abs(ref[kwd.det_seq1_dit] - f[kwd.det_seq1_dit]) < 0.001

    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname]) and (c1 or c2 or c3) and c4


def is_assoc_flat_calibrator(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-SLOW-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name, kwd.det_win_mtrs2, kwd.det_win_mtrh2]))

    c2 = (f[kwd.det_chip_name] == "HAWAII-2RG" and f[kwd.det_read_curname] == "SCI-FAST-SPEED" and
          match(ref, f, [kwd.ins_pil_name, kwd.ins_dil_name]))

    c3 = (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.ins_pin_name, kwd.ins_din_name]))

    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname, kwd.det_seq1_dit]) and (c1 or c2 or c3)


def is_assoc_flat_kappa(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and ref[kwd.ins_pil_name] == "PHOTO" and
          match(ref, f, [kwd.ins_dil_name]))

    c2 = (f[kwd.det_chip_name] == "AQUARIUS" and ref[kwd.ins_pin_name] == "PHOTO" and match(ref, f, [kwd.ins_din_name]))

    c3 = abs(ref[kwd.det_seq1_dit] - f[kwd.det_seq1_dit]) < 0.001

    return match(ref, f, [kwd.det_chip_name, kwd.det_read_curname]) and (c1 or c2) and c3
    # return True


def is_assoc_distortion(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and match(ref, f, [kwd.ins_dil_name]) and
          (f[kwd.ins_dil_name] in ["LOW", "MED", "HIGH"]))
    c2 = (f[kwd.det_chip_name] == "HAWAII-2RG" and match(ref, f, [kwd.ins_dil_name]) and
          f[kwd.ins_dil_name] == "HIGH+" and match(ref, f, [kwd.ins_fil_name]))
    c3 = (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.ins_din_name]))
    return match(ref, f, [kwd.det_name]) and (c1 or c2 or c3)


def is_assoc_kappa(ref, f):
    c1 = (f[kwd.det_chip_name] == "HAWAII-2RG" and
          match(ref, f, [kwd.ins_pol_name, kwd.ins_fil_name, kwd.ins_dil_name]))
    c2 = (f[kwd.det_chip_name] == "AQUARIUS" and match(ref, f, [kwd.ins_pon_name, kwd.ins_fin_name, kwd.ins_din_name]))
    return match(ref, f, [kwd.det_chip_name]) and (c1 or c2)


def is_assoc_raw_calibrator(ref, f):
    c1 = (match(ref, f, [kwd.ins_pol_name, kwd.ins_fil_name, kwd.ins_dil_name, kwd.seq_dil_wl0]) and
          f[kwd.det_chip_name] == "HAWAII-2RG")
    c2 = match(ref, f, [kwd.ins_pon_name, kwd.ins_fin_name, kwd.ins_din_name]) and f[kwd.det_chip_name] == "AQUARIUS"
    return match(ref, f, [kwd.det_chip_name, "$associate_calibrators_kwd"]) and (c1 or c2)


def is_assoc_calibrators(ref, f):
    c1 = match(ref, f,
               [kwd.tpl_id, kwd.det_chip_name, kwd.det_read_curname, kwd.det_seq1_dit, "$associate_calibrators_kwd"])
    c2 = (match(ref, f, [kwd.ins_pol_id, kwd.ins_fil_id, kwd.ins_dil_id]) and
          f[kwd.det_read_curname] == "SCI-FAST-SPEED" and f[kwd.det_chip_name] == "HAWAII-2RG")
    c3 = (match(ref, f, [kwd.ins_pol_id, kwd.ins_fil_id, kwd.ins_dil_id, kwd.det_win_mtrs2, kwd.det_win_mtrh2]) and
          f[kwd.det_read_curname] == "SCI-SLOW-SPEED" and f[kwd.det_chip_name] == "HAWAII-2RG")
    c4 = match(ref, f, [kwd.ins_pon_id, kwd.ins_fin_id, kwd.ins_din_id]) and f[kwd.det_chip_name] == "AQUARIUS"

    return c1 and (c2 or c3 or c4)
