/* $Id: mat_cal_dphase_lib.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/11/29  $
 * $Revision: 0.5 $
 * $Name: mat_cal_dphase_lib.c $
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "mat_cal_dphase_lib.h"


/*-----------------------------------------------------------------------------
  Functions prototypes
  ----------------------------------------------------------------------------*/






/*---------------------------------------------------------------------------*/
/**
   @brief This function is called by the mat_cal_cdhase recipe
   @param parlist         contains the parameters supported 
   by the recipe
   @param  frameset       the list of frames that have been given to
   the recipe for processing
   @param recname         Name of the recipes calling this function
   @return 0 if everything is ok
*/
/*----------------------------------------------------------------------------*/

int mat_cal_dphase_lib(cpl_parameterlist *parlist, cpl_frameset *frameset,
                       const char *recname)
{
    
    /* Ranges */
    int nbWlen, nbVis;
    /* Counters */
    /*int iWlen=0,iVis=0;*/
    
    cpl_frame           *cur_frame          = NULL;
    cpl_frame           *frame              = NULL;
    cpl_frameset        *usedframes         = NULL;
    cpl_propertylist    *p_list             = NULL;
    cpl_propertylist    *p_list_array       = NULL;
    cpl_propertylist    *p_list_oitransfunc = NULL;
    cpl_propertylist    *qclist             = NULL;
    cpl_table           *table              = NULL;
    /* int expert = 0; */

    int nb_extent = 0;
    int nbfile    = 0;
    
    int i   = 0;
    int j   = 0;
    int k   = 0;
    int l   = 0;
    int m   = 0;
    int cpt = 0;
    int  nbExpTotal = 0;        /* Nb of exposures for all calibrators */
    int *nbExp  = NULL;
    int  nbTel  = 0;
    int  nbBase = 0;
    int  index1 = 0;
    int  index2 = 0;
    int  flag   = 0;
    
    int          nbOifitscal   = 0;     /* Nb of files for calibrators */
    int          indexChipName = 0;
    /* char filename[200] = " "; */
    char        *filename      = NULL;
    
    double **dphiTF    = NULL;/* Tranfer function as a function of time */
    double **dphiTFerr = NULL;/* Tranfer function error as a function of time */
    double  *dphiInterpTF    = NULL;/* interpolated transfer function */
    double  *dphiInterpTFvar = NULL;/* interpolated transfer function error */
    
    double **dvisTF    = NULL;/* Tranfer function as a function of time */
    double **dvisTFerr = NULL;/* Tranfer function error as a function of time */
    double  *dvisInterpTF    = NULL;/* interpolated transfer function */
    double  *dvisInterpTFvar = NULL;/* interpolated transfer function error */
    
    double      mean  = 0.0;
    double      stdev = 0.0;
    
    char        *p_filename  = NULL;
    char        *p_filetag   = NULL;
    char        *keyExtname  = NULL;
    char        *qcname1     = NULL;
    char        *qcname2     = NULL;
    char        *pszChipName = NULL;
    
    mat_oifits   *oifits        = NULL;
    mat_oifits  **oifitscal     = NULL;
    mat_array    *oiarray       = NULL;
    mat_array    *oiarray_tempo = NULL;

    mat_oiwavelength    *oiwave       = NULL;
    mat_oiwavelength    *oiwave_tempo = NULL;

    cpl_frameset_iterator       *it       = NULL;
    cpl_errorstate               prestate = cpl_errorstate_get();

    double      valIm       = 0., valRe = 0.;
    double      phasorIm    = 0.;
    double      phasorRe    = 0.;
    double      phasorTF_Im = 0.;
    double      phasorTF_Re = 0.;
    double      phi         = 0.;

    nbfile     = cpl_frameset_get_size( frameset);
    oifitscal  = cpl_calloc(nbfile-1,sizeof(mat_oifits));
    usedframes = cpl_frameset_new();
    qclist     = cpl_propertylist_new();
    
    //    cpl_msg_error(cpl_func, "Writing dumb stuff...");
            
    /*target files */
    /*to compare with calib files */
    prestate=cpl_errorstate_get();
    it= cpl_frameset_iterator_new(frameset);
    do {
        cur_frame = cpl_frameset_iterator_get(it);
        if (cur_frame != NULL)
        {
            cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
            p_filename = (char *)cpl_frame_get_filename(cur_frame);
            p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
            if (!strcmp(p_filetag,"TARGET_RAW_INT"))
            {
                nb_extent = cpl_frame_get_nextensions(cur_frame);
                for(i = 0; i<nb_extent; i++)
                {
                    p_list = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
                    keyExtname = 
                        (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
                    /*oi_array dphiInterpTF*/
                    if (!strcmp(keyExtname,"OI_ARRAY")) 
                    {                   
                        table=cpl_table_load(p_filename,i+1,0);
                        oiarray = mat_array_from_table(p_list,table);
                        cpl_table_delete(table);
                    }
                    if (!strcmp(keyExtname,"OI_WAVELENGTH") ) 
                    {                     
                        oiwave=mat_oiwavelength_load(cur_frame);
                    }
                    cpl_propertylist_delete(p_list);
                }
                break;
            }
        }
    } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
    cpl_frameset_iterator_delete(it);
    if (!cpl_errorstate_is_equal(prestate))
    {
        cpl_errorstate_set(prestate);
    }

    
    /* calibrator files */
    prestate=cpl_errorstate_get();
    it= cpl_frameset_iterator_new(frameset);
    do {
        cur_frame = cpl_frameset_iterator_get(it);
        if (cur_frame != NULL)
        {
            
            /* Get Classification Tag */
            p_filename = (char *)cpl_frame_get_filename(cur_frame);
            p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
            
            nb_extent = cpl_frame_get_nextensions(cur_frame);
            for(i = 0; i<nb_extent; i++)
            {
                p_list = cpl_propertylist_load(
                                               cpl_frame_get_filename(cur_frame),i+1);
                keyExtname = 
                    (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
                if (!strcmp(keyExtname,"OI_ARRAY")) 
                {
                    table=cpl_table_load(p_filename,i+1,0);
                    p_list_array = cpl_propertylist_duplicate(p_list);
                    if (!strcmp(p_filetag,"CALIB_RAW_INT"))
                    {
                        oiarray_tempo = mat_array_from_table(p_list_array,table);                       
                    }               
                }
                if (!strcmp(keyExtname,"TF2") && flag ==0) 
                {
                    p_list_oitransfunc = cpl_propertylist_load(
                                                               cpl_frame_get_filename(cur_frame),i+1);
                    flag = 1;
                }
                if (!strcmp(keyExtname,"OI_WAVELENGTH") ) 
                {
                    if (!strcmp(p_filetag,"CALIB_RAW_INT"))
                        oiwave_tempo=mat_oiwavelength_load(cur_frame);
                }
                cpl_propertylist_delete(p_list);
            }
            if (!strcmp(p_filetag,"TARGET_RAW_INT"))
            {
                frame = cpl_frame_duplicate(cur_frame);
                cpl_frame_set_group(frame,CPL_FRAME_GROUP_RAW);
                cpl_frameset_insert(usedframes, frame);
                oifits = mat_oifits_load(cur_frame);
                if (oifits->oivis == NULL)
                {
                    cpl_msg_warning(cpl_func,"%s does not contain OIVIS binary table",p_filename);
                    mat_oifits_delete(oifits);
                    cpl_frameset_delete(usedframes);
                    cpl_propertylist_delete(qclist);
                    cpl_propertylist_delete(p_list_oitransfunc);
                    cpl_propertylist_delete(p_list_array);
                    for(i=0;i<=j;i++)
                    {
                        if (oifitscal[j] != NULL)
                        {
                            mat_oifits_delete(oifitscal[j]);
                        }
                    }
                    cpl_free(oifitscal);
                    mat_oiwavelength_delete(oiwave);
                    mat_array_delete(oiarray);
                    mat_oiwavelength_delete(oiwave_tempo);
                    mat_array_delete(oiarray_tempo);
                    cpl_table_delete(table);
                    return CPL_ERROR_INCOMPATIBLE_INPUT;
                }

            }
            if (!strcmp(p_filetag,"CALIB_RAW_INT"))
            {
                if (mat_array_compare(oiarray, oiarray_tempo) == CPL_TRUE &&
                    mat_oiwavelength_compare(oiwave, oiwave_tempo) == CPL_TRUE)
                {
                    frame = cpl_frame_duplicate(cur_frame);
                    cpl_frame_set_group(frame,CPL_FRAME_GROUP_RAW);
                    cpl_frameset_insert(usedframes, frame);
                    oifitscal[j] = mat_oifits_load(cur_frame);
                    if (oifitscal[j]->oivis == NULL  || oifitscal[j]->oitf2 == NULL)
                    {
                        cpl_msg_warning(cpl_func,"%s does not contain OIVIS binary table",p_filename);
                        mat_oifits_delete(oifits);
                        cpl_frameset_delete(usedframes);
                        cpl_propertylist_delete(qclist);
                        cpl_propertylist_delete(p_list_oitransfunc);
                        cpl_propertylist_delete(p_list_array);
                        for(i=0;i<=j;i++)
                        {
                            if (oifitscal[j] != NULL)
                            {
                                mat_oifits_delete(oifitscal[j]);
                            }
                        }
                        cpl_free(oifitscal);
                        mat_oiwavelength_delete(oiwave);
                        mat_array_delete(oiarray);
                        mat_oiwavelength_delete(oiwave_tempo);
                        mat_array_delete(oiarray_tempo);
                        cpl_table_delete(table);
                        return CPL_ERROR_INCOMPATIBLE_INPUT;
                    }
                    j = j+1;
                }
            }
            cpl_propertylist_delete(p_list_array);      
            cpl_table_delete(table);
            if (!strcmp(p_filetag,"CALIB_RAW_INT"))
            {
                mat_array_delete(oiarray_tempo);
                mat_oiwavelength_delete(oiwave_tempo);   
            } 
        }
    } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
    cpl_frameset_iterator_delete(it);
    if (!cpl_errorstate_is_equal(prestate))
    {
        cpl_errorstate_set(prestate);
    }

    
    mat_array_delete(oiarray);
    mat_oiwavelength_delete(oiwave);    

    nbOifitscal = j;
    nbExp=cpl_calloc(nbOifitscal,sizeof(int));
    nbExpTotal=0;
    nbTel=mat_get_nbtel_from_oivis(oifitscal[0]->oivis);
    nbBase=nbTel*(nbTel-1)/2;

    for(j=0; j<nbOifitscal; j++ )
    {
        nbVis = oifitscal[j]->oivis->nbvis;
        nbExp[j]=(int)(nbVis/nbBase);
        nbExpTotal+=nbExp[j];
    }

    if (oifits == NULL)
    {
        cpl_free(nbExp);
        return CPL_ERROR_INCOMPATIBLE_INPUT;
    }
    nbWlen = oifits->oivis->nbchannel;
    dphiTF          = cpl_calloc(nbWlen, sizeof(double));
    dphiInterpTF    = cpl_calloc(nbWlen, sizeof(double));
    dphiTFerr       = cpl_calloc(nbWlen, sizeof(double));
    dphiInterpTFvar = cpl_calloc(nbWlen, sizeof(double));
    dvisTF          = cpl_calloc(nbWlen, sizeof(double));
    dvisInterpTF    = cpl_calloc(nbWlen, sizeof(double));
    dvisTFerr       = cpl_calloc(nbWlen, sizeof(double));
    dvisInterpTFvar = cpl_calloc(nbWlen, sizeof(double));

    for (l=0; l < nbWlen; l++ )
    {
        dphiTF[l]    = cpl_calloc(nbExpTotal, sizeof(double));
        dphiTFerr[l] = cpl_calloc(nbExpTotal, sizeof(double));
        dphiInterpTF[l]    = 0.0;
        dphiInterpTFvar[l] = 0.0;
        
        dvisTF[l]    = cpl_calloc(nbExpTotal, sizeof(double));
        dvisTFerr[l] = cpl_calloc(nbExpTotal, sizeof(double));
        dvisInterpTF[l]    = 0.0;
        dvisInterpTFvar[l] = 0.0;
        
        for(j=0; j<nbExpTotal; j++ )
        {
            dphiTF[l][j]    = 0.0;
            dphiTFerr[l][j] = 0.0;
            dvisTF[l][j]    = 0.0;
            dvisTFerr[l][j] = 0.0;
        }
    }
    /*save dphiInterpTF*/
    /*"pour chaque ligne du fichier cible:*/
    /* read target file's line */
    nbVis = oifits->oivis->nbvis;
    for (i=0; i<nbVis; i++)
    {

        index1 = oifits->oivis->list_vis[i]->stationindex[0];
        index2 = oifits->oivis->list_vis[i]->stationindex[1];
        flag = 0;
       
        cpt=0;
        for(j=0; j<nbOifitscal; j++ )
        {
            for(m=0;m<nbExp[j];m++)
            {
                for (k= 0;k<nbBase;k++)
                {
                    /* We try to match the line in the calib file*/ 
                    if(oifitscal[j]->oivis->list_vis[k]->stationindex[0] == index1 && oifitscal[j]->oivis->list_vis[k]->stationindex[1] == index2)
                    {
                        for (l=0; l < nbWlen; l++ )
                        {      
                            dphiTF[l][cpt] = oifitscal[j]->oivis->
                                list_vis[k+m*nbBase]->visphi[l] * CPL_MATH_RAD_DEG;
                            dphiTFerr[l][cpt] = oifitscal[j]->oivis->
                                list_vis[k+m*nbBase]->visphierr[l] * CPL_MATH_RAD_DEG;
                            
			    if ( strstr(oifitscal[j]->oivis->amptyp,"differential") == NULL)
			      {
				dvisTF[l][cpt] = oifitscal[j]->oitf2->list_tf2[k+m*nbBase]->tf[l];
				dvisTFerr[l][cpt] = oifitscal[j]->oitf2->list_tf2[k+m*nbBase]->tferr[l];
			      }
			    else
			      {
				dvisTF[l][cpt] = 0.;
				dvisTFerr[l][cpt] = 0.;
			      }
                        }
                    }
                }
                cpt++;
            }
        }
        for (l=0; l < oifitscal[0]->oivis->nbchannel; l++ )
        {    
            /* mean */
            dphiInterpTF[l]    = 0.;
            dphiInterpTFvar[l] = 0.;
            
            dvisInterpTF[l]    = 0.;
            dvisInterpTFvar[l] = 0.;
            
            cpt=0;
	    valRe = 0;
	    valIm = 0;
            for(j=0; j<nbOifitscal; j++ )
            {
                for(m=0;m<nbExp[j];m++)
                {
                    /* Avoid phase wrapping by doing addition of
		       phasor in complex plane. */
                    phasorRe  = cos( dphiTF[l][cpt] );
                    phasorIm  = sin( dphiTF[l][cpt] );
                    /* Real part */
                    valRe += phasorRe;
                    /* Imaginary part */
                    valIm += phasorIm;
                                    
                    dvisInterpTF[l]    += dvisTF[l][cpt];
                    dphiInterpTFvar[l] += pow(dphiTFerr[l][cpt],2.0);
                    dvisInterpTFvar[l] += pow(dvisTFerr[l][cpt],2.0);
                    cpt++;
                }
            }
	    dphiInterpTF[l]     = atan2(valIm, valRe);
            dphiInterpTFvar[l] /= nbExpTotal;
            dvisInterpTF[l]    /= nbExpTotal;
            dvisInterpTFvar[l] /= nbExpTotal;

            /* Subtract transfer function's phase to object's phase.
            Avoid phase wrapping by doing subtraction in complex
            plane.  Buildup a phasor with amplitude of 1 out of the
            differential phase */
            phi = oifits->oivis->list_vis[i]->visphi[l] * CPL_MATH_RAD_DEG;
            phasorRe = cos(phi);
            phasorIm = sin(phi);
            /* calculate phasor from transfer function */
            phasorTF_Re = cos(dphiInterpTF[l]);
            phasorTF_Im = sin(dphiInterpTF[l]);

            /* Real part */
            valRe = phasorRe * phasorTF_Re + phasorIm * phasorTF_Im;
            /* Imaginary part */
            valIm = phasorTF_Re * phasorIm - phasorRe * phasorTF_Im;

            /* get back phase */
            oifits->oivis->list_vis[i]->visphi[l] = atan2(valIm, valRe) * CPL_MATH_DEG_RAD;

            /* errors computation */
            oifits->oivis->list_vis[i]->visphierr[l]  = sqrt(pow(oifits->oivis->list_vis[i]->visphierr[l] * CPL_MATH_RAD_DEG,2.0)+dphiInterpTFvar[l]) * CPL_MATH_DEG_RAD;

	    if (dvisInterpTF[l] != 0)
	      {
		oifits->oivis->list_vis[i]->visamperr[l]  = sqrt((pow(oifits->oivis->list_vis[i]->visamperr[l],2.0) * pow(dvisInterpTF[l], 2.0) + fabs(dvisInterpTFvar[l]) * pow(oifits->oivis->list_vis[i]->visamp[l], 2.0)) / pow(dvisInterpTF[l], 4.0));
		oifits->oivis->list_vis[i]->visamp[l]    /= dvisInterpTF[l];
	      }
            //      cpl_msg_warning(cpl_func, "Writing something...");
        } 
    }

    /*qcparameters*/
    if ( !strcmp((char *)cpl_propertylist_get_string(oifits->keywords, "INSTRUME"), "MATISSE"))
    {
        pszChipName=
            (char *)cpl_propertylist_get_string(oifits->keywords,
                                                "ESO DET CHIP NAME");
        if (pszChipName == NULL)
        {
            cpl_free(dphiTF);
            cpl_free(dphiTFerr);
            cpl_free(dphiInterpTF);
            cpl_free(dphiInterpTFvar);
            cpl_free(dvisTF);
            cpl_free(dvisTFerr);
            cpl_free(dvisInterpTF);
            cpl_free(dvisInterpTFvar);
            cpl_free(nbExp);
            cpl_msg_error(cpl_func,"No ESO DET CHIP NAME keyword");
            return 1;
        }
        if(strcmp(pszChipName, "AQUARIUS") == 0)
        {
            indexChipName=2;
        }
        else if(strcmp(pszChipName, "HAWAII2RG") == 0)
        {
            indexChipName=1;
        }
    }
    else
        indexChipName=3;
    for (i=0; i < nbVis; i++)
    {
        mean = 0.0;
        stdev = 0.0;
        qcname1=cpl_sprintf("ESO QC DET%d CALDPHASE%d ",indexChipName,i+1);
        qcname2=cpl_sprintf("ESO QC DET%d CALDPHASE%d STDEV ", indexChipName,i+1);
        for(j=0; j<nbWlen; j++ )
        {
            mean = mean +  oifits->oivis->list_vis[i]->visphi[j];
        }
        mean = mean/nbWlen;
        for (j=0; j<nbWlen; j++)
        {
            stdev =stdev + pow(oifits->oivis->list_vis[i]->visphi[j]-mean, 2.0);
        }
        stdev = sqrt(stdev/nbWlen);

        cpl_propertylist_append_double(qclist, qcname1, mean);
        cpl_propertylist_append_double(qclist, qcname2, stdev);
        cpl_free(qcname1);
        cpl_free(qcname2);
    }
    cpl_propertylist_append(oifits->keywords, qclist);

    /*free memory*/
    for(j=0; j< nbWlen; j++ )
    {
        cpl_free(dphiTF[j]);
        cpl_free(dphiTFerr[j]);
        cpl_free(dvisTF[j]);
        cpl_free(dvisTFerr[j]);
    }
    cpl_free(dphiTF); 
    cpl_free(dphiTFerr); 
    cpl_free(dphiInterpTF);  
    cpl_free(dphiInterpTFvar);
    cpl_free(dvisTF); 
    cpl_free(dvisTFerr); 
    cpl_free(dvisInterpTF);  
    cpl_free(dvisInterpTFvar);  


    /* save */
    oifits->oit3    = NULL;
    oifits->oispect = NULL;
    oifits->oivis2  = NULL;
    
    it= cpl_frameset_iterator_new(frameset);
    cur_frame = cpl_frameset_iterator_get(it);
    cpl_frameset_iterator_delete(it);
    filename=cpl_sprintf("CALDPHASE_%s",basename((char *)cpl_frame_get_filename(cur_frame)));
    mat_oifits_save(oifits, frameset, usedframes, parlist,recname, filename, 8);


    mat_oifits_delete(oifits);
    cpl_frameset_delete(usedframes);
    cpl_propertylist_delete(p_list_oitransfunc);
    cpl_propertylist_delete(qclist);
    for(i=0; i<nbfile-1; i++)
    {
        mat_oifits_delete(oifitscal[i]);
    }    
    cpl_free(oifitscal);
    cpl_free(nbExp);
    cpl_free(filename);
    return 0;
}



