/* $Id: mat_drl.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_drl.h $
 */

#ifndef MAT_DRL_H
#define MAT_DRL_H


/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/
#include <complex.h>
#include "cpl.h"
#include <complex.h>

#include "mat_const.h"
#include "mat_region.h"
#include "mat_imagingdetector.h"
#include "mat_imgreg.h"
#include "mat_frame.h"
#include "mat_imagingdata.h"
#include "mat_imgcorr.h"
#include "mat_array.h"
#include "mat_gendata.h"
#include "mat_oivis.h"
#include "mat_oivis2.h"
#include "mat_oit3.h"
#include "mat_oitarget.h"
#include "mat_oiwavelength.h"
#include "mat_oispectrum.h"
#include "mat_oifits.h"

/*-----------------------------------------------------------------------------
  Defines
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Low Level Structures
  ----------------------------------------------------------------------------*/

/* Structure mat_refpix */
/**
   @ingroup refpix
   @brief Structure containing the coordinates of the reference pixels 
   of each beam of MATISSE.
*/
typedef struct {
    int       numbeam;                     /* beam index                      */
    int       numdetector;                 /* detector number                 */
    char      bcdstatus[4];                /* BCD status (IN/OUT)             */
    double    refpix[2];                   /* reference pixel coordinates     */
} mat_refpix;


/*-----------------------------------------------------------------------------
  High Level Structures
  ----------------------------------------------------------------------------*/



/* Structure mat_imrefpix */
/**
   @defgroup refpix Reference Pixel
*/
/**
   @ingroup refpix
   @brief Structure containing the reference pixels.
*/
typedef struct {
    cpl_propertylist      *keywords;             /* primary header            */
    int                    nbbeam;               /* number of beam            */
    mat_refpix           **list_refpix;          /* array struct of ref pixel */
} mat_imrefpix;


/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/

#endif
