/* $Id: mat_shift.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_eop.h $
 */

#ifndef MAT_EOP_H
#define MAT_EOP_H

#ifndef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 200809L
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <float.h>
#include <assert.h>
#include <gsl/gsl_vector.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <erfa.h>
#include "mat_drl.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
#define mat_table_get_value(table,name,row,value) cpl_array_get (cpl_table_get_array (table,name,row), value, NULL)

/*-----------------------------------------------------------------------------
  Data Structures
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
cpl_error_code mat_eop_uv_oivis(mat_oivis * oivis,
				mat_array * oiarray,
				cpl_propertylist * hdr_data,
				cpl_table * eop_table);
cpl_error_code mat_eop_uv_oivis2(mat_oivis2 * oivis2,
				 mat_array * oiarray,
				 cpl_propertylist * hdr_data,
				 cpl_table * eop_table);
cpl_error_code mat_eop_uv_oit3(mat_oit3 * oit3,
			       mat_array * oiarray,
			       cpl_propertylist * hdr_data,
			       cpl_table * eop_table);
   

#endif
