/* $Id: mat_est_tf_lib.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_est_tf_lib.c $
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/

#include "mat_est_tf_lib.h"

/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/





/*----------------------------------------------------------------------------*/
/**
   @brief This function is called by the mat_est_tf recipe
   @param parlist : contains the parameters supported by
   the recipe
   @param frameset : the list of frames that have been given to
   the recipe for processing
   @param recname : Name of the recipes calling this function
   @return 0 if everything is ok
*/
/*----------------------------------------------------------------------------*/

int mat_est_tf_lib(cpl_parameterlist *parlist, cpl_frameset *frameset,
		   const char *recname) {
    
  cpl_propertylist *p_list = NULL;
  cpl_propertylist *plist1 = NULL;
  cpl_propertylist *p_list_0 = NULL;
  cpl_propertylist *p_list_array = NULL;
  cpl_propertylist *p_list_transfunc = NULL;
  cpl_table *table = NULL;
  cpl_table *table_aux = NULL;
  cpl_frameset *usedframes = NULL;
  cpl_frame  *cur_frame = NULL;
  cpl_frame  *cur_frame1 = NULL;
  cpl_frame *sel_frame = NULL;
  cpl_errorstate prestate = cpl_errorstate_get();
  cpl_errorstate prestate_ite = cpl_errorstate_get();
  cpl_errorstate prestate_first = cpl_errorstate_get();
  mat_oifits *oifits = NULL;
  mat_oifits *tf2 = NULL;
  char *p_filename = NULL;
  char *p_filetag = NULL;
  char *pszFileName1=NULL;
  char *pszFileTag1=NULL;
  char *keyExtname = NULL;
  const char *name =  NULL;
  const char *chipName = NULL;
  int science;
  const char *sos = NULL;
  const char *instrume = NULL;
  /* char filename[200]; */
  char *filename=NULL;
  /* char output[200]; */
  char *output=NULL;
  int  i = 0;
  int nb_extent = 0;
  double diameter = 0.0;
  double diameterErr = 0.0;
  double ra, dec;
  int flag_cat = 0;
  int flagCal = 1;
  double *diam = NULL;//UDDN, UDDK, LDD, E_LDD
  cpl_frameset_iterator *it=NULL;
  cpl_frameset_iterator *it1=NULL;
  int indexFile=1;
  char diameterName[100];
  double mag[3];
  cpl_frame *frame_vis=NULL;
  int expno=0;
  mat_oifits *oifits_vis=NULL;
  cpl_frameset *frames= NULL;
  cpl_propertylist *plist=NULL;
  
  cur_frame= cpl_frameset_find(frameset,"JSDC_CAT");
  if (cur_frame != NULL) {
    p_filename = (char *)cpl_frame_get_filename(cur_frame);
    /* sprintf(filename,"%s",p_filename); */
    filename=cpl_sprintf("%s",p_filename);
    flag_cat=1;
  }
  
  /* RETRIEVE INPUT PARAMETERS */
  //   cpl_parameterlist_dump(parlist, NULL);
  /* param = cpl_parameterlist_find(parlist, "matisse.mat_est_tf.diamStar"); */
  /* diameter=cpl_parameter_get_double(param); */
  /* param = cpl_parameterlist_find(parlist, "matisse.mat_est_tf.diamErr"); */
  /* diameterErr = cpl_parameter_get_double(param); */
  /* param = cpl_parameterlist_find(parlist, "matisse.mat_est_tf.catalog"); */
  /* flag = cpl_parameter_get_int(param); */

  frames=cpl_frameset_duplicate(frameset);
  prestate_first=cpl_errorstate_get();
  /* 1. Check the data type of the input frames.  */
  /*Retrieve frames files */
  prestate_ite=cpl_errorstate_get();
  it= cpl_frameset_iterator_new(frameset);
  do {
    cur_frame = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL) {
      //Get Classification Tag
      //cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
      p_filename = (char *)cpl_frame_get_filename(cur_frame);
      p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
      if (strcmp(p_filetag,"RAW_VIS2") == 0) {
	p_list_0 = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
	expno=cpl_propertylist_get_int(p_list_0,"ESO TPL EXPNO");

	/* Find corresponding RAW_DPHASE */
	frame_vis=cpl_frameset_find(frames,"RAW_DPHASE");
	oifits_vis = NULL;
	while (frame_vis != NULL)
	  {
	    plist = cpl_propertylist_load(cpl_frame_get_filename(frame_vis),0);
	    if ( expno == cpl_propertylist_get_int(plist,"ESO TPL EXPNO") )
	      {
		cpl_msg_info(cpl_func,"Corresponding RAW_DPHASE found for %s :  %s",
			     p_filename,cpl_frame_get_filename(frame_vis));
		oifits_vis=mat_oifits_load(frame_vis);
	      }
	    cpl_propertylist_delete(plist);
	    frame_vis=cpl_frameset_find(frames,NULL);
	  }
	if (oifits_vis == NULL)
	  {
	    cpl_msg_warning(cpl_func,"No corresponding RAW_DPHASE found for %s",p_filename);
	  }
	
	// Check if calibrator
	// In AMBER data, no ESO PRO SCIENCE Keyword
	// Test on the INSTRUME keyword in this case
	prestate=cpl_errorstate_get();
	instrume=cpl_propertylist_get_string(p_list_0,"INSTRUME");
		
	if ( cpl_propertylist_has(p_list_0,"ESO PRO SCIENCE") ) {
	  science=cpl_propertylist_get_bool(p_list_0,"ESO PRO SCIENCE");
	  sos=cpl_propertylist_get_string(p_list_0,"ESO INS SOS1 ID");
	  if ( science == 0 && strcmp(sos,"OUT")==0 ) {
	    flagCal=1;
	  } else {
	    flagCal=0;
	  }
	} else {
	  if (instrume != NULL) {
	    if (strcmp(instrume,"AMBER") == 0) {
	      flagCal=1;
	    } else {
	      flagCal=0;
	    }
	  } else {
	    flagCal=0;
	  }
	}
	if (!cpl_errorstate_is_equal(prestate)) {
	  cpl_errorstate_set(prestate);
	}
	// if calibrator
	int flagJSDC=0;
	if (flagCal == 1 )
	  {
	    diam = cpl_malloc(5*sizeof(double));

	    if (flag_cat == 0) {
	      cpl_msg_error(cpl_func,"JSDC catalog required but not found");
	      cpl_frameset_delete(usedframes);
	      cpl_free(diam);
	      return 1;
	    }
	    chipName = cpl_propertylist_get_string(p_list_0,"ESO DET CHIP NAME");
	    ra = cpl_propertylist_get_double(p_list_0,"RA");
	    dec = cpl_propertylist_get_double(p_list_0,"DEC");
	    flagJSDC=mat_get_diameter(filename, ra, dec,diam,diameterName,mag);
	  }
		    
	  
	if ( flagCal == 1) {
	  if (flagJSDC == 0)
	    {
	      nb_extent = cpl_frame_get_nextensions(cur_frame);
	      /*Load frame in a oifits structure*/
	      for(i = 0; i<nb_extent; i++){
		p_list = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
		keyExtname = (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
		/*oi_vis2 header*/
		if (keyExtname != NULL) {
		  if (!strcmp(keyExtname,"OI_VIS2")) {
		    p_list_transfunc = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
		    name = cpl_propertylist_get_string(p_list_transfunc, "INSNAME");
		  }
		  /*oi_array data*/
		  if (!strcmp(keyExtname,"OI_ARRAY")) {
		    table=cpl_table_load(p_filename,i+1,0);
		    p_list_array = cpl_propertylist_duplicate(p_list);
		  }
		}
		cpl_propertylist_delete(p_list);
	      }
	      oifits = mat_oifits_load(cur_frame);
	      cpl_propertylist_delete(p_list_array);
	      cpl_table_delete(table);
	      /* 3. Estimate the transfer function and its error bar */
	      if (!strcmp(name,"AMBER"))
		{
		  diameter = diam[0];// k band
		}
	      else if (!strcmp(name,"MATISSE"))
		{
		  if (!strcmp(chipName,"AQUARIUS"))
		    {
		      diameter = diam[3];// N band
		    }
		  else
		    {
		      diameter = diam[1]; //L band
		    }
		}
	      diameterErr = diam[4];
		      
	      cpl_propertylist_delete(p_list_0);
	      tf2 = mat_compute_tf2(oifits, oifits_vis, diameter, diameterErr, diameterName, mag[0], mag[1], mag[2]);

	      for(i = 0; i<nb_extent; i++) {
		p_list = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
		keyExtname = (char *)cpl_propertylist_get_string(p_list,"EXTNAME");
		if (keyExtname != NULL) {
		  table_aux = cpl_table_load(cpl_frame_get_filename(cur_frame), i+1, 0);		
		  if (!strcmp(keyExtname,"OI_ARRAY")) {
		    tf2->array=mat_array_from_table(p_list,table_aux);
		  }
		  if ( !strcmp(keyExtname,"OI_WAVELENGTH") ) {
		    tf2->oiwave=mat_oiwavelength_load(cur_frame);
		  }
		  cpl_table_delete(table_aux);
		}
		cpl_propertylist_delete(p_list);
	      }



	      /* 4. Save the structure in a FITS file   */
	      /* output=cpl_sprintf("TF_%s",basename((char *) cpl_frame_get_filename(cur_frame))); */
	      if (cpl_frameset_find(frameset,"CALIB_RAW") != NULL ||
		  cpl_frameset_find(frameset,"TARGET_RAW") != NULL ||
		  cpl_frameset_find(frameset,"CALIB_SRC_RAW") != NULL)
		{
		  usedframes=cpl_frameset_new();
		  it1= cpl_frameset_iterator_new(frameset);
		  do
		    {
		      cur_frame1 = cpl_frameset_iterator_get(it1);
		      if (cur_frame1 != NULL)
			{
			  pszFileName1 = (char*)cpl_frame_get_filename( cur_frame1 );
			  pszFileTag1 = (char *)cpl_frame_get_tag( cur_frame1 );
			  if (strcmp(pszFileTag1, "CALIB_RAW") == 0 || strcmp(pszFileTag1, "TARGET_RAW") == 0 || strcmp(pszFileTag1, "CALIB_SRC_RAW") == 0)
			    {
			      plist1=cpl_propertylist_load(pszFileName1,0);
			      if (strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"OUT") == 0 &&
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"OUT") == 0 &&
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO") )
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"IN") == 0 &&
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"OUT") == 0 &&
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"OUT") == 0 &&
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"IN") == 0 &&
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"IN") == 0 &&
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"IN") == 0 &&
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") == cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      cpl_propertylist_delete(plist1);
			    }
			}
		    } while (cpl_frameset_iterator_advance(it1, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		  cpl_frameset_iterator_delete(it1);
		  it1= cpl_frameset_iterator_new(frameset);
		  do
		    {
		      cur_frame1 = cpl_frameset_iterator_get(it1);
		      if (cur_frame1 != NULL)
			{
			  pszFileName1 = (char*)cpl_frame_get_filename( cur_frame1 );
			  pszFileTag1 = (char *)cpl_frame_get_tag( cur_frame1 );
			  if (strcmp(pszFileTag1, "CALIB_RAW") == 0 || strcmp(pszFileTag1, "TARGET_RAW") == 0 || strcmp(pszFileTag1, "CALIB_SRC_RAW") == 0)
			    {
			      plist1=cpl_propertylist_load(pszFileName1,0);
			      if (strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"OUT-OUT") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"OUT") != 0 ||
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"OUT") != 0 ||
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"IN-OUT") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"IN") != 0 ||
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"OUT") != 0 ||
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"OUT-IN") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"OUT") != 0 ||
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"IN") != 0 ||
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      else if(strcmp(cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"),"IN-IN") == 0)
				{
				  if (strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD1 NAME"),"IN") != 0 ||
				      strcmp(cpl_propertylist_get_string(plist1,"ESO INS BCD2 NAME"),"IN") != 0 ||
				      cpl_propertylist_get_int(plist1,"ESO TPL EXPNO") != cpl_propertylist_get_int(oifits_vis->keywords,"ESO TPL EXPNO"))
				    {
				      sel_frame=cpl_frame_duplicate(cur_frame1);
				      cpl_frameset_insert(usedframes,sel_frame);
				    }
				}
			      cpl_propertylist_delete(plist1);
			    }
			  else if (strcmp(pszFileTag1, "BADPIX") == 0 || strcmp(pszFileTag1, "NONLINEARITY") == 0 ||
				   strcmp(pszFileTag1, "SHIFT_MAP") == 0 || strcmp(pszFileTag1, "KAPPA_MATRIX") == 0 ||
				   strcmp(pszFileTag1, "OBS_FLATFIELD") == 0 || strcmp(pszFileTag1, "JSDC_CAT") == 0)
			    {
			      sel_frame=cpl_frame_duplicate(cur_frame1);
			      cpl_frameset_insert(usedframes,sel_frame);
			    }
		       
			}
		    } while (cpl_frameset_iterator_advance(it1, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		  cpl_frameset_iterator_delete(it1);
		}
	      else
		{
		  usedframes=cpl_frameset_new();
		  sel_frame = cpl_frame_duplicate(cur_frame);
		  cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
		  cpl_frameset_insert(usedframes,sel_frame);
		}

	      cpl_propertylist_append_string(tf2->keywords,"ESO CFG BCD MODE",
					     (char *) cpl_propertylist_get_string(oifits_vis->keywords,"ESO CFG BCD MODE"));
	      
	      mat_oifits_delete(oifits_vis);
	      mat_oifits_delete(oifits);
	      output=cpl_sprintf("RAW_TF2_%04d.fits",indexFile);
	      mat_oifits_save(tf2, frameset,usedframes,parlist,recname,output,10);
	      indexFile++;
	      //cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_PRODUCT);
	      cpl_propertylist_delete(p_list_transfunc);
	      mat_oifits_delete(tf2);
	      cpl_frameset_delete(usedframes);
	      cpl_free(diam);
	      cpl_free(output);
	    }
	  else
	    {
	      cpl_msg_warning(cpl_func,"Calibrator not found in JSDC catalog");
	      cpl_frameset_delete(usedframes);
	      cpl_propertylist_delete(p_list_0);
	      cpl_free(diam);
	      //return -1;
	    }
	} else {
	  cpl_frameset_delete(usedframes);
	  cpl_propertylist_delete(p_list_0);
	  cpl_msg_info(cpl_func,"file %s does not correspond to a calibrator",p_filename);
	}
      }
    }
  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);
  if (!cpl_errorstate_is_equal(prestate_ite)) {
    cpl_errorstate_set(prestate_ite);
  }



  it= cpl_frameset_iterator_new(frameset);
  do {
    cur_frame = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL) {
      p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
      if ( strcmp(p_filetag,"RAW_TF2") == 0 ) {
	cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_PRODUCT);
      }
    }
  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);

  if (!cpl_errorstate_is_equal(prestate_first)) {
    cpl_errorstate_set(prestate_first);
  }

  cpl_free(filename);
  cpl_frameset_delete(frames);
    
  return 0;
}
  
