/* $Id: mat_fit_gauss.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_fit_gauss.h $
 */

#ifndef MAT_FIT_GAUSS_H
#define MAT_FIT_GAUSS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_blas.h>
#include <gsl/gsl_multifit_nlin.h>
#include <gsl/gsl_version.h>
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Structures
------------------------------------------------------------------------------*/

struct data {
  size_t n;
  double * y;
  double * sigma;
};
struct data_red {
  size_t n;
  double * y;
  double cen;
  double wid;
};

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
double mat_fit_gauss(int nrow,
                         gsl_vector *vector,
		     double *params, double *pos_err);

int expb_f(const gsl_vector * x, void *data, 
          gsl_vector * f);

int expb_df(const gsl_vector * x, void *data, 
           gsl_matrix * J);

int expb_fdf(const gsl_vector * x, void *data,
            gsl_vector * f, gsl_matrix * J);

int mat_fit_gauss_linear(int nrow,
                         gsl_vector *vector,
			 double *params);

int expb_f_linear(const gsl_vector * x, void *data, 
          gsl_vector * f);

int expb_df_linear(const gsl_vector * x, void *data, 
           gsl_matrix * J);

int expb_fdf_linear(const gsl_vector * x, void *data,
            gsl_vector * f, gsl_matrix * J);
int mat_fit_gauss_linear_red(int nrow,
                         gsl_vector *vector,
			     double *params, double cen0, double wid0);

int expb_f_linear_red(const gsl_vector * x, void *data, 
          gsl_vector * f);

int expb_df_linear_red(const gsl_vector * x, void *data, gsl_matrix * J);

int expb_fdf_linear_red(const gsl_vector * x, void *data,
            gsl_vector * f, gsl_matrix * J);

#endif
