/* $Id: mat_frame.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_frame.h $
 */

#ifndef MAT_FRAME_H
#define MAT_FRAME_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

#include "mat_const.h"
#include "mat_imagingdetector.h"
#include "mat_imgreg.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @brief This data structure contains all information for a raw data frame.

   Each raw data frame contains all information given in one row of a IMAGING_DATA binary table.
   Each sub-window data is stored in a mat_imgreg data structire.
 */
typedef struct {
    double        time;                  /*!< The central time on an exposure. */
    float         exptime;               /*!< The DIT of that frame (equal for all frames of an exposure). */
    double        opd[MAT_MAXTEL];       /*!< Vector containing the opd of the telescope delay lines. */
    double        localopd[MAT_MAXTEL];  /*!< Vector containing the internal opd of the instrument. */
    int           stepphase;             /*!< The step number of the local opd modulator. */
    char          tartype[2];            /*!< The type of the target. */
    int           nbsubwin;              /*!< The number of sub-windows, equal for all frames of an exposure. */
    mat_imgreg  **list_subwin;           /*!< The sub-window related data as vector of pointers. */
} mat_frame;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_frame *mat_frame_new(const mat_imagingdetector *imgdet, cpl_type type);
mat_frame *mat_frame_duplicate(const mat_frame * frame, cpl_type type);
cpl_error_code mat_frame_delete(mat_frame *frame);
cpl_error_code mat_frame_fill(mat_frame *frame,
			      double value);
cpl_error_code mat_frame_multiply(mat_frame *frame,
				  double value);
double mat_frame_get(const mat_frame *frame,
		     int r,
		     int x,
		     int y);
cpl_error_code mat_frame_set(mat_frame *frame,
			     int r,
			     int x,
			     int y,
			     double value);
/* cpl_error_code mat_frame_filter_mask(mat_frame *dst, */
/* 				     const mat_frame *src, */
/* 				     const cpl_mask *kernel, */
/* 				     cpl_filter_mode filter, */
/* 				     cpl_border_mode border); */
cpl_error_code mat_frame_subtract(mat_frame *f1,
				  mat_frame *f2);

cpl_error_code mat_frame_check_layout(const mat_frame *frame, const mat_imagingdetector *imgdet);


#endif
