/* $Id: mat_imagingdata.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imagingdata.h $
 */

#ifndef MAT_IMAGINGDATA_H
#define MAT_IMAGINGDATA_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <stdio.h>
#include "mat_const.h"
#include "mat_frame.h"
#include "mat_imagingdetector.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/* Structure mat_imagingdata */
/**
   @ingroup imgdata
   @brief Structure containing the IMAGING_DATA binary table of a raw data
   file.
*/
typedef struct {
  //char         *origin;                        /* origin of the data        */
    char         *instrument;                    /* instrument name           */
    double        dateobsmjd;                    /* observation date (MJD)    */
    char         *dateobs;                       /* observation date          */
  //char         *date;                          /* HDU creation date         */
    char         *dcsdictionaryid;               /* data dic name             */
    char         *dcsid;                         /* DCS software version strin*/
    int           nbtel;                         /* number of telescopes      */
    int           staindex[MAT_MAXTEL];          /* list of station used      */
    int           armindex[MAT_MAXTEL];          /* list of VLTI arms         */
    int           maxstep;                       /* max number of step        */
    int           maxins;                        /* max opti train elements   */
    int           nbframe;                       /* number of frames          */
    mat_frame   **list_frame;                    /* array of frames           */
} mat_imagingdata;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_imagingdata *mat_imagingdata_new(const mat_imagingdetector *imgdet, int nbframe, cpl_type type);

cpl_error_code mat_imagingdata_delete(mat_imagingdata *imgData);

mat_imagingdata * mat_imagingdata_duplicate(const mat_imagingdata * imgdata, cpl_type type);

mat_imagingdata * mat_imagingdata_load(cpl_propertylist *plist,
                                       cpl_table *table,
                                       mat_imagingdetector *imgdet,
                                       int *staindex,
                                       int *armindex,
				       cpl_type type);
mat_imagingdata * mat_imagingdata_load_skip(cpl_propertylist *plist,
					    cpl_table *table,
					    mat_imagingdetector *imgdet,
					    int *staindex,
					    int *armindex,
					    int nditskip,
					    cpl_type type);

mat_imagingdata * mat_imagingdata_sum(const mat_imagingdata *imgdata, cpl_type type);

#endif
