/* $Id: mat_imextended.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imextended.h $
 */

#ifndef MAT_IMEXTENDED_H
#define MAT_IMEXTENDED_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <stdio.h>
#include <cpl.h>
#include "mat_detector.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/**
   @ingroup ime
   @brief Structure containing the extended detector monitoring information for a detector.

   This structure represents all contents in a IM_EXTENDED FITS file. This includes
   the primary header keywords (keywords member), the detector gain and readout noise,
   the detector channel specific gain, offset and readout noise, the horizintal and
   vertival pixel correlation and the minimum of the Allan variance.
 */
typedef struct {
  mat_detector         *det;                   /*!< The detector specification for this extended detector monitoring map. */
  cpl_propertylist     *keywords;              /*!< The keywords from the primary header. */
  double                detectorgain;          /*!< The detector specific gain in electrons per DU. This value will be stored as a QC1 parameter (QC DETi GAIN). */
  double                detectornoise;         /*!< The detector specific readout noise in electrons (QC1 parameter QC DETi RON). */
  cpl_vector           *channelgain;           /*!< The detector channel specific gain in electrons per ADU (QC1 parameter QC DETi CHANNELj GAIN). */
  cpl_vector           *channeloffset;         /*!< The detector channel specific offset in ADU (QC1 parameter QC DETi CHANNELj OFFSET). */
  cpl_vector           *channelnoise;          /*!< The detector channel specific readout noise in electrons (QC1 parameter QC DETi CHANNELj NOISE). */
  double                horizontalcorrelation; /*!< The autocorrelation coefficient between two horizontally adjacent pixels. This value will be stored as a QC1 parameter (QC DETi HACORR). */
  double                verticalcorrelation;   /*!< The autocorrelation coefficient between two vertically adjacent pixels. This value will be stored as a QC1 parameter (QC DETi VACORR). */
  double                allanvariancemin;      /*!< Position of the minimum of the Allan variance as a measure of the time stability of the detector system. This value will be stored as a QC1 parameter (QC DETi AVAR MIN). */
} mat_imextended;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/ 
mat_imextended *mat_imextended_new(mat_detector *det);

cpl_error_code mat_imextended_delete(mat_imextended *ime);

cpl_error_code mat_imextended_save(mat_imextended *ime,
				   const char *fname,
				   const char *rname,
				   cpl_parameterlist *parlist,
				   cpl_frameset *frameset);

#endif
