/* $Id: mat_imgcorr.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_imgcorr.h $
 */

#ifndef MAT_IMGCORR_H
#define MAT_IMGCORR_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
/* Structure mat_imgcorr */
typedef struct {
    int           numregion;               /* region number                   */
    int           numdetector;             /* detector number                 */
    int           nbimgreg;                /* number of sub-image             */
    double        time;                          /* time tag                  */
    float         exptime;                       /* exposure time             */
    cpl_image    **imgreg;                 /* array of images                 */
} mat_imgcorr;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_imgcorr *mat_imgcorr_duplicate(const mat_imgcorr *imgreg);

#endif
