/* $Id: mat_kappamatrix.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_kappamatrix.h $
 */

#ifndef MAT_KAPPAMATRIX_H
#define MAT_KAPPAMATRIX_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <assert.h>
#include <gsl/gsl_vector.h>
#include "mat_drl.h"
#include "mat_fit_gauss.h"
#include "mat_utils.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Data Structures
  ----------------------------------------------------------------------------*/

/* Structure mat_kappacoef */
/**
   @ingroup kappa
   @brief Structure containing the coefficients of the Kappa Matrix
*/
typedef struct {
    int           numdetector;             /* detector number                 */
    int           numregion;               /* region number                   */
    int           nbchannel;               /* spectral channel number         */
    cpl_matrix    *coef;                   /* kappa matrix coef               */
    cpl_matrix    *errcoef;                /* error on kappa matrix coef      */
} mat_kappacoef;

/* Structure mat_kappamatrix */
/**
   @defgroup kappa Kappa Matrix
*/
/**
   @ingroup kappa
   @brief Structure containing the Kappa Matrix.

   This structure contains the intensity ratio, the relative shift and 
   zoom between each photometric channel and the interferometric one 
   for each spectral channel.
*/
typedef struct {
    cpl_propertylist      *keywords;             /* primary header            */
    mat_imagingdetector   *imgdet;               /* detector geometry         */
    int                    nbbeam;               /* number of beam            */
    mat_kappacoef        **list_kappacoef;       /* array of struc kappa coef */
} mat_kappamatrix;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

mat_kappamatrix * mat_kappamatrix_load(cpl_frame *frame);

cpl_error_code mat_kappamatrix_free(mat_kappamatrix *kappa);

cpl_error_code mat_kappamatrix_save(
				     mat_kappamatrix *kappa,
				     cpl_propertylist *pheader, 
				     cpl_frameset *set_in,
				     cpl_frameset *set_sel,
				     const cpl_parameterlist *parlist,
				     const char *recipe_name,
				     const char *pro_cat,
				     const char *pro_tech,
				     const char *pro_sci,
				     char *filename);

cpl_error_code interpolate(cpl_vector *p_row, cpl_vector *p_param, 
			   cpl_vector *p_res);
cpl_error_code derivative(cpl_vector *p_row, cpl_vector *p_param, 
			  cpl_matrix *p_dres);
mat_kappamatrix *mat_compute_kappamatrix(mat_gendata ** shutter1,
					 mat_gendata ** shutter2, 
					 mat_gendata ** shutter3, 
					 mat_gendata ** shutter4, 
					 mat_gendata **sky_shutter1,
					 mat_gendata **sky_shutter2,
					 mat_gendata **sky_shutter3,
					 mat_gendata **sky_shutter4,
					 int  nbFile [8]);

#endif
