/* $Id: mat_merge_results_lib.c,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License,	or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_merge_results_lib.c $
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


/*-----------------------------------------------------------------------------
  Includes
  -----------------------------------------------------------------------------*/

#include <math.h>

#include "mat_const.h"
#include "mat_error.h"
#include "mat_utils.h"
#include "mat_oifits.h"
#include "mat_merge_results_lib.h"


/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
   @brief This function is called by the mat_merge_results recipe
   @param  frameset: the list of frames that have been given 
   to the recipe for processing
   @param  parlist : parameters list
   @param  recname : Name of the recipes calling this function
   @param  keycal : Calibrator keyword for mat_cal_oifits
   @return 0 if everything is ok
*/
/*-----------------------------------------------------------------------------*/

int mat_merge_results_lib(cpl_frameset	*frameset, cpl_parameterlist *parlist,
			  const char	*recname,cpl_propertylist *keycal) 
{
  cpl_frame *sel_frame = NULL;
  char *pszFileName    = NULL;
  char *pszFileTag     = NULL;
  mat_array		*oiarray       = NULL;
  mat_array		*oiarrayTempo  = NULL;
  mat_oitarget	*oitarget      = NULL;
  mat_oitarget	*oitargetTempo = NULL;
  mat_oiwavelength	*oiwave	       = NULL;
  mat_oiwavelength	*oiwaveTempo   = NULL;
  mat_oivis2	*oivis2	   = NULL;
  mat_oivis2	*oivis2Tmp = NULL;
  mat_oivis2	*oivis2Dup = NULL;
  mat_oitf2	*oitf2	   = NULL;
  mat_oitf2	*oitf2Tmp  = NULL;
  mat_oitf2	*oitf2Dup  = NULL;
  mat_oit3	*oit3	   = NULL;
  mat_oit3	*oit3Tmp   = NULL;
  mat_oit3	*oit3Dup   = NULL;
  mat_oivis	*oivis	   = NULL;
  mat_oivis	*oivisTmp  = NULL;
  mat_oivis	*oivisDup  = NULL;
  mat_oispectrum	*oispectrum    = NULL;
  mat_oispectrum	*oispectrumTmp = NULL;
  mat_oifits		*oifits	       = NULL;
  mat_oifits		*oifitscal     = NULL;
  cpl_table		*table	       = NULL;
  cpl_table		*table_tempo   = NULL;
  cpl_propertylist	*plist	     = NULL;
  cpl_propertylist	*pheader     = NULL;
  cpl_propertylist	*plist_tempo = NULL;
  cpl_frame		*cur_frame  = NULL;
  cpl_frameset	*usedframes = NULL;
  //cpl_frame		*sel_frame  = NULL;
  char		*p_filename = NULL;
  char		*p_filetag  = NULL;
  /* int expert = 0; */
  char		*keyExtname = NULL;
  cpl_parameter	*cumulBlock = NULL;
  cpl_parameter	*parbcdMode    = NULL;
  int	mode	  = 0;
  int	nb_extent = 0;
  int	i	  = 0;
  int	j	  = 0;
  int	k	  = 0;
  int	 nbBaseline    = 0;
  int	 nbBlock       = 0;
  int	*indexBaseline = NULL;
  int	 nbTriplet     = 0;
  int	*indexTriplet  = NULL;
  /* char *output=NULL; */
  int	flagScal   = 0;
  int	flag	   = 0;
  int	flagbcd    = 0;
  int	flagbcdSel = 0;
  int	cpt	   = 0;
  char	*bcdMode = NULL;
  char	*chopMode = NULL;
  cpl_frameset_iterator	*it	  = NULL;
  cpl_errorstate		 prestate = cpl_errorstate_get();
  cpl_propertylist	*qctf2	= NULL;
  cpl_propertylist	*qct3	= NULL;
  cpl_propertylist	*qcvis2	= NULL;
  cpl_propertylist	*qcvis	= NULL;
  cpl_propertylist	*qcflux	= NULL;
  cpl_propertylist	*plist_jsdc = NULL;
  int	nbtf2Indiv  = 0;
  /* int	nbvis2Indiv = 0; */
  /* int	nbvisIndiv  = 0; */
  /* int	nbt3Indiv   = 0; */
  char *output=NULL;
  double *phasorRe=NULL;
  double *phasorIm=NULL;
  int nboispectrum=0;

  // Compute Qc global OPD.MAX
  double opdmax=0.;
  it=cpl_frameset_iterator_new(frameset);
  do {
    cur_frame = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL)
      {
	p_filetag = (char *)cpl_frame_get_tag(cur_frame);
	if ( strcmp(p_filetag,"OI_OPDWVPO") == 0 )
	  {
	    pheader = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
	    if (cpl_propertylist_get_double(pheader,"ESO QC MAX OPD") > opdmax)
	      {
		opdmax = cpl_propertylist_get_double(pheader,"ESO QC MAX OPD");
	      }
	    cpl_propertylist_delete(pheader);	    
	  }
      }
  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);
  
  flag = 0;
  cpl_msg_info(cpl_func,"Merging results...");
  parbcdMode=cpl_parameterlist_find(parlist,"matisse.mat_merge_results.bcdMode");
  it=cpl_frameset_iterator_new(frameset);
  do {
    cur_frame = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL)
      {
	flag=1;
	/*first file, references values*/
	p_filetag = (char *)cpl_frame_get_tag(cur_frame);
	pheader	= cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
	if (cpl_propertylist_has(pheader,"ESO CFG BCD MODE"))
	  {
	    bcdMode = (char *) cpl_propertylist_get_string(pheader,"ESO CFG BCD MODE");
	    if ( cpl_propertylist_has(pheader,"ESO ISS CHOP ST") )
	      {
		chopMode = (char *) cpl_propertylist_get_string(pheader,"ESO ISS CHOP ST");
	      }
	    else
	      {
		chopMode=cpl_sprintf("F");
	      }
	    flagbcd = 0;
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "OUT-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==0)
	      {
		flagbcd	= 2;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "IN-IN") == 0 && cpl_parameter_get_int(parbcdMode)==1)
	      {
		flagbcd	= 3;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "IN-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==2)
	      {
		flagbcd	= 4;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "OUT-IN") == 0 && cpl_parameter_get_int(parbcdMode)==3)
	      {
		flagbcd	= 5;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "OUT-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==4)
	      {
		flagbcd	= 6;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "IN-IN") == 0 && cpl_parameter_get_int(parbcdMode)==5)
	      {
		flagbcd	= 7;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "IN-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==6)
	      {
		flagbcd	= 8;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "OUT-IN") == 0 && cpl_parameter_get_int(parbcdMode)==7)
	      {
		flagbcd	= 9;
	      }
	    //cpl_free(chopMode);
	  }
	else
	  {
	    flagbcd = 1;
	  }
      
	if ( (strcmp(p_filetag,"RAW_VIS2")     == 0	||
	      strcmp(p_filetag,"RAW_CPHASE")   == 0	||
	      strcmp(p_filetag,"RAW_DPHASE")   == 0	||
	      strcmp(p_filetag,"RAW_SPECTRUM") == 0	||
	      strcmp(p_filetag,"RAW_TF2")      == 0 )	&&
	     (flagbcd > 0) )
	  {
	    //cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
	    nb_extent = cpl_frame_get_nextensions(cur_frame);
	    flag      = 0;
	    mat_array_delete(oiarray);
	    mat_oiwavelength_delete(oiwave);
	    mat_oitarget_delete(oitarget);
	
	    for(i=0;i<nb_extent;i++)
	      {
		plist = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
		keyExtname=(char *)cpl_propertylist_get_string(plist,"EXTNAME");
		if (keyExtname != NULL)
		  {
		    if (!strcmp(keyExtname,"TF2") )
		      {
			flagScal = 1;
			flag	 = 1;
		      }
		    if (!strcmp(keyExtname,"OI_ARRAY") )
		      {
			table	= cpl_table_load(cpl_frame_get_filename(cur_frame),i+1,0);
			oiarray = mat_array_from_table(plist,table);
			cpl_table_delete(table);
		      }
		    if (!strcmp(keyExtname,"OI_TARGET") )
		      {
			oitarget = mat_oitarget_load(cur_frame);
		      }
		    if (!strcmp(keyExtname,"OI_WAVELENGTH") )
		      {
			oiwave = mat_oiwavelength_load(cur_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	  }
      


	if ( (strcmp(p_filetag,"CAL_VIS2")   == 0	||
	      strcmp(p_filetag,"CAL_CPHASE") == 0	||
	      strcmp(p_filetag,"CAL_DPHASE") == 0)	&&
	     (flagbcd > 0) )
	  {
	    //cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
	    nb_extent = cpl_frame_get_nextensions(cur_frame);
	    flag      = 0;
	    mat_array_delete(oiarray);
	    mat_oiwavelength_delete(oiwave);
	    mat_oitarget_delete(oitarget);
	
	    for(i=0;i<nb_extent;i++)
	      {
		plist =	cpl_propertylist_load(cpl_frame_get_filename(cur_frame),i+1);
		keyExtname	= (char *)cpl_propertylist_get_string(plist,"EXTNAME");
		if (keyExtname != NULL)
		  {
		    if (!strcmp(keyExtname,"OI_ARRAY") )
		      {
			table	= cpl_table_load(cpl_frame_get_filename(cur_frame),i+1,0);
			oiarray = mat_array_from_table(plist,table);
			cpl_table_delete(table);
		      }
		    if (!strcmp(keyExtname,"OI_TARGET") )
		      {
			oitarget = mat_oitarget_load(cur_frame);
		      }
		    if (!strcmp(keyExtname,"OI_WAVELENGTH") )
		      {
			oiwave = mat_oiwavelength_load(cur_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	  }
	cpl_propertylist_delete(pheader);
      }
  } while (flag == 1 &&
	   cpl_frameset_iterator_advance(it, 1) !=
	   CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);
  if (!cpl_errorstate_is_equal(prestate))
    {
      cpl_errorstate_set(prestate);
    }


  if (flagbcd == 0)
    {
      if (cpl_parameter_get_int(parbcdMode) == 0 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-OUT frames found in the sof - No Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 1 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-OUT frames found in the sof - No Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 2 )
	{
	  cpl_msg_info(cpl_func,"No BCD IN-OUT frames found in the sof - No Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 3 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-IN frames found in the sof - No Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 4 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-OUT frames found in the sof - Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 5 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-OUT frames found in the sof - Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 6 )
	{
	  cpl_msg_info(cpl_func,"No BCD IN-OUT frames found in the sof - Chop");
	}
      else if (cpl_parameter_get_int(parbcdMode) == 7 )
	{
	  cpl_msg_info(cpl_func,"No BCD OUT-IN frames found in the sof - Chop");
	}
	  
      return 0;
    }







  /*
    1. Check the data type of the input frames.
    2. Load data 
    mat_check_tag
  */
  //usedframes = cpl_frameset_new();
  prestate   = cpl_errorstate_get();
  it	       = cpl_frameset_iterator_new(frameset);
  do {
    cur_frame  = cpl_frameset_iterator_get(it);
    if (cur_frame != NULL)
      {
	p_filename = (char *)cpl_frame_get_filename(cur_frame);
	p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
	flag	= 0;
	pheader	= cpl_propertylist_load(p_filename,0);
	if (cpl_propertylist_has(pheader,"ESO CFG BCD MODE"))
	  {
	    bcdMode = (char *) cpl_propertylist_get_string(pheader,"ESO CFG BCD MODE");
	    if ( cpl_propertylist_has(pheader,"ESO ISS CHOP ST") )
	      {
		chopMode = (char *) cpl_propertylist_get_string(pheader,"ESO ISS CHOP ST");
	      }
	    else
	      {
		chopMode=cpl_sprintf("F");
	      }
	    flagbcd = 0;
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "OUT-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==0)
	      {
		flagbcd	= 2;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "IN-IN") == 0 && cpl_parameter_get_int(parbcdMode)==1)
	      {
		flagbcd	= 3;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "IN-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==2)
	      {
		flagbcd	= 4;
	      }
	    if (strcmp(chopMode,"F") == 0 && strcmp(bcdMode, "OUT-IN") == 0 && cpl_parameter_get_int(parbcdMode)==3)
	      {
		flagbcd	= 5;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "OUT-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==4)
	      {
		flagbcd	= 6;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "IN-IN") == 0 && cpl_parameter_get_int(parbcdMode)==5)
	      {
		flagbcd	= 7;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "IN-OUT") == 0 && cpl_parameter_get_int(parbcdMode)==6)
	      {
		flagbcd	= 8;
	      }
	    if (strcmp(chopMode,"T") == 0 && strcmp(bcdMode, "OUT-IN") == 0 && cpl_parameter_get_int(parbcdMode)==7)
	      {
		flagbcd	= 9;
	      }
	    //cpl_free(chopMode);
	  }
	else
	  {
	    flagbcd = 1;
	  }
	if ( (strcmp(p_filetag,"RAW_VIS2")     == 0	||
	      strcmp(p_filetag,"RAW_CPHASE")   == 0	||
	      strcmp(p_filetag,"RAW_DPHASE")   == 0	||
	      strcmp(p_filetag,"RAW_SPECTRUM") == 0	||
	      strcmp(p_filetag,"RAW_TF2")      == 0	||
	      strcmp(p_filetag,"CAL_VIS2")     == 0	||
	      strcmp(p_filetag,"CAL_CPHASE")   == 0	||
	      strcmp(p_filetag,"CAL_DPHASE")   == 0 )	&&
	     (flagbcd > 1)
	     )
	  {
	    flagbcdSel = flagbcd;
	    /*compare  OI_TARGET, OI_ARRAY, OI_WAVELENGTH */
	    for(i = 0;i<nb_extent;i++)
	      {
		plist_tempo = cpl_propertylist_load(
						    cpl_frame_get_filename(cur_frame), i+1);
		keyExtname  = (char *)cpl_propertylist_get_string(plist_tempo,
								  "EXTNAME");
		if (keyExtname != NULL)
		  {
		    if (!strcmp(keyExtname,"OI_ARRAY") )
		      {
			table_tempo = cpl_table_load(
						     cpl_frame_get_filename(cur_frame),i+1, 0);
			oiarrayTempo = mat_array_from_table(plist_tempo,table_tempo);
			cpl_table_delete(table_tempo);
		      }
		    if (!strcmp(keyExtname,"OI_TARGET") )
		      {
			oitargetTempo = mat_oitarget_load(cur_frame);
		      }
		    if (!strcmp(keyExtname,"OI_WAVELENGTH") )
		      {
			oiwaveTempo = mat_oiwavelength_load(cur_frame);
		      }
		  }
		cpl_propertylist_delete(plist_tempo);
	      }
	    //	no oitarget for a RAW_TF2
	    if (strcmp(p_filetag,"RAW_TF2") == 0)
	      {
		if (mat_array_compare(oiarray, oiarrayTempo)	  == CPL_TRUE	&&
		    mat_oiwavelength_compare(oiwave, oiwaveTempo) == CPL_TRUE)
		  {
		    flagScal   = 1;
		    flag       = 1;
		    /*sel_frame = cpl_frame_duplicate(cur_frame);
		    cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
		    cpl_frameset_insert(usedframes,sel_frame);*/
		    if (oitf2 == NULL)
		      {
			oitf2	   = mat_oitf2_load_nt(cur_frame);
			nbtf2Indiv = oitf2->nbtf2;
			plist=cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
			qctf2	   = cpl_propertylist_new();
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC DET1 TFSQR",0);
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC DET2 TFSQR",0);
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC DET3 TFSQR",0);
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC DET1 TRANS",0);
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC DET2 TRANS",0);
			cpl_propertylist_copy_property_regexp(qctf2,plist,"ESO QC TF",0);
			if (plist_jsdc == NULL)
			  {
			    plist_jsdc=cpl_propertylist_new();
			    cpl_propertylist_copy_property_regexp(plist_jsdc,plist,"ESO PRO JSDC",0);
			  }
			cpl_propertylist_delete(plist);
		      }
		    else
		      {
			cpl_msg_info(cpl_func,"TF2 Merging...");

			oitf2Tmp	    = mat_oitf2_load_nt(cur_frame);
			// Duplicate oitf2
			oitf2Dup	    = cpl_malloc(sizeof(mat_oitf2));
			oitf2Dup->dateobs   = NULL;
			oitf2Dup->arrayname = NULL;
			oitf2Dup->insname   = NULL;
			oitf2Dup->nbtf2	    = oitf2->nbtf2;
			oitf2Dup->list_tf2  = 
			  cpl_malloc(oitf2Dup->nbtf2*
				     sizeof(mat_tf2elem *));
			for(k = 0;k<oitf2Dup->nbtf2;k++)
			  {
			    oitf2Dup->list_tf2[k]	      =	 cpl_malloc(sizeof(mat_tf2elem));
			    oitf2Dup->list_tf2[k]->time	      =	 oitf2->list_tf2[k]->time;
			    oitf2Dup->list_tf2[k]->dateobsmjd =	 oitf2->list_tf2[k]->dateobsmjd;
			    oitf2Dup->list_tf2[k]->exptime    =	 oitf2->list_tf2[k]->exptime;

			    oitf2Dup->list_tf2[k]->tf2	  =  cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2Dup->list_tf2[k]->tf2err =  cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2Dup->list_tf2[k]->tf	  =  cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2Dup->list_tf2[k]->tferr  =  cpl_malloc(oiwave->nbchannel*sizeof(double));
			    for(j = 0;j<oiwave->nbchannel;j++)
			      {
				oitf2Dup->list_tf2[k]->tf2[j]	 =  oitf2->list_tf2[k]->tf2[j];
				oitf2Dup->list_tf2[k]->tf2err[j] =  oitf2->list_tf2[k]->tf2err[j];
				oitf2Dup->list_tf2[k]->tf[j]	 =  oitf2->list_tf2[k]->tf[j];
				oitf2Dup->list_tf2[k]->tferr[j]  =  oitf2->list_tf2[k]->tferr[j];
			      }

			    oitf2Dup->list_tf2[k]->stationindex[0] =  oitf2->list_tf2[k]->stationindex[0];
			    oitf2Dup->list_tf2[k]->stationindex[1] =  oitf2->list_tf2[k]->stationindex[1];
				    
			  }
			// delete oitf2->list_tf2
			for(k=0;k<oitf2->nbtf2;k++)
			  {
			    if(oitf2->list_tf2[k]->tf2 != NULL)
			      {
				cpl_free(oitf2->list_tf2[k]->tf2);
				oitf2->list_tf2[k]->tf2	= NULL;
			      }
			    if(oitf2->list_tf2[k]->tf2err != NULL)
			      {
				cpl_free(oitf2->list_tf2[k]->tf2err);
				oitf2->list_tf2[k]->tf2err = NULL;
			      }
			    if(oitf2->list_tf2[k]->tf != NULL)
			      {
				cpl_free(oitf2->list_tf2[k]->tf);
				oitf2->list_tf2[k]->tf	= NULL;
			      }
			    if(oitf2->list_tf2[k]->tferr != NULL)
			      {
				cpl_free(oitf2->list_tf2[k]->tferr);
				oitf2->list_tf2[k]->tferr = NULL;
			      }
			    cpl_free(oitf2->list_tf2[k]);
			  }
			cpl_free(oitf2->list_tf2);
			// Concat oitf2Dup oitf2Tmp
			oitf2->nbtf2 += oitf2Tmp->nbtf2;
			oitf2->list_tf2	 = cpl_malloc(
						      oitf2->nbtf2*sizeof(mat_tf2elem *));
			for(k = 0;k<oitf2Dup->nbtf2;k++)
			  {
			    oitf2->list_tf2[k]		   =  cpl_malloc(sizeof(mat_tf2elem));
			    oitf2->list_tf2[k]->time	   =  oitf2Dup->list_tf2[k]->time;
			    oitf2->list_tf2[k]->dateobsmjd =  oitf2Dup->list_tf2[k]->dateobsmjd;
			    oitf2->list_tf2[k]->exptime	   =  oitf2Dup->list_tf2[k]->exptime;

			    oitf2->list_tf2[k]->tf2    =  cpl_malloc(oiwave->nbchannel* sizeof(double));
			    oitf2->list_tf2[k]->tf2err =  cpl_malloc(oiwave->nbchannel* sizeof(double));
			    oitf2->list_tf2[k]->tf     =  cpl_malloc(oiwave->nbchannel* sizeof(double));
			    oitf2->list_tf2[k]->tferr  =  cpl_malloc(oiwave->nbchannel* sizeof(double));
			    for(j = 0;j<oiwave->nbchannel;j++)
			      {
				oitf2->list_tf2[k]->tf2[j]    =  oitf2Dup->list_tf2[k]->tf2[j];
				oitf2->list_tf2[k]->tf2err[j] =	 oitf2Dup->list_tf2[k]->tf2err[j];
				oitf2->list_tf2[k]->tf[j]     =  oitf2Dup->list_tf2[k]->tf[j];
				oitf2->list_tf2[k]->tferr[j]  =	 oitf2Dup->list_tf2[k]->tferr[j];
			      }
			    oitf2->list_tf2[k]->stationindex[0]	= oitf2Dup->list_tf2[k]->stationindex[0];
			    oitf2->list_tf2[k]->stationindex[1]	= oitf2Dup->list_tf2[k]->stationindex[1];
			  }
			for(k =	0;k<oitf2Tmp->nbtf2;k++)
			  {
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]	     = cpl_malloc(sizeof(mat_tf2elem));
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->time = oitf2Tmp->list_tf2[k]->time;
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->dateobsmjd = oitf2Tmp->list_tf2[k]->dateobsmjd;
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->exptime	   = oitf2Tmp->list_tf2[k]->exptime;

			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf2    = cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf2err = cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf     = cpl_malloc(oiwave->nbchannel*sizeof(double));
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->tferr  = cpl_malloc(oiwave->nbchannel*sizeof(double));
			    for(j = 0;j<oiwave->nbchannel;j++)
			      {
				oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf2[j]    =	oitf2Tmp->list_tf2[k]->tf2[j];
				oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf2err[j] =	oitf2Tmp->list_tf2[k]->tf2err[j];
				oitf2->list_tf2[k+oitf2Dup->nbtf2]->tf[j]     =	oitf2Tmp->list_tf2[k]->tf[j];
				oitf2->list_tf2[k+oitf2Dup->nbtf2]->tferr[j]  =	oitf2Tmp->list_tf2[k]->tferr[j];
			      }
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->stationindex[0]	= oitf2Tmp->list_tf2[k]->stationindex[0];
			    oitf2->list_tf2[k+oitf2Dup->nbtf2]->stationindex[1]	= oitf2Tmp->list_tf2[k]->stationindex[1];
			  }
			mat_oitf2_delete_nt(oitf2Dup);
			mat_oitf2_delete_nt(oitf2Tmp);
		      }
		  }
		else
		  {
		    printf("file ko %s\n", p_filename);
		    flag = 1;
		  }
	      }
	    else
	      {
		if (mat_array_compare(oiarray, oiarrayTempo)==CPL_TRUE	&&
		    mat_oiwavelength_compare(oiwave, oiwaveTempo)   == CPL_TRUE
		    && mat_oitarget_compare(oitarget,oitargetTempo) == CPL_TRUE)
		  {
		    /* get classification tag */
		    /* and load data */
		    if (strcmp(p_filetag,"RAW_VIS2") == 0	||
			strcmp(p_filetag,"CAL_VIS2") == 0)
		      {
			if (strcmp(p_filetag,"RAW_VIS2") == 0)
			  {
			    mode = 5;
			  }
			else
			  {
			    mode = 9;
			  }

			/*sel_frame   = cpl_frame_duplicate(cur_frame);
			cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
			cpl_frameset_insert(usedframes,sel_frame);*/
			if (oivis2 == NULL)
			  {
			    oivis2	= mat_oivis2_load(cur_frame);
			    //nbvis2Indiv	= oivis2->nbvis2;
			    qcvis2	= cpl_propertylist_new();
			    plist=cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
			    if (strcmp(p_filetag,"RAW_VIS2") == 0)
			      {
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET1 VISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET2 VISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET3 VISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC INS",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC VIS",0);
			      }
			    else
			      {
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET1 CALVISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET2 CALVISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET3 CALVISSQR",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC INS",0);
				cpl_propertylist_copy_property_regexp(qcvis2,plist,"ESO QC DET",0);
			      }
			    if (strcmp(p_filetag,"RAW_VIS2") == 0)
			      {
				if ( cpl_propertylist_get_bool(plist,"ESO PRO SCIENCE") == 0)
				  {				    
				    flagScal = 1;
				  }
			      }
			    else
			      {
				flagScal = 0;
			      }
			    cpl_propertylist_delete(plist);
			  }
			else
			  {
			    cpl_msg_info(cpl_func,"VIS2 Merging...");
			    oivis2Tmp		 = mat_oivis2_load(cur_frame);
			    // Duplicate oivis2
			    oivis2Dup		 = cpl_malloc(sizeof(mat_oivis2));
			    oivis2Dup->dateobs	 = NULL;
			    oivis2Dup->arrayname = NULL;
			    oivis2Dup->insname	 = NULL;
			    oivis2Dup->nbvis2	 = oivis2->nbvis2;
			    oivis2Dup->list_vis2 = 
			      cpl_malloc(oivis2Dup->nbvis2*
					 sizeof(mat_vis2elem *));
			    for(k = 0;k<oivis2Dup->nbvis2;k++)
			      {
				oivis2Dup->list_vis2[k]=cpl_malloc(sizeof(mat_vis2elem));
				oivis2Dup->list_vis2[k]->targetid=oivis2->list_vis2[k]->targetid;
				oivis2Dup->list_vis2[k]->time=oivis2->list_vis2[k]->time;
				oivis2Dup->list_vis2[k]->dateobsmjd=oivis2->list_vis2[k]->dateobsmjd;
				oivis2Dup->list_vis2[k]->exptime=oivis2->list_vis2[k]->exptime;
				oivis2Dup->list_vis2[k]->vis2=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2Dup->list_vis2[k]->vis2err=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2Dup->list_vis2[k]->bandflag=cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oivis2Dup->list_vis2[k]->vis2[j]=oivis2->list_vis2[k]->vis2[j];
				    oivis2Dup->list_vis2[k]->vis2err[j]=oivis2->list_vis2[k]->vis2err[j];
				    oivis2Dup->list_vis2[k]->bandflag[j]=oivis2->list_vis2[k]->bandflag[j];
				  }
				oivis2Dup->list_vis2[k]->ucoord=oivis2->list_vis2[k]->ucoord;
				oivis2Dup->list_vis2[k]->vcoord=oivis2->list_vis2[k]->vcoord;
				oivis2Dup->list_vis2[k]->stationindex[0]=oivis2->list_vis2[k]->stationindex[0];
				oivis2Dup->list_vis2[k]->stationindex[1]=oivis2->list_vis2[k]->stationindex[1];   
			      }
			    // delete oivis2->list_vis2
			    for(k = 0;k<oivis2->nbvis2;k++)
			      {
				mat_vis2elem_delete(oivis2->list_vis2[k]);
			      }
			    cpl_free(oivis2->list_vis2);
			    // Concat oivis2Dup oivis2Tmp
			    oivis2->nbvis2+=oivis2Tmp->nbvis2;
			    oivis2->list_vis2=cpl_malloc(oivis2->nbvis2*sizeof(mat_vis2elem *));
			    for(k = 0;k<oivis2Dup->nbvis2;k++)
			      {
				oivis2->list_vis2[k]=cpl_malloc(sizeof(mat_vis2elem));
				oivis2->list_vis2[k]->targetid=oivis2Dup->list_vis2[k]->targetid;
				oivis2->list_vis2[k]->time=oivis2Dup->list_vis2[k]->time;
				oivis2->list_vis2[k]->dateobsmjd=oivis2Dup->list_vis2[k]->dateobsmjd;
				oivis2->list_vis2[k]->exptime=oivis2Dup->list_vis2[k]->exptime;
				oivis2->list_vis2[k]->vis2=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2->list_vis2[k]->vis2err=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2->list_vis2[k]->bandflag=cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oivis2->list_vis2[k]->vis2[j]=oivis2Dup->list_vis2[k]->vis2[j];
				    oivis2->list_vis2[k]->vis2err[j]=oivis2Dup->list_vis2[k]->vis2err[j];
				    oivis2->list_vis2[k]->bandflag[j]=oivis2Dup->list_vis2[k]->bandflag[j];
				  }
				oivis2->list_vis2[k]->ucoord=oivis2Dup->list_vis2[k]->ucoord;
				oivis2->list_vis2[k]->vcoord=oivis2Dup->list_vis2[k]->vcoord;
				oivis2->list_vis2[k]->stationindex[0]=oivis2Dup->list_vis2[k]->stationindex[0];
				oivis2->list_vis2[k]->stationindex[1]=oivis2Dup->list_vis2[k]->stationindex[1];
			      }
			    for(k = 0;k<oivis2Tmp->nbvis2;k++)
			      {
				oivis2->list_vis2[k+oivis2Dup->nbvis2]=cpl_malloc(sizeof(mat_vis2elem));
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->targetid=oivis2Tmp->list_vis2[k]->targetid;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->time=oivis2Tmp->list_vis2[k]->time;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->dateobsmjd=oivis2Tmp->list_vis2[k]->dateobsmjd;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->exptime=oivis2Tmp->list_vis2[k]->exptime;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->vis2=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->vis2err=cpl_malloc(oiwave->nbchannel*sizeof(double));
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->bandflag=cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oivis2->list_vis2[k+oivis2Dup->nbvis2]->vis2[j]=oivis2Tmp->list_vis2[k]->vis2[j];
				    oivis2->list_vis2[k+oivis2Dup->nbvis2]->vis2err[j]=oivis2Tmp->list_vis2[k]->vis2err[j];
				    oivis2->list_vis2[k+oivis2Dup->nbvis2]->bandflag[j]=oivis2Tmp->list_vis2[k]->bandflag[j];
				  }
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->ucoord=oivis2Tmp->list_vis2[k]->ucoord;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->vcoord=oivis2Tmp->list_vis2[k]->vcoord;
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->stationindex[0]=oivis2Tmp->list_vis2[k]->stationindex[0];
				oivis2->list_vis2[k+oivis2Dup->nbvis2]->stationindex[1]=oivis2Tmp->list_vis2[k]->stationindex[1];
			      }
			    mat_oivis2_delete(oivis2Dup);
			    mat_oivis2_delete(oivis2Tmp);
			  }

		      } else if (strcmp(p_filetag,"RAW_CPHASE") == 0	||
				 strcmp(p_filetag,"CAL_CPHASE") == 0)
		      {
			/*sel_frame = cpl_frame_duplicate(cur_frame);
			cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
			cpl_frameset_insert(usedframes,sel_frame);*/
			if (oit3 == NULL)
			  {
			    oit3      = mat_oit3_load(cur_frame);
			    //nbt3Indiv =	oit3->nbt3;
			    qct3=cpl_propertylist_new();
			    plist = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
			    if (strcmp(p_filetag,"RAW_CPHASE") == 0)
			      {
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET1 CPHASE",0);
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET2 CPHASE",0);
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET3 CPHASE",0);
			      }
			    else
			      {
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET1 CALCPHASE",0);
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET2 CALCPHASE",0);
				cpl_propertylist_copy_property_regexp(qct3,plist,"ESO QC DET3 CALCPHASE",0);
			      };
			    if (strcmp(p_filetag,"RAW_CPHASE") == 0)
			      {
				if ( cpl_propertylist_get_bool(plist,"ESO PRO SCIENCE") == 0)
				  {
				    flagScal = 1;
				  }
			      }
			    else
			      {
				flagScal = 0;
			      }
			    cpl_propertylist_delete(plist);
			  }
			else
			  {
			    cpl_msg_info(cpl_func,"T3 Merging...");
			    oit3Tmp	       = mat_oit3_load(cur_frame);
			    // Duplicate oit3
			    oit3Dup	       = cpl_malloc(sizeof(mat_oit3));
			    oit3Dup->dateobs   = NULL;
			    oit3Dup->arrayname = NULL;
			    oit3Dup->insname   = NULL;
			    oit3Dup->nbt3      = oit3->nbt3;
			    oit3Dup->list_t3   = 
			      cpl_malloc(oit3Dup->nbt3*
					 sizeof(mat_t3elem *));
			    for(k = 0;k<oit3Dup->nbt3;k++)
			      {
				oit3Dup->list_t3[k]	      = 
				  cpl_malloc(sizeof(mat_t3elem));
				oit3Dup->list_t3[k]->targetid = 
				  oit3->list_t3[k]->targetid;
				oit3Dup->list_t3[k]->time     = 
				  oit3->list_t3[k]->time;
				oit3Dup->list_t3[k]->dateobsmjd	= 
				  oit3->list_t3[k]->dateobsmjd;
				oit3Dup->list_t3[k]->exptime	= 
				  oit3->list_t3[k]->exptime;

				oit3Dup->list_t3[k]->t3phi    =	
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3Dup->list_t3[k]->t3phierr =	
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3Dup->list_t3[k]->t3amp    =	
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3Dup->list_t3[k]->t3amperr =	
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3Dup->list_t3[k]->bandflag =	
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oit3Dup->list_t3[k]->t3phi[j]    = 
				      oit3->list_t3[k]->t3phi[j];
				    oit3Dup->list_t3[k]->t3phierr[j] = 
				      oit3->list_t3[k]->t3phierr[j];
				    oit3Dup->list_t3[k]->t3amp[j]    = 
				      oit3->list_t3[k]->t3amp[j];
				    oit3Dup->list_t3[k]->t3amperr[j] = 
				      oit3->list_t3[k]->t3amperr[j];
				    oit3Dup->list_t3[k]->bandflag[j] = 
				      oit3->list_t3[k]->bandflag[j];
				  }

				oit3Dup->list_t3[k]->u1coord = 
				  oit3->list_t3[k]->u1coord;
				oit3Dup->list_t3[k]->v1coord = 
				  oit3->list_t3[k]->v1coord;
				oit3Dup->list_t3[k]->u2coord = 
				  oit3->list_t3[k]->u2coord;
				oit3Dup->list_t3[k]->v2coord = 
				  oit3->list_t3[k]->v2coord;
				oit3Dup->list_t3[k]->stationindex[0] = 
				  oit3->list_t3[k]->stationindex[0];
				oit3Dup->list_t3[k]->stationindex[1] = 
				  oit3->list_t3[k]->stationindex[1];
				oit3Dup->list_t3[k]->stationindex[2] = 
				  oit3->list_t3[k]->stationindex[2];
				    
			      }
			    // delete oit3->list_t3
			    for(k = 0;k<oit3->nbt3;k++)
			      {
				mat_t3elem_delete(oit3->list_t3[k]);
			      }
			    cpl_free(oit3->list_t3);
			    // Concat oit3Dup oit3Tmp
			    oit3->nbt3	  += oit3Tmp->nbt3;
			    oit3->list_t3  = cpl_malloc(
							oit3->nbt3*sizeof(mat_t3elem *));
			    for(k = 0;k<oit3Dup->nbt3;k++)
			      {
				oit3->list_t3[k]	     = 
				  cpl_malloc(sizeof(mat_t3elem));
				oit3->list_t3[k]->targetid   = 
				  oit3Dup->list_t3[k]->targetid;
				oit3->list_t3[k]->time	     = 
				  oit3Dup->list_t3[k]->time;
				oit3->list_t3[k]->dateobsmjd = 
				  oit3Dup->list_t3[k]->dateobsmjd;
				oit3->list_t3[k]->exptime    = 
				  oit3Dup->list_t3[k]->exptime;

				oit3->list_t3[k]->t3phi	   = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k]->t3phierr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k]->t3amp	   = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k]->t3amperr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k]->bandflag = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oit3->list_t3[k]->t3phi[j]	  = 
				      oit3Dup->list_t3[k]->t3phi[j];
				    oit3->list_t3[k]->t3phierr[j] = 
				      oit3Dup->list_t3[k]->t3phierr[j];
				    oit3->list_t3[k]->t3amp[j]	  = 
				      oit3Dup->list_t3[k]->t3amp[j];
				    oit3->list_t3[k]->t3amperr[j] = 
				      oit3Dup->list_t3[k]->t3amperr[j];
				    oit3->list_t3[k]->bandflag[j] = 
				      oit3Dup->list_t3[k]->bandflag[j];
				  }
				oit3->list_t3[k]->u1coord = 
				  oit3Dup->list_t3[k]->u1coord;
				oit3->list_t3[k]->v1coord = 
				  oit3Dup->list_t3[k]->v1coord;
				oit3->list_t3[k]->u2coord = 
				  oit3Dup->list_t3[k]->u2coord;
				oit3->list_t3[k]->v2coord = 
				  oit3Dup->list_t3[k]->v2coord;
				oit3->list_t3[k]->stationindex[0] = 
				  oit3Dup->list_t3[k]->stationindex[0];
				oit3->list_t3[k]->stationindex[1] = 
				  oit3Dup->list_t3[k]->stationindex[1];
				oit3->list_t3[k]->stationindex[2] = 
				  oit3Dup->list_t3[k]->stationindex[2];
			      }
			    for(k = 0;k<oit3Tmp->nbt3;k++)
			      {
				oit3->list_t3[k+oit3Dup->nbt3]		 = 
				  cpl_malloc(sizeof(mat_t3elem));
				oit3->list_t3[k+oit3Dup->nbt3]->targetid = 
				  oit3Tmp->list_t3[k]->targetid;
				oit3->list_t3[k+oit3Dup->nbt3]->time	 = 
				  oit3Tmp->list_t3[k]->time;
				oit3->list_t3[k+oit3Dup->nbt3]->dateobsmjd = 
				  oit3Tmp->list_t3[k]->dateobsmjd;
				oit3->list_t3[k+oit3Dup->nbt3]->exptime	   = 
				  oit3Tmp->list_t3[k]->exptime;

				oit3->list_t3[k+oit3Dup->nbt3]->t3phi	 = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k+oit3Dup->nbt3]->t3phierr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k+oit3Dup->nbt3]->t3amp	 = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k+oit3Dup->nbt3]->t3amperr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oit3->list_t3[k+oit3Dup->nbt3]->bandflag = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(cpl_boolean));
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oit3->list_t3[k+oit3Dup->nbt3]->t3phi[j]	= 
				      oit3Tmp->list_t3[k]->t3phi[j];
				    oit3->list_t3[k+oit3Dup->nbt3]->t3phierr[j]	= 
				      oit3Tmp->list_t3[k]->t3phierr[j];
				    oit3->list_t3[k+oit3Dup->nbt3]->t3amp[j]	= 
				      oit3Tmp->list_t3[k]->t3amp[j];
				    oit3->list_t3[k+oit3Dup->nbt3]->t3amperr[j]	= 
				      oit3Tmp->list_t3[k]->t3amperr[j];
				    oit3->list_t3[k+oit3Dup->nbt3]->bandflag[j]	= 
				      oit3Tmp->list_t3[k]->bandflag[j];
				  }
				oit3->list_t3[k+oit3Dup->nbt3]->u1coord	= 
				  oit3Tmp->list_t3[k]->u1coord;
				oit3->list_t3[k+oit3Dup->nbt3]->v1coord	= 
				  oit3Tmp->list_t3[k]->v1coord;
				oit3->list_t3[k+oit3Dup->nbt3]->u2coord	= 
				  oit3Tmp->list_t3[k]->u2coord;
				oit3->list_t3[k+oit3Dup->nbt3]->v2coord	= 
				  oit3Tmp->list_t3[k]->v2coord;
				oit3->list_t3[k+oit3Dup->nbt3]->stationindex[0]	= 
				  oit3Tmp->list_t3[k]->stationindex[0];
				oit3->list_t3[k+oit3Dup->nbt3]->stationindex[1]	= 
				  oit3Tmp->list_t3[k]->stationindex[1];
				oit3->list_t3[k+oit3Dup->nbt3]->stationindex[2]	= 
				  oit3Tmp->list_t3[k]->stationindex[2];
			      }
			    mat_oit3_delete(oit3Dup);
			    mat_oit3_delete(oit3Tmp);
			  }
		      }
		    else if (strcmp(p_filetag,"RAW_DPHASE") == 0	||
			     strcmp(p_filetag,"CAL_DPHASE") == 0)
		      {
			/*sel_frame = cpl_frame_duplicate(cur_frame);
			cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
			cpl_frameset_insert(usedframes,sel_frame);*/
			if (oivis == NULL)
			  {
			    cpl_msg_info(cpl_func,"OIVIS Merging...");
			    oivis      = mat_oivis_load(cur_frame);
			    //nbvisIndiv = oivis->nbvis;
			    qcvis      = cpl_propertylist_new();
			    plist      = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
			    if (strcmp(p_filetag,"RAW_DPHASE") == 0)
			      {
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET1 DPHASE",0);
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET2 DPHASE",0);
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET3 DPHASE",0);
			      }
			    else
			      {
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET1 CALDPHASE",0);
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET2 CALDPHASE",0);
				cpl_propertylist_copy_property_regexp(qcvis,plist,"ESO QC DET3 CALDPHASE",0);
			      };

			    if (strcmp(p_filetag,"RAW_DPHASE") == 0)
			      {
				if ( cpl_propertylist_get_bool(plist,"ESO PRO SCIENCE") == 0 )
				  {
				    flagScal = 1;
				  }
			      }
			    else
			      {
				flagScal = 0;
			      }
			    cpl_propertylist_delete(plist);
			  }
			else
			  {
			    oivisTmp	       = mat_oivis_load(cur_frame);
			    // Duplicate oivis
			    oivisDup		= cpl_malloc(sizeof(mat_oivis));
			    oivisDup->dateobs	= NULL;
			    oivisDup->arrayname	= NULL;
			    oivisDup->insname	= NULL;
			    oivisDup->amptyp	= NULL;
			    oivisDup->phityp	= NULL;
			    oivisDup->nbvis	= oivis->nbvis;
			    oivisDup->list_vis = 
			      cpl_malloc(oivisDup->nbvis*
					 sizeof(mat_viselem *));
			    for(k = 0;k<oivisDup->nbvis;k++)
			      {
				oivisDup->list_vis[k]=cpl_malloc(sizeof(mat_viselem));
				oivisDup->list_vis[k]->targetid=oivis->list_vis[k]->targetid;
				oivisDup->list_vis[k]->time	  = 
				  oivis->list_vis[k]->time;
				oivisDup->list_vis[k]->dateobsmjd = 
				  oivis->list_vis[k]->dateobsmjd;
				oivisDup->list_vis[k]->exptime	  = 
				  oivis->list_vis[k]->exptime;
			    
				oivisDup->list_vis[k]->visamp	 = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oivisDup->list_vis[k]->visamperr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));

				/* oivisDup->list_vis[k]->cfxamp	 =  */
				/*     cpl_malloc(oiwave->nbchannel* */
				/* 	       sizeof(double)); */
				/* oivisDup->list_vis[k]->cfxamperr =  */
				/*     cpl_malloc(oiwave->nbchannel* */
				/* 	       sizeof(double)); */
		  
				oivisDup->list_vis[k]->visphi	 = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				oivisDup->list_vis[k]->visphierr = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(double));
				
				oivisDup->list_vis[k]->bandflag	 = 
				  cpl_malloc(oiwave->nbchannel*
					     sizeof(cpl_boolean));
				
				for(j = 0;j<oiwave->nbchannel;j++)
				  {
				    oivisDup->list_vis[k]->visamp[j]	= 
				      oivis->list_vis[k]->visamp[j];
				    oivisDup->list_vis[k]->visamperr[j]	= 
				      oivis->list_vis[k]->visamperr[j];
		    
				    /* oivisDup->list_vis[k]->cfxamp[j]	=  */
				    /* 	oivis->list_vis[k]->cfxamp[j]; */
				    /* oivisDup->list_vis[k]->cfxamperr[j]	=  */
				    /* 	oivis->list_vis[k]->cfxamperr[j]; */
		    
				    oivisDup->list_vis[k]->visphi[j]	= 
				      oivis->list_vis[k]->visphi[j];
				    oivisDup->list_vis[k]->visphierr[j]	= 
				      oivis->list_vis[k]->visphierr[j];
				    oivisDup->list_vis[k]->bandflag[j]	= 
				      oivis->list_vis[k]->bandflag[j];
				  }

				oivisDup->list_vis[k]->ucoord	       = 
				  oivis->list_vis[k]->ucoord;
				oivisDup->list_vis[k]->vcoord	       = 
				  oivis->list_vis[k]->vcoord;
				oivisDup->list_vis[k]->stationindex[0] = 
				  oivis->list_vis[k]->stationindex[0];
				oivisDup->list_vis[k]->stationindex[1] = 
				  oivis->list_vis[k]->stationindex[1];
				    
			      }
			    // delete oivis->list_vis
			    for(k = 0;k<oivis->nbvis;k++)
			      {
			    	mat_viselem_delete(oivis->list_vis[k]);
			      }
			    cpl_free(oivis->list_vis);
			    // Concat oivisDup oivisTmp
			    oivis->nbvis    += oivisTmp->nbvis;
			    oivis->list_vis = cpl_malloc(
							 oivis->nbvis*sizeof(mat_viselem *));
			    for(k = 0;k<oivisDup->nbvis;k++)
			      {
			    	oivis->list_vis[k]=cpl_malloc(sizeof(mat_viselem));
			    	oivis->list_vis[k]->targetid=oivisDup->list_vis[k]->targetid;
			    	oivis->list_vis[k]->time=oivisDup->list_vis[k]->time;
			    	oivis->list_vis[k]->dateobsmjd=oivisDup->list_vis[k]->dateobsmjd;
			    	oivis->list_vis[k]->exptime=oivisDup->list_vis[k]->exptime;
			    	oivis->list_vis[k]->visamp=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k]->visamperr=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	/* oivis->list_vis[k]->cfxamp=cpl_malloc(oiwave->nbchannel*sizeof(double)); */
			    	/* oivis->list_vis[k]->cfxamperr=cpl_malloc(oiwave->nbchannel*sizeof(double)); */
			    	oivis->list_vis[k]->visphi=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k]->visphierr=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k]->bandflag=cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
			    	for(j = 0;j<oiwave->nbchannel;j++)
				  {
			    	    oivis->list_vis[k]->visamp[j]=oivisDup->list_vis[k]->visamp[j];
			    	    oivis->list_vis[k]->visamperr[j]=oivisDup->list_vis[k]->visamperr[j];
		    		    /* oivis->list_vis[k]->cfxamp[j]=oivisDup->list_vis[k]->cfxamp[j]; */
			    	    /* oivis->list_vis[k]->cfxamperr[j]=oivisDup->list_vis[k]->cfxamperr[j]; */
			    	    oivis->list_vis[k]->visphi[j]=oivisDup->list_vis[k]->visphi[j];
			    	    oivis->list_vis[k]->visphierr[j]=oivisDup->list_vis[k]->visphierr[j];
			    	    oivis->list_vis[k]->bandflag[j]=oivisDup->list_vis[k]->bandflag[j];
				  }
			    	oivis->list_vis[k]->ucoord=oivisDup->list_vis[k]->ucoord;
			    	oivis->list_vis[k]->vcoord=oivisDup->list_vis[k]->vcoord;
			    	oivis->list_vis[k]->stationindex[0]=oivisDup->list_vis[k]->stationindex[0];
			    	oivis->list_vis[k]->stationindex[1]=oivisDup->list_vis[k]->stationindex[1];
			      }
			    for(k = 0;k<oivisTmp->nbvis;k++)
			      {
			    	oivis->list_vis[k+oivisDup->nbvis]=cpl_malloc(sizeof(mat_viselem));
			    	oivis->list_vis[k+oivisDup->nbvis]->targetid=oivisTmp->list_vis[k]->targetid;
			    	oivis->list_vis[k+oivisDup->nbvis]->time=oivisTmp->list_vis[k]->time;
			    	oivis->list_vis[k+oivisDup->nbvis]->dateobsmjd=oivisTmp->list_vis[k]->dateobsmjd;
			    	oivis->list_vis[k+oivisDup->nbvis]->exptime=oivisTmp->list_vis[k]->exptime;
			    	oivis->list_vis[k+oivisDup->nbvis]->visamp=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k+oivisDup->nbvis]->visamperr=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	/* oivis->list_vis[k+oivisDup->nbvis]->cfxamp=cpl_malloc(oiwave->nbchannel*sizeof(double)); */
			    	/* oivis->list_vis[k+oivisDup->nbvis]->cfxamperr =cpl_malloc(oiwave->nbchannel*sizeof(double)); */
			    	oivis->list_vis[k+oivisDup->nbvis]->visphi=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k+oivisDup->nbvis]->visphierr=cpl_malloc(oiwave->nbchannel*sizeof(double));
			    	oivis->list_vis[k+oivisDup->nbvis]->bandflag=cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
			    	for(j = 0;j<oiwave->nbchannel;j++)
				  {
			    	    oivis->list_vis[k+oivisDup->nbvis]->visamp[j]=oivisTmp->list_vis[k]->visamp[j];
			    	    oivis->list_vis[k+oivisDup->nbvis]->visamperr[j]=oivisTmp->list_vis[k]->visamperr[j];
			    	    /* oivis->list_vis[k+oivisDup->nbvis]->cfxamp[j]=oivisTmp->list_vis[k]->cfxamp[j]; */
			    	    /* oivis->list_vis[k+oivisDup->nbvis]->cfxamperr[j]=oivisTmp->list_vis[k]->cfxamperr[j]; */
			    	    oivis->list_vis[k+oivisDup->nbvis]->visphi[j]=oivisTmp->list_vis[k]->visphi[j];
			    	    oivis->list_vis[k+oivisDup->nbvis]->visphierr[j]=oivisTmp->list_vis[k]->visphierr[j];
			    	    oivis->list_vis[k+oivisDup->nbvis]->bandflag[j]=oivisTmp->list_vis[k]->bandflag[j];
				  }
			    	oivis->list_vis[k+oivisDup->nbvis]->ucoord=oivisTmp->list_vis[k]->ucoord;
			    	oivis->list_vis[k+oivisDup->nbvis]->vcoord=oivisTmp->list_vis[k]->vcoord;
			    	oivis->list_vis[k+oivisDup->nbvis]->stationindex[0]=oivisTmp->list_vis[k]->stationindex[0];
			    	oivis->list_vis[k+oivisDup->nbvis]->stationindex[1]=oivisTmp->list_vis[k]->stationindex[1];
			      }
			    mat_oivis_delete(oivisDup);
			    mat_oivis_delete(oivisTmp);
			  }
		      } else if (strcmp(p_filetag,"RAW_SPECTRUM") == 0)
		      {
				nboispectrum++;

				/*sel_frame	= cpl_frame_duplicate(cur_frame);
			cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
			cpl_frameset_insert(usedframes,sel_frame);*/
			if (oispectrum == NULL)
			  {
			    oispectrum = mat_oispectrum_load(cur_frame);
			    qcflux     = cpl_propertylist_new();
			    plist=cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET1 FLUX IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET1 RATIO IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET1 FLUX JY IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET2 FLUX IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET2 RATIO IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC DET2 FLUX JY IP",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC FLUX",0);
			    cpl_propertylist_copy_property_regexp(qcflux,plist,"ESO QC TOT FLUX",0);
			    cpl_propertylist_delete(plist);
			  }
			else
			  {
			    oispectrumTmp = mat_oispectrum_load(cur_frame);
			    for(k = 0;k<oispectrum->nbflux;k++)
			      {
					  oispectrum->list_flux[k]->time+=oispectrumTmp->list_flux[k]->time;
					  oispectrum->list_flux[k]->dateobsmjd+=oispectrumTmp->list_flux[k]->dateobsmjd;
					  
				for(j =	0;j<oispectrum->nbchannel;j++)
				  {
				    oispectrum->list_flux[k]->fluxdata[j] += oispectrumTmp->list_flux[k]->fluxdata[j];
				    oispectrum->list_flux[k]->fluxerr[j] = 
				      sqrt(pow(oispectrum->list_flux[k]->fluxerr[j],2.0)+
					   pow(oispectrumTmp->list_flux[k]->fluxerr[j],2.0)
					   );
				  }
			      }
			    mat_oispectrum_delete(oispectrumTmp);
			  }
		      }
		  }
		else
		  {
		    printf("file %s ko \n",p_filename);
		  }
	      }
	    if (flag == 0)
	      {
		mat_oitarget_delete(oitargetTempo);
	      }
	    mat_oiwavelength_delete(oiwaveTempo);
	    mat_array_delete(oiarrayTempo);
	  }
	cpl_propertylist_delete(pheader);
      }
  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
  cpl_frameset_iterator_delete(it);
  if (!cpl_errorstate_is_equal(prestate))
    {
      cpl_errorstate_set(prestate);
    }
	
	
  if (oispectrum != NULL)
    {
      for(k = 0;k<oispectrum->nbflux;k++)
	{
	  oispectrum->list_flux[k]->time/=nboispectrum;
	  oispectrum->list_flux[k]->dateobsmjd/=nboispectrum;
	}
    }
		
	
  /* if cumul all blocks */
  // Retrieve parameter
  cumulBlock = cpl_parameterlist_find(parlist,
				      "matisse.mat_merge_results.cumulBlock");
  if ( cpl_parameter_get_bool(cumulBlock) )
    {
      // cumul oitf2
      ///////////////
      cpl_msg_info(cpl_func,"OITF2...");
      if (oitf2 != NULL)
	{
	  // compute number of baselines
	  nbBaseline	  = oitf2->nbtf2;
	  //      for(i = 0;i<oitf2->nbtf2;i++)
	  //{
	  for(i = 0;i<nbtf2Indiv;i++)
	    {
	      for(j =	i+1;j<oitf2->nbtf2;j++)
		{
		  if (oitf2->list_tf2[i]->stationindex[0] == 
		      oitf2->list_tf2[j]->stationindex[0]	&&
		      oitf2->list_tf2[i]->stationindex[1] == 
		      oitf2->list_tf2[j]->stationindex[1])
		    {
		      nbBaseline--;
		    }
		}
	    }
	  nbBlock	  = oitf2->nbtf2/nbBaseline;
	  indexBaseline = cpl_malloc(nbBaseline*nbBlock*sizeof(int));
      
	  for(i = 0;i<nbBaseline;i++)
	    {
	      cpt   =	0;
	      for(j =	0;j<oitf2->nbtf2;j++)
		{
		  if (oitf2->list_tf2[i]->stationindex[0] == 
		      oitf2->list_tf2[j]->stationindex[0]	&&
		      oitf2->list_tf2[i]->stationindex[1] == 
		      oitf2->list_tf2[j]->stationindex[1])
		    {
		      indexBaseline[nbBlock*i+cpt] = j;
		      cpt++;
		    }
		}
	    }
	  // Duplicate oitf2
	  oitf2Dup		= cpl_malloc(sizeof(mat_oitf2));
	  oitf2Dup->dateobs	= NULL;
	  oitf2Dup->arrayname	= NULL;
	  oitf2Dup->insname	= NULL;
	  oitf2Dup->nbtf2=oitf2->nbtf2;
	  oitf2Dup->list_tf2	= cpl_malloc(oitf2Dup->nbtf2*
					     sizeof(mat_tf2elem *));
	  for(k = 0;k<oitf2Dup->nbtf2;k++)
	    {
	      oitf2Dup->list_tf2[k]		  = cpl_malloc(sizeof(mat_tf2elem));
	      oitf2Dup->list_tf2[k]->time	  = oitf2->list_tf2[k]->time;
	      oitf2Dup->list_tf2[k]->dateobsmjd = 
		oitf2->list_tf2[k]->dateobsmjd;
	      oitf2Dup->list_tf2[k]->exptime	  = oitf2->list_tf2[k]->exptime;
	      oitf2Dup->list_tf2[k]->tf2	  = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2Dup->list_tf2[k]->tf2err	  = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2Dup->list_tf2[k]->tf	          = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2Dup->list_tf2[k]->tferr	  = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oitf2Dup->list_tf2[k]->tf2[j]    = oitf2->list_tf2[k]->tf2[j];
		  oitf2Dup->list_tf2[k]->tf2err[j] = oitf2->list_tf2[k]->tf2err[j];
		  oitf2Dup->list_tf2[k]->tf[j]     = oitf2->list_tf2[k]->tf[j];
		  oitf2Dup->list_tf2[k]->tferr[j]  = oitf2->list_tf2[k]->tferr[j];
		}
	      oitf2Dup->list_tf2[k]->stationindex[0] = oitf2->list_tf2[k]->stationindex[0];
	      oitf2Dup->list_tf2[k]->stationindex[1] = oitf2->list_tf2[k]->stationindex[1];
	    }
	  // delete oitf2->list_tf2
	  for(k = 0;k<oitf2->nbtf2;k++)
	    {
	      if(oitf2->list_tf2[k]	   != 0)
		{
		  if(oitf2->list_tf2[k]->tf2 != NULL)
		    {
		      cpl_free(oitf2->list_tf2[k]->tf2);
		    }
		  if(oitf2->list_tf2[k]->tf2err != NULL)
		    {
		      cpl_free(oitf2->list_tf2[k]->tf2err);
		    }
		  if(oitf2->list_tf2[k]->tf != NULL)
		    {
		      cpl_free(oitf2->list_tf2[k]->tf);
		    }
		  if(oitf2->list_tf2[k]->tferr != NULL)
		    {
		      cpl_free(oitf2->list_tf2[k]->tferr);
		    }
		  cpl_free(oitf2->list_tf2[k]);
		}
	    }
	  cpl_free(oitf2->list_tf2);
	  // New oitf2->list_tf2 with cumulated values
	  oitf2->nbtf2 = nbBaseline;
	  oitf2->list_tf2 = cpl_malloc(oitf2->nbtf2*sizeof(mat_tf2elem *));
	  for(k = 0;k<oitf2->nbtf2;k++)
	    {
	      oitf2->list_tf2[k]		    = cpl_malloc(sizeof(mat_tf2elem));
	      oitf2->list_tf2[k]->exptime	    = oitf2Dup->list_tf2[0]->exptime;
	      oitf2->list_tf2[k]->stationindex[0] = oitf2Dup->
		list_tf2[indexBaseline[nbBlock*k]]->stationindex[0];
	      oitf2->list_tf2[k]->stationindex[1] = oitf2Dup->
		list_tf2[indexBaseline[nbBlock*k]]->stationindex[1];
	      oitf2->list_tf2[k]->tf2	   = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2->list_tf2[k]->tf2err = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2->list_tf2[k]->tf	   = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2->list_tf2[k]->tferr    = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oitf2->list_tf2[k]->dateobsmjd = 0.;
	      oitf2->list_tf2[k]->time       = 0.;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oitf2->list_tf2[k]->tf2[j]	  = 0.;
		  oitf2->list_tf2[k]->tf2err[j] = 0.;
		  oitf2->list_tf2[k]->tf[j]	  = 0.;
		  oitf2->list_tf2[k]->tferr[j] = 0.;
		}
	      for(i =	0;i<nbBlock;i++)
		{
		  oitf2->list_tf2[k]->dateobsmjd  += 
		    oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->
		    dateobsmjd;
		  oitf2->list_tf2[k]->time	   += 
		    oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->time;
		  for(j = 0;j<oiwave->nbchannel;j++)
		    {
		      oitf2->list_tf2[k]->tf2[j]    += oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->tf2[j];
		      oitf2->list_tf2[k]->tf2err[j] += pow(oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->tf2err[j],2.0);
		      oitf2->list_tf2[k]->tf[j]     += oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->tf[j];
		      oitf2->list_tf2[k]->tferr[j]  += pow(oitf2Dup->list_tf2[indexBaseline[nbBlock*k+i]]->tferr[j],2.0);
		    }
		}
	      oitf2->list_tf2[k]->dateobsmjd /= nbBlock;
	      oitf2->list_tf2[k]->time       /= nbBlock;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oitf2->list_tf2[k]->tf2[j]	  /= nbBlock;
		  oitf2->list_tf2[k]->tf2err[j]  = sqrt(oitf2->list_tf2[k]->tf2err[j]/nbBlock);
		  oitf2->list_tf2[k]->tf[j]	  /= nbBlock;
		  oitf2->list_tf2[k]->tferr[j]  = sqrt(oitf2->list_tf2[k]->tferr[j]/nbBlock);
		}
	    }
	  mat_oitf2_delete_nt(oitf2Dup);
	  cpl_free(indexBaseline);
	}
      // cumul oivis2
      ///////////////
      cpl_msg_info(cpl_func,"New OIVIS2...");
      if (oivis2 != NULL)
	{
	  // compute number of baselines
	  nbBaseline	  = oivis2->nbvis2;
	  //      for(i = 0;i<oivis2->nbvis2;i++)
	  //{
	  for(i = 0;i<6;i++)
	    {
	      for(j =	i+1;j<oivis2->nbvis2;j++)
		{
		  if (oivis2->list_vis2[i]->stationindex[0] == 
		      oivis2->list_vis2[j]->stationindex[0]	&&
		      oivis2->list_vis2[i]->stationindex[1] == 
		      oivis2->list_vis2[j]->stationindex[1])
		    {
		      nbBaseline--;
		    }
		}
	    }
	  nbBlock	  = oivis2->nbvis2/nbBaseline;
	  indexBaseline = cpl_malloc(nbBaseline*nbBlock*sizeof(int));
	  for(i = 0;i<nbBaseline;i++)
	    {
	      cpt   = 0;
	      for(j =	0;j<oivis2->nbvis2;j++)
		{
		  if (oivis2->list_vis2[i]->stationindex[0] == 
		      oivis2->list_vis2[j]->stationindex[0]	&&
		      oivis2->list_vis2[i]->stationindex[1] == 
		      oivis2->list_vis2[j]->stationindex[1])
		    {
		      indexBaseline[nbBlock*i+cpt] = j;
		      cpt++;
		    }
		}
	    }
	  // Duplicate oivis2
	  oivis2Dup		 = cpl_malloc(sizeof(mat_oivis2));
	  oivis2Dup->dateobs	 = NULL;
	  oivis2Dup->arrayname = NULL;
	  oivis2Dup->insname	 = NULL;
	  oivis2Dup->nbvis2	 = oivis2->nbvis2;
	  oivis2Dup->list_vis2 = cpl_malloc(oivis2Dup->nbvis2*
					    sizeof(mat_vis2elem *));
	  for(k = 0;k<oivis2Dup->nbvis2;k++)
	    {
	      oivis2Dup->list_vis2[k]		  = cpl_malloc(sizeof(mat_vis2elem));
	      oivis2Dup->list_vis2[k]->targetid = oivis2->list_vis2[k]->targetid;
	      oivis2Dup->list_vis2[k]->time	  = oivis2->list_vis2[k]->time;
	      oivis2Dup->list_vis2[k]->dateobsmjd = 
		oivis2->list_vis2[k]->dateobsmjd;
	      oivis2Dup->list_vis2[k]->exptime    = oivis2->list_vis2[k]->exptime;
	
	      oivis2Dup->list_vis2[k]->vis2	 = cpl_malloc(oiwave->nbchannel*
							      sizeof(double));
	      oivis2Dup->list_vis2[k]->vis2err = cpl_malloc(oiwave->nbchannel*
							    sizeof(double));
	
	      /* oivis2Dup->list_vis2[k]->cfx2 = cpl_malloc(oiwave->nbchannel* */
	      /* 					   sizeof(double)); */
	      /* oivis2Dup->list_vis2[k]->cfx2err = cpl_malloc(oiwave->nbchannel* */
	      /* 					      sizeof(double)); */
	
	      oivis2Dup->list_vis2[k]->bandflag = cpl_malloc(oiwave->nbchannel*
							     sizeof(cpl_boolean));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivis2Dup->list_vis2[k]->vis2[j]	= oivis2->list_vis2[k]->vis2[j];
		  oivis2Dup->list_vis2[k]->vis2err[j]	= oivis2->list_vis2[k]->vis2err[j];
	  
		  /* oivis2Dup->list_vis2[k]->cfx2[j]	= oivis2->list_vis2[k]->cfx2[j]; */
		  /* oivis2Dup->list_vis2[k]->cfx2err[j]	= oivis2->list_vis2[k]->cfx2err[j]; */
	  
		  oivis2Dup->list_vis2[k]->bandflag[j] = 
		    oivis2->list_vis2[k]->bandflag[j];
		}
	      oivis2Dup->list_vis2[k]->ucoord		 = oivis2->list_vis2[k]->ucoord;
	      oivis2Dup->list_vis2[k]->vcoord		 = oivis2->list_vis2[k]->vcoord;
	      oivis2Dup->list_vis2[k]->stationindex[0] = 
		oivis2->list_vis2[k]->stationindex[0];
	      oivis2Dup->list_vis2[k]->stationindex[1] = 
		oivis2->list_vis2[k]->stationindex[1];
	    }
	  // delete oivis2->list_vis2
	  for(k = 0;k<oivis2->nbvis2;k++)
	    {
	      mat_vis2elem_delete(oivis2->list_vis2[k]);
	    }
	  cpl_free(oivis2->list_vis2);

	  // New oivis2->list_vis2 with cumulated values
	  oivis2->nbvis2    =	nbBaseline;
	  oivis2->list_vis2 =	cpl_malloc(oivis2->nbvis2*sizeof(mat_vis2elem *));
	  for(k = 0;k<oivis2->nbvis2;k++)
	    {
	      oivis2->list_vis2[k]		      =	cpl_malloc(sizeof(mat_vis2elem));
	      oivis2->list_vis2[k]->targetid	      =	oivis2Dup->list_vis2[k]->targetid;
	      oivis2->list_vis2[k]->exptime	      =	oivis2Dup->list_vis2[0]->exptime;
	      oivis2->list_vis2[k]->stationindex[0] =	oivis2Dup->
		list_vis2[indexBaseline[nbBlock*k]]->stationindex[0];
	      oivis2->list_vis2[k]->stationindex[1] =	oivis2Dup->
		list_vis2[indexBaseline[nbBlock*k]]->stationindex[1];
	
	      oivis2->list_vis2[k]->vis2    =	cpl_malloc(oiwave->nbchannel*
							   sizeof(double));
	      oivis2->list_vis2[k]->vis2err =	cpl_malloc(oiwave->nbchannel*
							   sizeof(double));
	
	      /* oivis2->list_vis2[k]->cfx2    =	cpl_malloc(oiwave->nbchannel* */
	      /* 					   sizeof(double)); */
	      /* oivis2->list_vis2[k]->cfx2err =	cpl_malloc(oiwave->nbchannel* */
	      /* 					   sizeof(double)); */
	
	      oivis2->list_vis2[k]->bandflag	 = cpl_malloc(oiwave->nbchannel*
							      sizeof(cpl_boolean));
	      oivis2->list_vis2[k]->dateobsmjd = 0.;
	      oivis2->list_vis2[k]->time	 = 0.;
	      oivis2->list_vis2[k]->ucoord	 = 0.;
	      oivis2->list_vis2[k]->vcoord	 = 0.;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivis2->list_vis2[k]->vis2[j] = 0.;
		  oivis2->list_vis2[k]->vis2err[j]=0.;
	  
		  /* oivis2->list_vis2[k]->cfx2[j]    = 0.; */
		  /* oivis2->list_vis2[k]->cfx2err[j] = 0.; */
	  
		  oivis2->list_vis2[k]->bandflag[j] =	0.;
		}
	      for(i =	0;i<nbBlock;i++)
		{
		  oivis2->list_vis2[k]->dateobsmjd  +=	
		    oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]]->
		    dateobsmjd;
		  oivis2->list_vis2[k]->time	     +=	
		    oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]]->time;
		  oivis2->list_vis2[k]->ucoord     +=	
		    oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]]->ucoord;
		  oivis2->list_vis2[k]->vcoord     +=	
		    oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]]->vcoord;
		  for(j = 0;j<oiwave->nbchannel;j++)
		    {
		      oivis2->list_vis2[k]->vis2[j]	 += oivis2Dup->
			list_vis2[indexBaseline[nbBlock*k+i]]->vis2[j];
		      oivis2->list_vis2[k]->vis2err[j] += 
			pow(oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]]
			    ->vis2err[j],2.0);
	    
		      /* oivis2->list_vis2[k]->cfx2[j]	 += oivis2Dup-> */
		      /*     list_vis2[indexBaseline[nbBlock*k+i]]->cfx2[j]; */
		      /* oivis2->list_vis2[k]->cfx2err[j] +=  */
		      /*     pow(oivis2Dup->list_vis2[indexBaseline[nbBlock*k+i]] */
		      /* 	->cfx2err[j],2.0); */
	    
		      oivis2->list_vis2[k]->bandflag[j] |= oivis2Dup->
			list_vis2[indexBaseline[nbBlock*k+i]]->bandflag[j];
		    }
		}
	      oivis2->list_vis2[k]->dateobsmjd /= nbBlock;
	      oivis2->list_vis2[k]->time	 /= nbBlock;
	      oivis2->list_vis2[k]->ucoord	 /= nbBlock;
	      oivis2->list_vis2[k]->vcoord/=nbBlock;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivis2->list_vis2[k]->vis2[j] /= nbBlock;
		  oivis2->list_vis2[k]->vis2err[j]  =	
		    sqrt(oivis2->list_vis2[k]->vis2err[j]/nbBlock);
	  
		  /* oivis2->list_vis2[k]->cfx2[j] /= nbBlock; */
		  /* oivis2->list_vis2[k]->cfx2err[j]  =	 */
		  /* 	sqrt(oivis2->list_vis2[k]->cfx2err[j]/nbBlock); */
		}
	    }
	  mat_oivis2_delete(oivis2Dup);
	  cpl_free(indexBaseline);
	}

      // cumul oivis
      ///////////////
      if (oivis != NULL)
	{
	  
	  // compute number of baselines
	  nbBaseline	  = oivis->nbvis;
	  //      for(i = 0;i<oivis->nbvis;i++)
	  //{
	  for(i = 0;i<6;i++)
	    {
	      for(j =	i+1;j<oivis->nbvis;j++)
		{
		  if (oivis->list_vis[i]->stationindex[0] == 
		      oivis->list_vis[j]->stationindex[0]	&&
		      oivis->list_vis[i]->stationindex[1] == 
		      oivis->list_vis[j]->stationindex[1])
		    {
		      nbBaseline--;
		    }
		}
	    }
	  nbBlock	  = oivis->nbvis/nbBaseline;
	  indexBaseline = cpl_malloc(nbBaseline*nbBlock*sizeof(int));
	  for(i = 0;i<nbBaseline;i++)
	    {
	      cpt   =	0;
	      for(j =	0;j<oivis->nbvis;j++)
		{
		  if (oivis->list_vis[i]->stationindex[0] == 
		      oivis->list_vis[j]->stationindex[0]	&&
		      oivis->list_vis[i]->stationindex[1] == 
		      oivis->list_vis[j]->stationindex[1])
		    {
		      indexBaseline[nbBlock*i+cpt] = j;
		      cpt++;
		    }
		}
	    }
	  cpl_msg_info(cpl_func,"OIVIS Merging 2...");
	  // Duplicate oivis
	  oivisDup		= cpl_malloc(sizeof(mat_oivis));
	  oivisDup->dateobs	= NULL;
	  oivisDup->arrayname	= NULL;
	  oivisDup->insname	= NULL;
	  oivisDup->amptyp	= NULL;
	  oivisDup->phityp	= NULL;
	  oivisDup->nbvis	= oivis->nbvis;
	  oivisDup->list_vis	= cpl_malloc(oivisDup->nbvis*
					     sizeof(mat_viselem *));
	  for(k = 0;k<oivisDup->nbvis;k++)
	    {
	      oivisDup->list_vis[k]		  = cpl_malloc(sizeof(mat_viselem));
	      oivisDup->list_vis[k]->targetid	  = oivis->list_vis[k]->targetid;
	      oivisDup->list_vis[k]->time	  = oivis->list_vis[k]->time;
	      oivisDup->list_vis[k]->dateobsmjd = oivis->list_vis[k]->dateobsmjd;
	      oivisDup->list_vis[k]->exptime = oivis->list_vis[k]->exptime;
	
	      oivisDup->list_vis[k]->visamp = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivisDup->list_vis[k]->visamperr = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivisDup->list_vis[k]->visphi	 = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivisDup->list_vis[k]->visphierr = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivisDup->list_vis[k]->bandflag	 = cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivisDup->list_vis[k]->visamp[j]	= oivis->list_vis[k]->visamp[j];
		  oivisDup->list_vis[k]->visamperr[j] = pow(oivis->list_vis[k]->visamperr[j],2.0);
		  oivisDup->list_vis[k]->visphi[j]	= oivis->list_vis[k]->visphi[j];
		  oivisDup->list_vis[k]->visphierr[j]	= pow(oivis->list_vis[k]->visphierr[j],2.0);
		  oivisDup->list_vis[k]->bandflag[j]	= oivis->list_vis[k]->bandflag[j];
		}
	      oivisDup->list_vis[k]->ucoord = oivis->list_vis[k]->ucoord;
	      oivisDup->list_vis[k]->vcoord = oivis->list_vis[k]->vcoord;
	      oivisDup->list_vis[k]->stationindex[0] = oivis->list_vis[k]->stationindex[0];
	      oivisDup->list_vis[k]->stationindex[1] = oivis->list_vis[k]->stationindex[1];
	    }
	  // delete oivis->list_vis
	  for(k = 0;k<oivis->nbvis;k++)
	    {
	      mat_viselem_delete(oivis->list_vis[k]);
	    }
	  cpl_free(oivis->list_vis);
	    
	  // New oivis->list_vis with cumulated values
	  oivis->nbvis    = nbBaseline;
	  oivis->list_vis = cpl_malloc(oivis->nbvis*sizeof(mat_viselem *));
	  for(k = 0;k<oivis->nbvis;k++)
	    {
	      oivis->list_vis[k]		    = cpl_malloc(sizeof(mat_viselem));
	      oivis->list_vis[k]->targetid	    = oivisDup->list_vis[k]->targetid;
	      oivis->list_vis[k]->exptime	    = oivisDup->list_vis[0]->exptime;
	      oivis->list_vis[k]->stationindex[0] = oivisDup->list_vis[indexBaseline[nbBlock*k]]->stationindex[0];
	      oivis->list_vis[k]->stationindex[1] = oivisDup->list_vis[indexBaseline[nbBlock*k]]->stationindex[1];
	
	      oivis->list_vis[k]->visamp    = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivis->list_vis[k]->visamperr = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivis->list_vis[k]->visphi    = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivis->list_vis[k]->visphierr = cpl_malloc(oiwave->nbchannel*sizeof(double));
	      oivis->list_vis[k]->bandflag  = cpl_malloc(oiwave->nbchannel*sizeof(cpl_boolean));
	      oivis->list_vis[k]->dateobsmjd = 0.;
	      oivis->list_vis[k]->time       = 0.;
	      oivis->list_vis[k]->ucoord     = 0.;
	      oivis->list_vis[k]->vcoord     = 0.;
	      phasorRe=cpl_malloc(oiwave->nbchannel*sizeof(double));
	      phasorIm=cpl_malloc(oiwave->nbchannel*sizeof(double));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivis->list_vis[k]->visamp[j]    = 0.;
		  oivis->list_vis[k]->visamperr[j] = 0.;
		  oivis->list_vis[k]->visphi[j]    = 0.;
		  oivis->list_vis[k]->visphierr[j] = 0.;
		  oivis->list_vis[k]->bandflag[j]  = 0.;
		  phasorRe[j]=0.;
		  phasorIm[j]=0.;
		}
	      for(i=0;i<nbBlock;i++)
		{
		  oivis->list_vis[k]->dateobsmjd+=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->dateobsmjd;
		  oivis->list_vis[k]->time+=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->time;
		  oivis->list_vis[k]->ucoord+=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->ucoord;
		  oivis->list_vis[k]->vcoord+= oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->vcoord;
		  for(j = 0;j<oiwave->nbchannel;j++)
		    {
		      oivis->list_vis[k]->visamp[j]+= oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->visamp[j];
		      oivis->list_vis[k]->visamperr[j]+=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->visamperr[j];
		      phasorRe[j] += cos(oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->visphi[j]*M_PI/180.);
		      phasorIm[j] += sin(oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->visphi[j]*M_PI/180.);
		      oivis->list_vis[k]->visphierr[j]+=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->visphierr[j];
		      oivis->list_vis[k]->bandflag[j]|=oivisDup->list_vis[indexBaseline[nbBlock*k+i]]->bandflag[j];
		    }
		}
	      oivis->list_vis[k]->dateobsmjd /= nbBlock;
	      oivis->list_vis[k]->time       /= nbBlock;
	      oivis->list_vis[k]->ucoord     /= nbBlock;
	      oivis->list_vis[k]->vcoord     /= nbBlock;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oivis->list_vis[k]->visamp[j]/=nbBlock;
		  oivis->list_vis[k]->visamperr[j]=sqrt(oivis->list_vis[k]->visamperr[j]/nbBlock);
		  oivis->list_vis[k]->visphi[j]=(180./M_PI)*atan2(phasorIm[j],phasorRe[j]);
		  oivis->list_vis[k]->visphierr[j]=sqrt(oivis->list_vis[k]->visphierr[j]/nbBlock);
		}
	      cpl_free(phasorRe);
	      cpl_free(phasorIm);
	    }
	  mat_oivis_delete(oivisDup);
	  cpl_free(indexBaseline);
	}

      // cumul oit3
      /////////////
      if (oit3 != NULL)
	{
	  // compute number of triplets
	  nbTriplet	  = oit3->nbt3;
	  //      for(i = 0;i<oit3->nbt3;i++)
	  //{
	  for(i = 0;i<4;i++)
	    {
	      for(j =	i+1;j<oit3->nbt3;j++)
		{
		  if (oit3->list_t3[i]->stationindex[0] == 
		      oit3->list_t3[j]->stationindex[0]	&&
		      oit3->list_t3[i]->stationindex[1] == 
		      oit3->list_t3[j]->stationindex[1]	&&
		      oit3->list_t3[i]->stationindex[2] == 
		      oit3->list_t3[j]->stationindex[2] )
		    {
		      nbTriplet--;
		    }
		}
	    }
	  nbBlock	 = oit3->nbt3/nbTriplet;
	  indexTriplet = cpl_malloc(nbTriplet*nbBlock*sizeof(int));
	  for(i = 0;i<nbTriplet;i++)
	    {
	      cpt = 0;
	      for(j =	0;j<oit3->nbt3;j++)
		{
		  if (oit3->list_t3[i]->stationindex[0] == 
		      oit3->list_t3[j]->stationindex[0]	&&
		      oit3->list_t3[i]->stationindex[1] == 
		      oit3->list_t3[j]->stationindex[1]	&&
		      oit3->list_t3[i]->stationindex[2] == 
		      oit3->list_t3[j]->stationindex[2])
		    {
		      indexTriplet[nbBlock*i+cpt] = j;
		      cpt++;
		    }
		}
	    }
	  cpl_msg_info(cpl_func,"T3 Merging...");
	  // Duplicate oit3
	  oit3Dup	     = cpl_malloc(sizeof(mat_oit3));
	  oit3Dup->dateobs   = NULL;
	  oit3Dup->arrayname = NULL;
	  oit3Dup->insname   = NULL;
	  oit3Dup->nbt3      = oit3->nbt3;
	  oit3Dup->list_t3   = cpl_malloc(oit3Dup->nbt3*
					  sizeof(mat_t3elem *));
	  for(k = 0;k<oit3Dup->nbt3;k++)
	    {
	      oit3Dup->list_t3[k]		= cpl_malloc(sizeof(mat_t3elem));
	      oit3Dup->list_t3[k]->targetid	= oit3->list_t3[k]->targetid;
	      oit3Dup->list_t3[k]->time	= oit3->list_t3[k]->time;
	      oit3Dup->list_t3[k]->dateobsmjd	= 
		oit3->list_t3[k]->dateobsmjd;
	      oit3Dup->list_t3[k]->exptime	= oit3->list_t3[k]->exptime;
	      oit3Dup->list_t3[k]->t3amp	= cpl_malloc(oiwave->nbchannel*
							     sizeof(double));
	      oit3Dup->list_t3[k]->t3amperr	= cpl_malloc(oiwave->nbchannel*
							     sizeof(double));
	      oit3Dup->list_t3[k]->t3phi	= cpl_malloc(oiwave->nbchannel*
							     sizeof(double));
	      oit3Dup->list_t3[k]->t3phierr	= cpl_malloc(oiwave->nbchannel*
							     sizeof(double));
	      oit3Dup->list_t3[k]->bandflag	= cpl_malloc(oiwave->nbchannel*
							     sizeof(cpl_boolean));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oit3Dup->list_t3[k]->t3amp[j]    = oit3->list_t3[k]->t3amp[j];
		  oit3Dup->list_t3[k]->t3amperr[j] = 
		    pow(oit3->list_t3[k]->t3amperr[j],2.0);
		  oit3Dup->list_t3[k]->t3phi[j]    = oit3->list_t3[k]->t3phi[j];
		  oit3Dup->list_t3[k]->t3phierr[j] = 
		    pow(oit3->list_t3[k]->t3phierr[j],2.0);
		  oit3Dup->list_t3[k]->bandflag[j] = 
		    oit3->list_t3[k]->bandflag[j];
		}
	      oit3Dup->list_t3[k]->u1coord	     = oit3->list_t3[k]->u1coord;
	      oit3Dup->list_t3[k]->u2coord	     = oit3->list_t3[k]->u2coord;
	      oit3Dup->list_t3[k]->v1coord	     = oit3->list_t3[k]->v1coord;
	      oit3Dup->list_t3[k]->v2coord	     = oit3->list_t3[k]->v2coord;
	      oit3Dup->list_t3[k]->stationindex[0] = 
		oit3->list_t3[k]->stationindex[0];
	      oit3Dup->list_t3[k]->stationindex[1] = 
		oit3->list_t3[k]->stationindex[1];
	      oit3Dup->list_t3[k]->stationindex[2] = 
		oit3->list_t3[k]->stationindex[2];
	    }
	  // delete oit3->list_t3
	  for(k = 0;k<oit3->nbt3;k++)
	    {
	      mat_t3elem_delete(oit3->list_t3[k]);
	    }
	  cpl_free(oit3->list_t3);
	    
	  // New oit3->list_t3 with cumulated values
	  oit3->nbt3	  = nbTriplet;
	  oit3->list_t3 = cpl_malloc(oit3->nbt3*sizeof(mat_t3elem *));
	  for(k = 0;k<oit3->nbt3;k++)
	    {
	      oit3->list_t3[k]	   = cpl_malloc(sizeof(mat_t3elem));
	      oit3->list_t3[k]->targetid = oit3Dup->list_t3[k]->targetid;
	      oit3->list_t3[k]->exptime  = oit3Dup->list_t3[0]->exptime;
	      oit3->list_t3[k]->stationindex[0] = oit3Dup->
		list_t3[indexTriplet[nbBlock*k]]->stationindex[0];
	      oit3->list_t3[k]->stationindex[1] = oit3Dup->
		list_t3[indexTriplet[nbBlock*k]]->stationindex[1];
	      oit3->list_t3[k]->stationindex[2] = oit3Dup->
		list_t3[indexTriplet[nbBlock*k]]->stationindex[2];
	      oit3->list_t3[k]->t3amp	   = cpl_malloc(oiwave->nbchannel*
							sizeof(double));
	      oit3->list_t3[k]->t3amperr = cpl_malloc(oiwave->nbchannel*
						      sizeof(double));
	      oit3->list_t3[k]->t3phi	   = cpl_malloc(oiwave->nbchannel*
							sizeof(double));
	      oit3->list_t3[k]->t3phierr = cpl_malloc(oiwave->nbchannel*
						      sizeof(double));
	      oit3->list_t3[k]->bandflag=cpl_malloc(oiwave->nbchannel*
						    sizeof(cpl_boolean));
	      oit3->list_t3[k]->dateobsmjd = 0.;
	      oit3->list_t3[k]->time	     = 0.;
	      oit3->list_t3[k]->u1coord    = 0.;
	      oit3->list_t3[k]->v1coord    = 0.;
	      oit3->list_t3[k]->u2coord    = 0.;
	      oit3->list_t3[k]->v2coord    = 0.;
	      phasorRe=cpl_malloc(oiwave->nbchannel*sizeof(double));
	      phasorIm=cpl_malloc(oiwave->nbchannel*sizeof(double));
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oit3->list_t3[k]->t3amp[j]	  = 0.;
		  oit3->list_t3[k]->t3amperr[j] = 0.;
		  oit3->list_t3[k]->t3phi[j]	  = 0.;
		  oit3->list_t3[k]->t3phierr[j] = 0.;
		  oit3->list_t3[k]->bandflag[j] = 0.;
		  phasorRe[j] = 0.;
		  phasorIm[j] = 0.;
		}
	      for(i=0;i<nbBlock;i++)
		{
		  oit3->list_t3[k]->dateobsmjd  += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->
		    dateobsmjd;
		  oit3->list_t3[k]->time	 += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->time;
		  oit3->list_t3[k]->u1coord	 += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->u1coord;
		  oit3->list_t3[k]->v1coord	 += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->v1coord;
		  oit3->list_t3[k]->u2coord	 += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->u2coord;
		  oit3->list_t3[k]->v2coord	 += 
		    oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->v2coord;
		  for(j = 0;j<oiwave->nbchannel;j++)
		    {
		      oit3->list_t3[k]->t3amp[j]    += oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3amp[j];
		      oit3->list_t3[k]->t3amperr[j] += oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3amperr[j];
		      phasorRe[j] += cos(oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3phi[j]*M_PI/180.);
		      phasorIm[j] += sin(oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3phi[j]*M_PI/180.);
		      
		      //oit3->list_t3[k]->t3phi[j]    += oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3phi[j];
		      oit3->list_t3[k]->t3phierr[j] += oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->t3phierr[j];
		      oit3->list_t3[k]->bandflag[j] |= oit3Dup->list_t3[indexTriplet[nbBlock*k+i]]->bandflag[j];
		    }
		}
	      oit3->list_t3[k]->dateobsmjd /=	nbBlock;
	      oit3->list_t3[k]->time	     /=	nbBlock;
	      oit3->list_t3[k]->u1coord    /=	nbBlock;
	      oit3->list_t3[k]->v1coord    /=	nbBlock;
	      oit3->list_t3[k]->u2coord    /=	nbBlock;
	      oit3->list_t3[k]->v2coord    /=	nbBlock;
	      for(j = 0;j<oiwave->nbchannel;j++)
		{
		  oit3->list_t3[k]->t3amp[j]/= nbBlock;
		  oit3->list_t3[k]->t3amperr[j]=sqrt(oit3->list_t3[k]->t3amperr[j]/nbBlock);
		  oit3->list_t3[k]->t3phi[j]=(180./M_PI)*atan2(phasorIm[j],phasorRe[j]);
		  //oit3->list_t3[k]->t3phi[j]/=nbBlock;
		  oit3->list_t3[k]->t3phierr[j]=sqrt(oit3->list_t3[k]->t3phierr[j]/nbBlock);
		}
	      cpl_free(phasorRe);
	      cpl_free(phasorIm);
	    }
	  mat_oit3_delete(oit3Dup);
	  cpl_free(indexTriplet);
	}	
    }

  /* 3. Store this structure in a mat_oifits structure */
  if (cpl_frameset_find(frameset,"CALIB_RAW") != NULL ||
      cpl_frameset_find(frameset,"TARGET_RAW") != NULL ||
      cpl_frameset_find(frameset,"CALIB_SRC_RAW") != NULL)
    {
      usedframes=cpl_frameset_new();
      it= cpl_frameset_iterator_new(frameset);

      do {
	cur_frame = cpl_frameset_iterator_get(it);
	if (cur_frame != NULL)
	  {
	    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
	    pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
	    if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0)
	      {
		plist=cpl_propertylist_load(pszFileName,0);
		if (cpl_parameter_get_int(parbcdMode)==0)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==2)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==3)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==1)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if (cpl_parameter_get_int(parbcdMode)==4)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==6)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==7)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==5)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	    if (strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
	      {
		plist=cpl_propertylist_load(pszFileName,0);
		if (cpl_parameter_get_int(parbcdMode)==0)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==2)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==3)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==1)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if (cpl_parameter_get_int(parbcdMode)==4)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==6)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==7)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==5)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") == 0 &&
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") == 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	  }
      } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
      cpl_frameset_iterator_delete(it);
      it= cpl_frameset_iterator_new(frameset);
      do {
	cur_frame = cpl_frameset_iterator_get(it);
	if (cur_frame != NULL)
	  {
	    pszFileName = (char*)cpl_frame_get_filename( cur_frame );
	    pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
	    if (strcmp(pszFileTag, "CALIB_RAW") == 0 || strcmp(pszFileTag, "TARGET_RAW") == 0)
	      {
		plist=cpl_propertylist_load(pszFileName,0);
		if (cpl_parameter_get_int(parbcdMode)==0)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==2)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==3)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==1)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"F") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if (cpl_parameter_get_int(parbcdMode)==4)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==6)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==7)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==5)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO ISS CHOP ST"),"T") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	    else if (strcmp(pszFileTag, "CALIB_SRC_RAW") == 0)
	      {
		plist=cpl_propertylist_load(pszFileName,0);
		if (cpl_parameter_get_int(parbcdMode)==0)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==2)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==3)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==1)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if (cpl_parameter_get_int(parbcdMode)==4)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==6)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"OUT") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==7)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"OUT") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		else if(cpl_parameter_get_int(parbcdMode)==5)
		  {
		    if (strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD1 NAME"),"IN") != 0 ||
			strcmp(cpl_propertylist_get_string(plist,"ESO INS BCD2 NAME"),"IN") != 0 )
		      {
			sel_frame=cpl_frame_duplicate(cur_frame);
			cpl_frameset_insert(usedframes,sel_frame);
		      }
		  }
		cpl_propertylist_delete(plist);
	      }
	    else if (strcmp(pszFileTag, "BADPIX") == 0 || strcmp(pszFileTag, "NONLINEARITY") == 0 ||
		     strcmp(pszFileTag, "SHIFT_MAP") == 0 || strcmp(pszFileTag, "KAPPA_MATRIX") == 0 ||
		     strcmp(pszFileTag, "OBS_FLATFIELD") == 0 || strcmp(pszFileTag, "JSDC_CAT") == 0 ||
		     strcmp(pszFileTag, "RMNREC") == 0)
	      {
		sel_frame=cpl_frame_duplicate(cur_frame);
		cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_CALIB);
		cpl_frameset_insert(usedframes,sel_frame);
	      }
		       
	  }
      } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
      cpl_frameset_iterator_delete(it);
	it= cpl_frameset_iterator_new(frameset);
	do
	  {
	    cur_frame = cpl_frameset_iterator_get(it);
	    if (cur_frame != NULL)
	      {
		pszFileName = (char*)cpl_frame_get_filename( cur_frame );
		pszFileTag = (char *)cpl_frame_get_tag( cur_frame );
		if (strcmp(pszFileTag, "SKY_RAW") == 0 || strcmp(pszFileTag, "HOT_DARK") == 0 )
		  {
		    sel_frame=cpl_frame_duplicate(cur_frame);
		    cpl_frameset_insert(usedframes,sel_frame);
		  }
	      }
	  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
	cpl_frameset_iterator_delete(it);
    }
  else
    {
      usedframes=cpl_frameset_duplicate(frameset);
      it= cpl_frameset_iterator_new(usedframes);
      do {
	cur_frame = cpl_frameset_iterator_get(it);
	cpl_frame_set_group(cur_frame,CPL_FRAME_GROUP_RAW);
       } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
      cpl_frameset_iterator_delete(it);
    }

  it= cpl_frameset_iterator_new(usedframes);
  cur_frame = cpl_frameset_iterator_get(it);
  cpl_frameset_iterator_delete(it);
  if (flagScal == 0)
    {
      oifits = cpl_malloc(sizeof(mat_oifits));
      oifits->keywords = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
      cpl_propertylist_erase_regexp(oifits->keywords,"ESO QC",0);
      cpl_propertylist_append(oifits->keywords,qctf2);
      cpl_propertylist_append(oifits->keywords,qcvis2);
      cpl_propertylist_append(oifits->keywords,qct3);
      cpl_propertylist_append(oifits->keywords,qcvis);
      cpl_propertylist_append(oifits->keywords,qcflux);
      if (keycal != NULL)
	{
	  cpl_propertylist_append(oifits->keywords,keycal);	  
	}
      oifits->nbarray	= 0;
      oifits->nbwave	= 0;
      oifits->nbtupel	= 0;
      oifits->nbspect	= 0;
      oifits->array_list = NULL;
      oifits->wave_list  = NULL;
      oifits->spect_list = NULL;
      oifits->tupel_list = NULL;
      oifits->array	 = oiarray;
      oifits->oitarget   = oitarget;
      oifits->oiwave	 = oiwave;
      oifits->oivis	 = oivis;
      oifits->oivis2	 = oivis2;
      oifits->oitf2	 = NULL;
      oifits->oit3	 = oit3;
      oifits->oispect	 = oispectrum;


      if (mode == 5)
	{
	  if (flagbcdSel == 2)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0001.fits");
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","OUT-OUT");
	    }
	  if (flagbcdSel == 3)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0002.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","IN-IN");
	    }
	  if (flagbcdSel == 4)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0003.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","IN-OUT");
	    }
	  if (flagbcdSel == 5)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0004.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","OUT-IN");
	    }
	  if (flagbcdSel == 6)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0005.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","OUT-OUT");
	    }
	  if (flagbcdSel == 7)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0006.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","IN-IN");
	    }
	  if (flagbcdSel == 8)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0007.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","IN-OUT");
	    }
	  if (flagbcdSel == 9)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0008.fits");  
	      cpl_propertylist_append_string(oifits->keywords,"ESO CFG BCD MODE","OUT-IN");
	    }
	  if (flagbcdSel == 1)
	    {
	      output=cpl_sprintf("TARGET_RAW_INT_0010.fits");  
	    }
	}
      if (mode == 9)
	{
	  if (flagbcdSel == 2)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0001.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 3)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0002.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 4)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0003.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 5)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0004.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 6)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0005.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 7)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0006.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 8)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0007.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 9)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0008.fits");  
	      cpl_propertylist_append_bool(oifits->keywords, "ESO DRS BCD COMBINED", 0);
	    }
	  if (flagbcdSel == 1)
	    {
	      output=cpl_sprintf("TARGET_CAL_INT_0010.fits");  
	    }
	}



      if (flagbcdSel > 0)
	{
	  cpl_msg_info(cpl_func,"Number of keywords PRO.REC erased = %d",cpl_propertylist_erase_regexp(oifits->keywords,"PRO REC",0));
	  cpl_msg_info(cpl_func,"Number of keywords PRO.DATANCOM erased = %d",cpl_propertylist_erase_regexp(oifits->keywords,"PRO DATANCOM",0));

	  /*      it = cpl_frameset_iterator_new(frameset);
		  do {
		  cur_frame  = cpl_frameset_iterator_get(it);
		  if (cur_frame != NULL)
		  {
		  p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
		  if ( strcmp(p_filetag,"SKY_RAW")     == 0	||
		  strcmp(p_filetag,"TARGET_RAW")   == 0	||
		  strcmp(p_filetag,"CALIB_RAW")   == 0	||
		  strcmp(p_filetag,"HOT_DARK") == 0 )
		  {
		  sel_frame = cpl_frame_duplicate(cur_frame);
		  cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
		  cpl_frameset_insert(usedframes,sel_frame);
		  }

		  if ( strcmp(p_filetag,"BADPIX")     == 0	||
		  strcmp(p_filetag,"SHIFT_MAP")   == 0	||
		  strcmp(p_filetag,"JSDC_CAT")   == 0	||
		  strcmp(p_filetag,"OBS_FLATFIELD") == 0 	||
		  strcmp(p_filetag,"NONLINEARITY") == 0  	||
		  strcmp(p_filetag,"KAPPA_MATRIX") == 0 )
		  {
		  sel_frame = cpl_frame_duplicate(cur_frame);
		  cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_CALIB);
		  cpl_frameset_insert(usedframes,sel_frame);
		  }
		  }
		  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		  cpl_frameset_iterator_delete(it);*/


	  if (strcmp(recname,"mat_raw_estimates") == 0)
	    {
	      int npar=cpl_parameterlist_get_size(parlist);
	      cpl_parameterlist *partmp=NULL;
	      cpl_parameter *parcur=NULL;
	      partmp=cpl_parameterlist_new();
	      parcur=cpl_parameterlist_get_first(parlist);
	      for(int ipar=0; ipar<npar-1; ipar++)
		{
		  if (parcur != NULL)
		    {
		      cpl_parameterlist_append(partmp,parcur);
		    } 
		  parcur=cpl_parameterlist_get_next(parlist);
		}

	      
	      mat_add_qc_raw_estimates(oifits->keywords,parlist);
	      cpl_propertylist_append_double(oifits->keywords,"ESO QC MAX OPD",opdmax);

	      mat_oifits_save(oifits, frameset, usedframes ,  partmp, recname, output, mode);
	    }
	  else
	    {
	      mat_oifits_save(oifits, frameset, usedframes ,  parlist, recname, output, mode);
	    }
	  cpl_free(output);
	}
      mat_oifits_delete(oifits);
    }
  else
    {
      oifitscal	    = cpl_malloc(sizeof(mat_oifits));
      oifitscal->keywords = cpl_propertylist_load(cpl_frame_get_filename(cur_frame),0);
      cpl_propertylist_erase_regexp(oifitscal->keywords,"ESO QC",0);
      cpl_propertylist_append(oifitscal->keywords,qctf2);
      if (plist_jsdc != NULL)
	{
	  cpl_propertylist_append(oifitscal->keywords,plist_jsdc);
	} 
      cpl_propertylist_append(oifitscal->keywords,qcvis2);
      cpl_propertylist_append(oifitscal->keywords,qct3);
      cpl_propertylist_append(oifitscal->keywords,qcvis);
      cpl_propertylist_append(oifitscal->keywords,qcflux);
      oifitscal->nbarray = 0;
      oifitscal->nbwave  = 0;
      oifitscal->nbtupel = 0;
      oifitscal->nbspect = 0;
      oifitscal->array_list =	NULL;
      oifitscal->wave_list  =	NULL;
      oifitscal->spect_list =	NULL;
      oifitscal->tupel_list =	NULL;
      oifitscal->array    = oiarray;
      oifitscal->oitarget = oitarget;
      oifitscal->oiwave = oiwave;
      oifitscal->oivis  = oivis;
      oifitscal->oivis2 = oivis2;
      oifitscal->oitf2  = oitf2;
      oifitscal->oit3	  = oit3;
      oifitscal->oispect  = oispectrum;

      if (flagbcdSel == 2)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0001.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","OUT-OUT");
	}
      if (flagbcdSel == 3)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0002.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","IN-IN");
	}
      if (flagbcdSel == 4)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0003.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","IN-OUT");
	}
      if (flagbcdSel == 5)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0004.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","OUT-IN");
	}
      if (flagbcdSel == 6)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0005.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","OUT-OUT");
	}
      if (flagbcdSel == 7)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0006.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","IN-IN");
	}
      if (flagbcdSel == 8)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0007.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","IN-OUT");
	}
      if (flagbcdSel == 9)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0008.fits");  
	  cpl_propertylist_append_string(oifitscal->keywords,"ESO CFG BCD MODE","OUT-IN");
	}
      if (flagbcdSel == 1)
	{
	  output=cpl_sprintf("CALIB_RAW_INT_0010.fits");  
	}



      if (flagbcdSel > 0)
	{
	  cpl_msg_info(cpl_func,"Number of keywords PRO.REC erased = %d",cpl_propertylist_erase_regexp(oifitscal->keywords,"PRO REC",0));
	  cpl_msg_info(cpl_func,"Number of keywords PRO.DATANCOM erased = %d",cpl_propertylist_erase_regexp(oifitscal->keywords,"PRO DATANCOM",0));

	  /*      it = cpl_frameset_iterator_new(frameset);
		  do {
		  cur_frame  = cpl_frameset_iterator_get(it);
		  if (cur_frame != NULL)
		  {
		  p_filetag  = (char *)cpl_frame_get_tag(cur_frame);
		  if ( strcmp(p_filetag,"SKY_RAW")     == 0	||
		  strcmp(p_filetag,"TARGET_RAW")   == 0	||
		  strcmp(p_filetag,"CALIB_RAW")   == 0	||
		  strcmp(p_filetag,"HOT_DARK") == 0 )
		  {
		  sel_frame = cpl_frame_duplicate(cur_frame);
		  cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_RAW);
		  cpl_frameset_insert(usedframes,sel_frame);
		  }

		  if ( strcmp(p_filetag,"BADPIX")     == 0	||
		  strcmp(p_filetag,"SHIFT_MAP")   == 0	||
		  strcmp(p_filetag,"JSDC_CAT")   == 0	||
		  strcmp(p_filetag,"OBS_FLATFIELD") == 0 	||
		  strcmp(p_filetag,"NONLINEARITY") == 0  	||
		  strcmp(p_filetag,"KAPPA_MATRIX") == 0 )
		  {
		  sel_frame = cpl_frame_duplicate(cur_frame);
		  cpl_frame_set_group(sel_frame,CPL_FRAME_GROUP_CALIB);
		  cpl_frameset_insert(usedframes,sel_frame);
		  }
		  }
		  } while (cpl_frameset_iterator_advance(it, 1) != CPL_ERROR_ACCESS_OUT_OF_RANGE);
		  cpl_frameset_iterator_delete(it); */ 
	  if (strcmp(recname,"mat_raw_estimates") == 0)
	    {
	      int npar=cpl_parameterlist_get_size(parlist);
	      cpl_parameterlist *partmp=NULL;
	      cpl_parameter *parcur=NULL;
	      partmp=cpl_parameterlist_new();
	      parcur=cpl_parameter_duplicate(cpl_parameterlist_get_first(parlist));
	      for(int ipar=0; ipar<npar-1; ipar++)
	  	{
	  	  if (parcur != NULL)
	  	    {
	  	      cpl_parameterlist_append(partmp,parcur);
	  	    }
	  	  parcur=cpl_parameter_duplicate(cpl_parameterlist_get_next(parlist));
	  	}
	      mat_add_qc_raw_estimates(oifitscal->keywords,parlist);
	      cpl_propertylist_append_double(oifitscal->keywords,"ESO QC MAX OPD",opdmax);
	      mat_oifits_save(oifitscal, frameset, usedframes ,  partmp, recname, output, 11);
	      cpl_parameterlist_delete(partmp);
	    }
	  else
	    {
	      mat_oifits_save(oifitscal, frameset, usedframes ,  parlist, recname, output, 11);
	    }
	  cpl_free(output);
	}
      mat_oifits_delete(oifitscal);
    }

  cpl_propertylist_delete(qctf2);
  cpl_propertylist_delete(qcvis2);
  cpl_propertylist_delete(qct3);
  cpl_propertylist_delete(qcvis);
  cpl_propertylist_delete(qcflux);
  if (plist_jsdc != NULL)
    {
      cpl_propertylist_delete(plist_jsdc);
    } 
  cpl_frameset_delete(usedframes);
  return 0;
}
