 /* $Id: mat_oitarget.h,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oitarget.h $
 */

#ifndef MAT_OITARGET_H
#define MAT_OITARGET_H

/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "cpl.h"

/*-----------------------------------------------------------------------------
  Defines
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Low Level Structures
  ----------------------------------------------------------------------------*/

/* Structure mat_oitarget */
/**
   @ingroup oitar
   @brief Structure containing on target from a OI_TARGET binary table.

   This data structure represents the first entry of an OI_TARGET binary table. The MATISSE
   repesentation of an OI-FITS file uses only the first target. If more targets are stored in
   an OI_TARGET binary table, the MATISSE OI-FITS file handling methods will not work properly!
*/
typedef struct {
    int        targetid;     /*!< Unique index number for a target (always 1 for MATISSE OI-FITS files). */
    char       *targetname;  /*!< The target name. */
    double     equinox;      /*!< Equinox */
    double     raep0;        /*!< Right ascension at mean equinox in degrees. */
    double     decep0;       /*!< Declination ascension at mean equinox in degrees. */
    double     raerr;        /*!< Error in R.A. at mean equinox in degrees. */
    double     decerr;       /*!< Error in Decl. at mean equinox in degrees. */
    double     sysvel;       /*!< Systemic radial velocity in meter per second. */
    char       *veltyp;      /*!< Reference for radial velocity ("LSR", "GEOCENTER", etc.). */
    char       *veldef;      /*!< Definition of radial velocity ("OPTICAL", "RADIO"). */
    double     pmra;         /*!< Proper motion in R.A. in degree per year. */
    double     pmdec;        /*!< Proper motion in Decl. in degree per year. */
    double     pmraerr;      /*!< Error of proper motion in R.A. in degree per year. */
    double     pmdecerr;     /*!< Error of proper motion in Decl. in degree per year. */
    double     parallax;     /*!< Parallax in degree. */
    double     paraerr;      /*!< Error in parallax in degree. */
    char       *spectyp;     /*!< Spectral type. */
    char       *category;    /*!< Target category (SCI or CAL). */
} mat_oitarget;

/*-----------------------------------------------------------------------------
  High Level Structures
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/
mat_oitarget *mat_oitarget_new(void);

cpl_error_code mat_oitarget_delete(mat_oitarget *oitarget);

mat_oitarget *mat_oitarget_from_table(cpl_propertylist *plist,
				      cpl_table *table);

cpl_table *mat_oitarget_to_table(mat_oitarget *oitarget,
				 cpl_propertylist *plist);

mat_oitarget *mat_oitarget_load(cpl_frame *frame);

cpl_error_code  mat_oitarget_append(char *filename, mat_oitarget *oitarget);

cpl_boolean  mat_oitarget_compare(mat_oitarget *oitarget1, 
				  mat_oitarget *oitarget2);


#endif
