/* $Id: mat_oitf2.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oitf2.h $
 */

#ifndef MAT_OITF2_H
#define MAT_OITF2_H

/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "cpl.h"

/*-----------------------------------------------------------------------------
  Defines
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Low Level Structures
  ----------------------------------------------------------------------------*/

/**
   @ingroup oitf2
   @brief Structure mat_tf2elem
*/
typedef struct {
    double         time;                  /* UTC time of observation          */
    double         dateobsmjd;            /* UTC date (MJD)                   */
    double         exptime;               /* integration time per frame       */
    double        *tf2;                   /* array of TF2                     */
    double        *tf2err;                /* array of TF2             error   */
    double        *tf;                    /* array of TF                      */
    double        *tferr;                 /* array of TF              error   */
    int            stationindex[2];       /* Station indexes                  */
} mat_tf2elem;

/**
   @ingroup oitf2
   @brief Structure mat_oitf2
*/
typedef struct {
    int            extver;                  /*!< extension version (optional)    */
    char          *dateobs;                /* observation date                */
    char          *arrayname;              /* array name                      */
    char          *insname;                /* instrument name                 */
    int            nbchannel;              /* number of spectral channel      */
    int            nbtf2;                  /* number of squared visibility    */
    mat_tf2elem  **list_tf2;               /* array struc of TF2              */
} mat_oitf2;

/*-----------------------------------------------------------------------------
  High Level Structures
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/
mat_tf2elem *mat_tf2elem_new(int nbchannel);

cpl_error_code mat_tf2elem_delete(mat_tf2elem *el);

mat_oitf2 *mat_oitf2_new(int nbtf2, int nbchannel);

cpl_error_code mat_oitf2_delete_nt(mat_oitf2 *oitf2);

mat_oitf2 *mat_oitf2_from_table(cpl_propertylist *plist,
				  cpl_table *table);

cpl_table *mat_oitf2_to_table(mat_oitf2 *oitf2,
			       cpl_propertylist *plist);

mat_oitf2 *mat_oitf2_load_nt(cpl_frame *frame);

cpl_error_code  mat_oitf2_append_nt(char *filename,mat_oitf2 *oitf2);

cpl_error_code mat_oitf2_get_mjd_span(mat_oitf2 *oitf2, double *min_mjd, double *max_mjd);

#endif
