/* $Id: mat_oiwavelength.h,v0.5 2014-06-15 12:56:21 fguitton Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fguitton $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oiwavelength.h $
 */

#ifndef MAT_OIWAVELENGTH_H
#define MAT_OIWAVELENGTH_H

/*-----------------------------------------------------------------------------
  Includes
  ----------------------------------------------------------------------------*/

#include "cpl.h"

/*-----------------------------------------------------------------------------
  Defines
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Low Level Structures
  ----------------------------------------------------------------------------*/

/* Structure mat_oiwavelength */
/**
   @ingroup oiwav
   @brief Structure containing oiwavelength.
*/
typedef struct {
    int        extver;                  /*!< Extension version (optional)    */
    char      *insname;                 /*!< Instrument name                 */
    int        nbchannel;               /*!< Number of spectral channels     */
    double    *effwave;                 /*!< Effective wavelength of each spectral channel [m]. */
    double    *effband;                 /*!< Effective bandwidth of each spectral channel [m]. */
} mat_oiwavelength;

/*-----------------------------------------------------------------------------
  High Level Structures
  ----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  Functions prototypes
  -----------------------------------------------------------------------------*/
mat_oiwavelength *mat_oiwavelength_new(int nbchannel);

cpl_error_code mat_oiwavelength_delete(mat_oiwavelength *oiwavelength);

mat_oiwavelength *mat_oiwavelength_from_table(cpl_propertylist *plist,
					      cpl_table *table);

cpl_table *mat_oiwavelength_to_table(mat_oiwavelength *oiwavelength,
				     cpl_propertylist *plist);

mat_oiwavelength *mat_oiwavelength_load(cpl_frame *frame);

cpl_error_code mat_oiwavelength_append(char *filename,
				       mat_oiwavelength *oiwave);

cpl_boolean mat_oiwavelength_compare(mat_oiwavelength *oiwave1, 
				     mat_oiwavelength *oiwave2);


#endif
