/* $Id: mat_proc_coher_lib.h,v0.5 2014-06-15 12:56:21 fmillour Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: fmillour $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_proc_coher_lib.h $
 */

#ifndef MAT_PROC_COHER_LIB_H
#define MAT_PROC_COHER_LIB_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <string.h>
#include "mat_drl.h"
/* #include "mat_check_tag.h" */
#include "mat_photbeams.h"
#include "mat_corrflux.h"
#include "mat_oifits_init_from_corrflux.h"
#include "mat_compute_vis2.h"
#include "mat_compute_cphase.h"
#include "mat_compute_spectrum.h"
#include "mat_compute_phidiff.h"
#include "mat_utils.h"
#include "mat_shift.h"
#include "mat_oifits.h"
#include "mat_opd_wvpo.h"

/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
int mat_proc_coher_lib(cpl_frameset *frameset, 
		       cpl_parameterlist *parlist,
			 const char *recname);

#endif
