/* $Id: mat_region.h,v0.5 2014-06-15 12:56:21 mheininger Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: mheininger $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_region.h $
 */

#ifndef MAT_REGION_H
#define MAT_REGION_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/
#include <stdio.h>
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/

/* Structure mat_region */
typedef struct {
    int          numregion;                      /* region number             */
    char        *regionname;                     /* origin of the data        */
    int          numdetector;                    /* detector number           */
    int         *numbeam;                        /* beam numbers              */
    int          correlation;                    /* correlation type          */
    int          corner[2];                      /* corner for this region    */
    double       gain;                           /* conversion factor         */
    double       crval[2];                       /* Coordinates at Ref Pixel  */
    float        crpix[2];                       /* Ref Pixel                 */
    char        *ctype[2];                       /* types of coordinates      */
    int          naxis[2];                       /* dimension of each axis    */
} mat_region;

/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
mat_region *mat_region_new(int nr, int nbtel, int x, int y, int nx, int ny);
cpl_error_code mat_region_delete(mat_region *region);
cpl_error_code mat_region_set_name(mat_region *region, const char *name, int nr);
cpl_error_code mat_region_set_area(mat_region *region, int x, int y, int nx, int ny);
mat_region *mat_region_copy(mat_region *dst, const mat_region *src, int nbtel);
mat_region *mat_region_duplicate (const mat_region * region, int nbtel);

#endif
