/* $Id: mat_shift.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_shift.h $
 */

#ifndef MAT_SHIFT_H
#define MAT_SHIFT_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <assert.h>
#include <gsl/gsl_vector.h>
#include "mat_drl.h"
#include "mat_imagingdata.h"
#include "mat_fit_gauss.h"
#include "mat_apply_staticcalib.h"
#include "mat_utils.h"
/*-----------------------------------------------------------------------------
                                   Define
 -----------------------------------------------------------------------------*/
#define izero    0
#define ione     1
#define cptmax   10
#define N_DEG_DISPERSION_LAW 4

/*-----------------------------------------------------------------------------
  Data Structures
  ----------------------------------------------------------------------------*/

/* Structure mat_shiftcoef */
/**
   @ingroup shift
   @brief Structure containing the distrosion coefficients
*/
typedef struct {
    int            order ;                 /* polynomial order                */
    int            numdetector;            /* detector number                 */
    int            numregion;              /* region number                   */
    int            nlig;                   /* region dimension for X or Y axis*/
    cpl_matrix    *coefdistor;             /* matrix of distorsion coef       */
    cpl_matrix    *errdistor;              /* matrix of distorsion coef error */
} mat_shiftcoef;
/* Structure mat_shiftmap */
/**
   @ingroup shift
   @brief Structure containing the Shift map of a detector.

   This structure contains the coefficients for correcting the 
   distorsion and the dispersion law coefficients.
*/

typedef struct {
    cpl_propertylist      *keywords;             /* primary header            */
    mat_imagingdetector   *imgdet;               /* detector geometry         */
    int                    nbreg;                /* Number of scientific regio*/
    mat_shiftcoef        **list_shiftcoefx;      /* distorsion coef for X axis*/
    mat_shiftcoef        **list_shiftcoefy;      /* distorsion coef for Y axis*/
    double                 dispcoef[N_DEG_DISPERSION_LAW+1];          /* dispersion law coefficient*/
    double                 errdispcoef[N_DEG_DISPERSION_LAW+1];       /* error disp law coefficient*/
} mat_shiftmap;



/*-----------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/

mat_shiftmap * mat_shiftmap_load(cpl_frame *frame);

cpl_error_code mat_shiftmap_free(mat_shiftmap *shift);

cpl_error_code mat_shiftmap_save(
				mat_shiftmap *shift,
				cpl_propertylist *pheader,
				cpl_frameset *set_in,
				cpl_frameset *set_sel,
				const cpl_parameterlist *parlist,
				const char *recipe_name,
				const char *pro_cat,
				const char *pro_tech,
				const char *pro_sci,
				char *filename);

mat_shiftmap *mat_compute_shift(mat_gendata **distor_hotdark, 
                                mat_gendata **spectra_hotdark,
                                mat_gendata **distor,
                                mat_gendata **spectra,
                                int nbframes[4],
				cpl_parameter *debug,
				cpl_parameter *obsCorrection);

mat_gendata *mat_apply_shift(mat_gendata *gendata, 
			     mat_shiftmap *shift,
			     int border);

#endif
