/* $Id: mat_utils.h,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_utils.h $
 */

#ifndef MAT_UTILS_H
#define MAT_UTILS_H

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include <string.h>
#include "mat_const.h"
#include "mat_detector.h"
#include "mat_imagingdetector.h"
#include "mat_drl.h"
#include "mat_photbeams.h"
#include "mat_corrflux.h"
#include "mat_shift.h"
#include "mat_apply_opdmod.h"
#include <gsl/gsl_statistics.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_multifit.h>

/*------------------------------------------------------------------------------
                                   Defines
 -----------------------------------------------------------------------------*/
//#define mat_free(ptr) if (ptr != NULL) { fprintf(stdout, "%s:%d cpl_free(" #ptr ") [0x%lx]\n", __FILE__, __LINE__, (unsigned long)ptr); cpl_free(ptr); ptr = NULL; }
#define mat_free(ptr) if (ptr != NULL) { cpl_free(ptr); ptr = NULL; }

#define NB_BASE 6
#define NB_WAVELENGTH 4
#define lambdag 2.21313375 // (2.07767+2.06029+2.17257+2.15652+2.27180+2.26070+2.35531+2.35021)/8.
#define resolg  23.2522899 
#define alphag 0.5

#define factorgL 0.6
#define threshold_ratio_jumpL 0.7

#define factorgN 0.6
#define threshold_ratio_jumpN 0.7


/*------------------------------------------------------------------------------
                                   Functions prototypes
 -----------------------------------------------------------------------------*/
int mat_get_sta_index(char * name);

cpl_error_code mat_get_staxyz_from_staindex(mat_array *oiarray,int staindex,double xyz[3]);

char * basename(const char *name);

void mat_propertylist_get_string(char *dst, int size, cpl_propertylist *plist, 
				 const char *name);
char *mat_propertylist_get_string_default(char *dst, int size,
					  cpl_propertylist *plist, 
					  const char *name,
					  const char *defval);
int mat_propertylist_get_int_default(cpl_propertylist *plist, 
				     const char *name,
				     int defval);
double mat_propertylist_get_double_default(cpl_propertylist *plist, 
					   const char *name,
					   double defval);
char *mat_propertylist_copy_string(cpl_propertylist *plist, const char *name);

int mat_find_central_region(mat_detector *det, mat_imagingdetector *imgdet);

void mat_parameter_get_int_double(cpl_parameter *param, const char *name, 
				  int *i1, int *i2);
void mat_parameter_get_int_triple(cpl_parameter *param, const char *name, 
				  int *i1, int *i2, int *i3);
void mat_parameter_get_int_quadruple(cpl_parameter *param, const char *name, 
				     int *i1, int *i2, int *i3, int *i4);
void mat_parameter_get_int_quintuple(cpl_parameter *param, const char *name, 
				     int *i1, int *i2, int *i3, int *i4, int *i5);

double mat_round(double x, int precision);

double mat_round_relative(double x, int precision);

/* y = q + s*(x-p)**2 */
cpl_boolean mat_calc_poly2_peak(double *x, double *y, double *p, double *q, double *s);

int mat_polyfit_1d(cpl_vector *vecy,cpl_vector *vecw,int deg,cpl_vector *fit,
		   int even);

void remove_spaces(char *str);

int mat_get_nbtel_from_oivis2(mat_oivis2 *oivis2);

int mat_get_nbtel_from_oivis(mat_oivis *oivis);

int mat_get_nbtel_from_oit3(mat_oit3 *oit3);

int mat_combinaison(int n, int p);

int mat_get_nexp(cpl_propertylist *plist);

int mat_get_expno(cpl_propertylist *plist);

int mat_frameset_sort_by_tpl_start(cpl_frameset *frameset, 
				   cpl_frameset *listFrameSet[]);

char *mat_frame_get_tpl_start(cpl_frame *frame);

cpl_boolean mat_check_photometry(cpl_frame *frame);

int mat_find_open_shutter(cpl_propertylist *plist, char *detNameFirst);

int mat_init_photbeams(mat_gendata *gendata, mat_photbeams *photBeams, 
		       int highSens, int *p_nbPhot, int nbTarget);

cpl_error_code mat_apply_kappamatrix(cpl_vector *p_row, cpl_vector *p_param, 
				     cpl_vector *p_res);
int mat_compute_avg_sky(mat_gendata *gendata,cpl_image **avgSky);
int mat_compute_avg_img(mat_gendata *gendata,cpl_image **avgImg);

cpl_boolean mat_check_interf(cpl_frame *frame);
mat_corrflux *mat_init_corrflux(mat_gendata *gendata, char modeFirst[]);
cpl_matrix *mat_switch_localopd_wrt_bcd(mat_gendata *gendata);
int mat_remove_avgsky(mat_gendata *gendata, cpl_image **avgSky, char modeFirst[]);
int mat_remove_avgimg(mat_gendata *gendata, cpl_image **avgImg, char modeFirst[]);
int mat_demodulate_fringes(mat_gendata *gendata,mat_corrflux *corrFlux, char modeFirst[], 
			   int jframe, cpl_vector *dispCoef, cpl_matrix *localOpdBcd);
int mat_lsq_opdmod(mat_gendata *gendata,mat_corrflux *corrFlux, char modeFirst[], 
		   int jframe, cpl_vector *dispCoef, cpl_matrix *localOpdBcd,
		   int *filledInterfCycle, cpl_image **imgInterfCycle, 
		   cpl_vector *localOpd, int *cp, int nbImgInterfCycle, int *jstep);
int mat_lsq_opdmod_last_frame(mat_gendata *gendata,mat_corrflux *corrFlux, char modeFirst[], 
			      cpl_vector *dispCoef, int *filledInterfCycle, cpl_image **imgInterfCycle, 
			      cpl_vector *localOpd, int nbImgInterfCycle, int *jstep);
double mat_image_get_moment(cpl_image *img, int p, int q, double x0,double y0);

double mat_vector_get_moment(cpl_vector *vec, int p);

int mat_remove_origin_phase(mat_corrflux *corrFlux,double shiftMean);

double mat_get_origin_phase(cpl_image *image, cpl_vector *dispCoef, int corner, int nbdetector, int resolution);

double mat_get_lambda(cpl_vector *dispCoef, int iWlen);

double mat_get_pos_fringe_peak(double lambda, int nbdetector, int resolution, int nbPeak);

int mat_get_err_phi(cpl_image *err_in, cpl_image *err_out);

int mat_identify_det(char *detName, char band[], int *detNum);

int mat_identify_wlrng(int detNum, float wlenMin, float wlenMax, int resolution, float *lambdaMin, float *lambdaMax);

int mat_identify_res(char *specResData, char *fil, int detNum, int *resolution);

double mat_abacus_err_phi(double x);

mat_gendata *mat_gendata_select_band(mat_gendata *gendata,cpl_vector *Coef);

mat_gendata *mat_gendata_binning(mat_gendata *genData, int nbbin);
 
cpl_vector *mat_vector_hampel_filter(cpl_vector *in, int k, int t);

char *mat_get_fname_gra(int expno_mat, cpl_frameset *frameset);

void mat_flag_frames_L(mat_gendata *gendata, char *fileGRAVITY, int debug);

void mat_flag_frames_N(mat_gendata *gendata, char *fileGRAVITY, int debug);

void mat_compute_GD_PA_K4N(cpl_vector *time_gra, cpl_vector *time_mt, cpl_matrix **fluxcorR,
			   cpl_matrix **fluxcorI, int bcdmode, cpl_matrix *gdestimated, cpl_matrix *paestimated);

void mat_vector_unwrap(cpl_vector *in, cpl_vector *out);

void mat_add_generic_qc(cpl_propertylist *keywords, cpl_propertylist *qc);

void mat_add_qc_raw_estimates(cpl_propertylist *keywords, cpl_parameterlist *parlist);

#endif
