/* $Id: mat_apply_opdmod-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_apply_opdmod-test.c $
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include "../mat_apply_opdmod.h"

int main(int argc, char ** argv) {
    int i=0;
    int maxstep=10;
    int filledCycle[maxstep];
    cpl_vector *real=NULL;
    cpl_vector *imag=NULL;
    cpl_vector *result=NULL;
    cpl_vector *opd=NULL;
    double localOpd[4]={0.,0.,-10.E-6,10.E-6};
    double lambda=8.;
    (void) argc;
    (void) argv;

    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    // Test mat_apply_demod
    real=cpl_vector_new(468);
    imag=cpl_vector_new(468);
    result=cpl_vector_new(468*2);
    cpl_vector_set(real,234+18,cos(2*CPL_MATH_PI*(localOpd[2]-localOpd[3])/
				   (lambda*1.E-6)));
    cpl_vector_set(imag,234+18,sin(2*CPL_MATH_PI*(localOpd[2]-localOpd[3])/
				   (lambda*1.E-6)));
    cpl_test(mat_apply_demod(real,imag,localOpd,lambda,result,1,2,1,1)==0);
    cpl_test(fabs(cpl_vector_get(result,234+18)+1.0) < 1.E-4);
    //cpl_test(fabs(cpl_vector_get(result,468+234+18)) < 1.E-4);
    cpl_vector_delete(real);
    cpl_vector_delete(imag);
    cpl_vector_delete(result);


    // Test mat_apply_opdmod
    real=cpl_vector_new(468*maxstep);
    imag=cpl_vector_new(468*maxstep);
    result=cpl_vector_new(468*2);
    opd=cpl_vector_new(4*maxstep);
    for(i=0;i<maxstep;i++) {
	filledCycle[i]=1;
	cpl_vector_set(opd,0*maxstep+i,0.);
	cpl_vector_set(opd,1*maxstep+i,0.);
	cpl_vector_set(opd,2*maxstep+i,2.E-6*i*lambda/maxstep);
	cpl_vector_set(opd,3*maxstep+i,3.E-6*i*lambda/maxstep);
	cpl_vector_set(real,i*468+234+18,
		       cos(2*CPL_MATH_PI*(cpl_vector_get(opd,2*maxstep+i)-
				 cpl_vector_get(opd,3*maxstep+i))/
			   (lambda*1.E-6)));
	cpl_vector_set(imag,i*468+234+18,
		       sin(2*CPL_MATH_PI*(cpl_vector_get(opd,2*maxstep+i)-
				 cpl_vector_get(opd,3*maxstep+i))/
			   (lambda*1.E-6)));
    }
    mat_apply_opdmod(maxstep,real,imag,filledCycle,opd,lambda,result,1,2,1);
    cpl_vector_delete(real);
    cpl_vector_delete(imag);
    cpl_vector_delete(result);
    cpl_vector_delete(opd);

// Check for memory leak
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}

