/* $Id: mat_cal_vis-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_cal_vis-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_cal_vis_lib.h"


int main(int argc, char ** argv) {

    cpl_bivector *fref = NULL;
    cpl_bivector *fout = NULL;
    cpl_vector *x = NULL;
    cpl_vector *w = NULL;
    cpl_vector *y = NULL;
    cpl_vector *z = NULL;
    /* struct stat s; */
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    x = cpl_vector_new(4);
    y = cpl_vector_new(4);

    cpl_vector_set(y,0,12.0);
    cpl_vector_set(y,1,8.5);
    cpl_vector_set(y,2,7.0);
    cpl_vector_set(y,3,14.5);

    cpl_vector_set(x,0,1.0);
    cpl_vector_set(x,1,2.0);
    cpl_vector_set(x,2,3.0);
    cpl_vector_set(x,3,4.0);
    fref = cpl_bivector_wrap_vectors(x,y);

    z = cpl_vector_new(4);
    w = cpl_vector_new(4);
    cpl_vector_set(w,0,1.1);
    cpl_vector_set(w,1,2.1);
    cpl_vector_set(w,2,3.2);
    cpl_vector_set(w,3,3.9);
    fout = cpl_bivector_wrap_vectors(w,z);

    cpl_test(LinReg(fref, fout) == CPL_ERROR_NONE);



    /* Check for memory leak */
    cpl_vector_delete(x);
    cpl_vector_delete(y);
    cpl_vector_delete(w);
    cpl_vector_delete(z);
    cpl_bivector_unwrap_vectors(fout);
    cpl_bivector_unwrap_vectors(fref);
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
