/* $Id: mat_oifits_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oifits_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string.h>
#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oiwavelength.h"
#include "../mat_oifits.h"
#include "../mat_drl.h"
#include "../mat_compute_tf2.h"

static cpl_error_code mat_oifits_load_test_basics(void)
{
    cpl_frame *frame;
    mat_oifits *oifits = NULL;
//    mat_oifits *oifitsFoo = NULL;
    mat_oitarget *oitarget = NULL;
    mat_oitarget *oitarget2 = NULL;
    /* char *p_filename = NULL;                                     */
//    char name[100];

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_12.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
    oifits = mat_oifits_load(frame);
/*    sprintf(name,"toto");
    oifitsFoo = mat_compute_tf2(oifits,oifits,0.1,0.01,name,1.,2.,3.);
    cpl_test( oifitsFoo->oitf2 == NULL);
    mat_oifits_delete(oifitsFoo);
*/    
    cpl_test(oifits->array->nbstation == 3);
    cpl_test(oifits->oitarget->targetid == 1);

    oitarget = mat_oitarget_load(frame);
    oitarget2 = mat_oitarget_load(frame);


    cpl_test(mat_oitarget_compare(oitarget,oitarget2) == CPL_TRUE);
    /* oitarget2->targetid = 2; */
    /* cpl_test(mat_oitarget_compare(oitarget,oitarget2) == CPL_FALSE); */

    mat_oifits_delete(oifits);
    mat_oitarget_delete(oitarget);
    mat_oitarget_delete(oitarget2);

    cpl_frame_delete(frame);

    return cpl_error_get_code();
}
/*----------------------------------------------------------------------------*/
/**
  @brief   Unit tests of OIFITS loading module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

 /* TODO Currently deactivated - PLEASE ACTIVATE AGAIN !!!*/
    mat_oifits_load_test_basics();

    cpl_test_error(CPL_ERROR_NONE);
    return cpl_test_end(0);
}
