/* $Id: mat_oispectrum_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oispectrum_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oispectrum.h"
#include "../mat_oifits.h"

int main(int argc, char ** argv) {
    
    cpl_frame *frame;
    mat_oispectrum *oispectrum = NULL;                                    
    /* char datadir[100]; */
    char filename[100];
    int i;
    cpl_table *table=NULL;
    cpl_propertylist *plist=NULL;
    double mjdmin;
    double mjdmax;
    /* struct stat s; */
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    oispectrum=mat_oispectrum_new(2,10);
    cpl_test(oispectrum != NULL);
    for(i=0;i<2;i++) {
      cpl_test(mat_fluxelem_delete(oispectrum->list_flux[i]) == CPL_ERROR_NONE);
      oispectrum->list_flux[i]=mat_fluxelem_new(10);
      cpl_test(oispectrum->list_flux[i] != NULL);
    }	       
    sprintf(filename,"spectrum.fits");
    cpl_test(mat_oispectrum_append(filename,oispectrum) == CPL_ERROR_UNSPECIFIED);

    table=mat_oispectrum_to_table(oispectrum,NULL);
    cpl_test(table != NULL);
    cpl_test(mat_oispectrum_delete(oispectrum) == CPL_ERROR_NONE);
    oispectrum=mat_oispectrum_from_table(plist,table);
    cpl_test(oispectrum != NULL);
    mat_oispectrum_delete(oispectrum);
    cpl_propertylist_delete(plist);
    plist=cpl_propertylist_new();
    cpl_propertylist_append_string(plist,"EXTNAME","OI_FLUX");
    cpl_table_save(table,NULL,plist,filename,CPL_IO_CREATE);
    frame=cpl_frame_new();
    cpl_frame_set_filename(frame,filename);
    oispectrum=mat_oispectrum_load(frame);
    cpl_test(oispectrum != NULL);
    remove(filename);
    cpl_frame_delete(frame);
    cpl_test(mat_oispectrum_get_mjd_span(oispectrum,&mjdmin,&mjdmax) == CPL_ERROR_NONE);
    mat_oispectrum_delete(oispectrum);

    cpl_table_delete(table);
    cpl_propertylist_delete(plist);
    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
