/* $Id: mat_oit3_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oit3_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oit3.h"
#include "../mat_oifits.h"

int main(int argc, char ** argv) {
    
    cpl_frame *frame;
    mat_oit3 *oit3 = NULL;                                    
    cpl_table *table;
    cpl_propertylist *plist;
    mat_t3elem *t3elem;
    double mjdmin;
    double mjdmax;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_07.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
  

    /*Load structure mat_oiwavelength*/
     
    oit3 = mat_oit3_load(frame);
    cpl_frame_delete(frame);

    /*Test attribute oitarget*/
    cpl_test(oit3->list_t3[0]->targetid == 1);
    cpl_test(oit3->list_t3[1]->u1coord-36.285829 < 0.1);
    //printf("test %f\n",oit3->list_t3[1]->u1coord );

    filename = cpl_sprintf("oit3.fits");
    cpl_test(mat_oit3_append(filename,oit3) == CPL_ERROR_UNSPECIFIED);
    cpl_free(filename);

    table=mat_oit3_to_table(oit3,NULL);
    cpl_test(table != NULL);
    cpl_test(mat_oit3_delete(oit3) == CPL_ERROR_NONE);
    plist=cpl_propertylist_new();
    oit3=mat_oit3_from_table(plist,table);
    mat_oit3_delete(oit3);
    
    oit3=mat_oit3_new(2,10);
    cpl_test(oit3 != NULL);
    cpl_test(mat_t3elem_delete(oit3->list_t3[1]) == CPL_ERROR_NONE);
    oit3->list_t3[1]=mat_t3elem_new(10);
    cpl_test(oit3->list_t3[1] != NULL);
    t3elem=mat_oit3_elem_new(oit3);
    cpl_test(t3elem != NULL);
    cpl_test(mat_oit3_get_mjd_span(oit3,&mjdmin,&mjdmax) == CPL_ERROR_NONE);
    mat_oit3_delete(oit3);

    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
