/* $Id: mat_oivis2_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oivis2_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <string.h>
#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oivis2.h"
#include "../mat_oifits.h"

int main(int argc, char ** argv) {
    
    cpl_frame *frame;
    mat_oivis2 *oivis2 = NULL;
    cpl_table *table=NULL;
    cpl_propertylist *plist=NULL;
    mat_vis2elem *vis2elem=NULL;
    double mjdmin;
    double mjdmax;
    (void) argc;
    (void) argv;
    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);


    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_05.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
    oivis2 = mat_oivis2_load(frame);    
    cpl_test(strcmp(oivis2->arrayname,"VLTI"  ) == 0 ); 
    cpl_test(strcmp(oivis2->insname, "AMBER") == 0 );
    cpl_frame_delete(frame);

    plist=cpl_propertylist_new();
    table=mat_oivis2_to_table(oivis2,plist);
    cpl_test(table != NULL);
    cpl_test(mat_oivis2_delete(oivis2) == CPL_ERROR_NONE);
    oivis2=mat_oivis2_from_table(plist,table);
    cpl_test(oivis2 != NULL);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    cpl_test(mat_oivis2_delete(oivis2) == CPL_ERROR_NONE);
    
    oivis2=mat_oivis2_new(2,10);
    cpl_test(oivis2 != NULL);
    cpl_test(mat_vis2elem_delete(oivis2->list_vis2[1]) == CPL_ERROR_NONE);
    oivis2->list_vis2[1]=mat_vis2elem_new(10);
    cpl_test(oivis2->list_vis2[1]!=NULL);
    vis2elem=mat_oivis2_elem_new(oivis2);
    cpl_test(vis2elem != NULL);
    cpl_test( mat_oivis2_append( (char *)"foo.fits", oivis2) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oivis2_get_mjd_span(oivis2,&mjdmin,&mjdmax) == CPL_ERROR_NONE);
    cpl_test(mat_oivis2_delete(oivis2) == CPL_ERROR_NONE);

    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());

    return cpl_test_end(0);
}
