/* $Id: mat_oivis_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oivis_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oivis.h"
#include "../mat_oifits.h"

static cpl_error_code mat_oivis_load_test_basics(void)
{
    
    cpl_frame *frame;
    mat_oivis *oivis = NULL;                                    
    cpl_table *table=NULL;
    cpl_propertylist *plist=NULL;
    mat_viselem *viselem=NULL;
    double mjdmin;
    double mjdmax;

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_07.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);
    oivis = mat_oivis_load(frame);
    cpl_frame_delete(frame);
    cpl_test(oivis->nbvis == 24);
    cpl_test(oivis->list_vis[1]->targetid == 1);


    plist=cpl_propertylist_new();
    table=mat_oivis_to_table(oivis,plist);
    cpl_test(table != NULL);
    cpl_test(mat_oivis_delete(oivis) == CPL_ERROR_NONE);
    oivis=mat_oivis_from_table(plist,table);
    cpl_test(oivis != NULL);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);
    cpl_test(mat_oivis_delete(oivis)== CPL_ERROR_NONE);

    oivis=mat_oivis_new(2,10);
    cpl_test(oivis != NULL);
    cpl_test(mat_viselem_delete(oivis->list_vis[1]) == CPL_ERROR_NONE);
    oivis->list_vis[1]=mat_viselem_new(10);
    cpl_test(oivis->list_vis[1]!=NULL);
    viselem=mat_oivis_elem_new(oivis);
    cpl_test(viselem != NULL);
    cpl_test( mat_oivis_append( (char *)"foo.fits", oivis) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oivis_get_mjd_span(oivis,&mjdmin,&mjdmax) == CPL_ERROR_NONE);
    cpl_test(mat_oivis_delete(oivis) == CPL_ERROR_NONE);

    return cpl_error_get_code();

}
/*----------------------------------------------------------------------------*/
/**
  @brief   Unit tests of OIVIS loading module
 **/
/*----------------------------------------------------------------------------*/
int main(void)
{
    cpl_test_init(PACKAGE_BUGREPORT, CPL_MSG_WARNING);

 /* TODO Currently deactivated - PLEASE ACTIVATE AGAIN !!!*/
    mat_oivis_load_test_basics();

    cpl_test_error(CPL_ERROR_NONE);
    return cpl_test_end(0);
}
