/* $Id: mat_oiwavelength_load-test.c,v0.5 2014-06-15 12:56:21 pberio Exp $
 *
 * This file is part of the ESO Matisse pipeline
 * Copyright (C) 2012-2015 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: pberio $
 * $Date: 2012/06/26 16:52:00 $
 * $Revision: 0.5 $
 * $Name: mat_oiwavelength_load-test.c $
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <cpl.h>
#include <cpl_test.h>
#include <sys/stat.h>
#include "../mat_oiwavelength.h"
#include "../mat_oifits.h"

int main(int argc, char ** argv) {
    
    cpl_frame *frame;
    mat_oiwavelength *oiwavelength;
    mat_oiwavelength *oiwavelength2;
    cpl_table *table=NULL;
    cpl_propertylist *plist=NULL;
    (void) argc;
    (void) argv;

    cpl_test_init("philippe.berio@oca.eu",CPL_MSG_WARNING);

    char *filename = NULL;
    filename = cpl_sprintf("%s/unit_05.fits", MAT_TESTDATADIR);

    frame = cpl_frame_new();
    cpl_frame_set_filename(frame, filename);
    cpl_free(filename);

    /*Load structure mat_oiwavelength*/
    oiwavelength = mat_oiwavelength_load(frame);
    oiwavelength2 = mat_oiwavelength_load(frame);

    //MODIFIER LES VALEURS SUIVANTES EN FONCTION DU FICHIER DE TEST CHOISI  
    /*Test attribute effband*/
    cpl_test((*oiwavelength).effband[1] - 3.04924E-02 < 0.1E-2);
    /*Test attribute nbchannel*/
    cpl_test((*oiwavelength).nbchannel == 45 );
    cpl_test(mat_oiwavelength_compare(oiwavelength,oiwavelength) == CPL_TRUE);
    (*oiwavelength2).nbchannel = 20;
    cpl_test(mat_oiwavelength_compare(oiwavelength,oiwavelength2) == CPL_FALSE);

    cpl_frame_delete(frame);
    cpl_test(mat_oiwavelength_delete(oiwavelength2) == CPL_ERROR_NONE);


    plist=cpl_propertylist_new();
    table=mat_oiwavelength_to_table(oiwavelength,plist);
    cpl_test(table != NULL);
    cpl_test(mat_oiwavelength_delete(oiwavelength) == CPL_ERROR_NONE);
    oiwavelength=mat_oiwavelength_from_table(plist,table);
    cpl_test(oiwavelength != NULL);
    cpl_propertylist_delete(plist);
    cpl_table_delete(table);

    cpl_test( mat_oiwavelength_append( (char *)"foo.fits", oiwavelength) == CPL_ERROR_UNSPECIFIED);
    cpl_test(mat_oiwavelength_delete(oiwavelength) == CPL_ERROR_NONE);
    /*Check for memory leak*/
    cpl_test(cpl_memory_is_empty());
    return cpl_test_end(0);
}
